/*
**	Copyright  1994 Novell, Inc.  All rights reserved.
**
**	Permission is granted to the recipient of this work ("you") to use,
**	reproduce and distribute Novell's original publication of the work free
**	of charge provided that you reproduce the work in its entirety and
**	include all Novell copyright notices as they originally appear.
**
**	Novell grants you permission to modify and distribute copies of this
**	work including any portion of this work (a "modified work") provided
**	that you include prominent notification of such modification along with
**	the date of modification on a modified work; distribute or publish a
**	modified work to third parties under the same conditions and granting
**	the same rights as are extended to you by Novell under this under
**	permission notice; and provided that you include a copy of Novell's
**	original publication of the work along with any copy of a modified
**	work.
**
**	NOVELL MAKES NO WARRANTY, REPRESENTATION OR PROMISE THAT THIS WORK OR A
**	MODIFIED WORK WILL SATISFY YOUR REQUIREMENTS OR THAT THIS WORK OR A
**	MODIFIED WORK IS WITHOUT DEFECT OR ERROR.  NOVELL DISCLAIMS AND
**	EXCLUDES ANY AND ALL IMPLIED WARRANTIES OF MERCHANTABILITY, TITLE OR
**	FITNESS FOR A PARTICULAR PURPOSE.
**
**	IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW WILL NOVELL OR ANY OTHER
**	PARTY BE LIABLE FOR DAMAGES INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL,
**	CONSEQUENTIAL, INDIRECT OR PUNATIVE DAMAGES ARISING OUT OF THE USE OF
**	OR INABLITITY TO USE THE WORK OR A MODIFIED WORK.
**
**	DSOUTPUT.H - October 1994
**
**	Declaration of the DSOutput class.
**
**	Author: John Buckle, Asia Pacific Support Centre, Novell Australia
**	==================================================================
**	9 Jan 1995           First release              John Buckle
*/

# ifndef dsOUTPUT_H
# define dsOUTPUT_H

# include "dscontex.h"

/*
** DSCPP_NO_COUNT	Used as a default argument to List...() functions
*/

# define  DSCPP_NO_COUNT	((NWCOUNT) -1)

/*
** Class DSOutput
**
**	Used to initialise an NWDS buffer for output from functions such as
**	NWDSRead, NWDSList. The assignment operator and initialisation
**	contructor are declared but not defined, this is to stop the directory
**	buffer being copied and inadvertantly released.
*/

class _DSCLASSDEC DSOutput : public virtual DSContext
{
protected:

	NWDS_BUFFER NWFAR *	Output ;
	static	char		ObjectValue[DEFAULT_MESSAGE_LEN] ;
	static	char		ObjectAttr [MAX_SCHEMA_NAME_BYTES] ;
	static	char		ObjectName [MAX_DN_BYTES] ;
	static	char		CurrentAttr[MAX_SCHEMA_NAME_BYTES] ;
	static	char		CurrentName[MAX_DN_BYTES] ;

public:
				DSOutput(WORD size = DEFAULT_MESSAGE_LEN) ;
				DSOutput(DSOutput &) ;
	virtual		      ~ DSOutput() ;
	void			operator=(DSOutput &) ;

	NWDS_BUFFER NWFAR *	output()	{ return Output ; }

	NWDSCCODE	ComputeAttrValSize(NWSYNTAX_ID syntax, NWSIZE & size)
				{ return Status = NWDSComputeAttrValSize(dContext,Output,syntax,& size) ; }
	NWDSCCODE	GetAttrCount(NWCOUNT & count)
				{ return Status = NWDSGetAttrCount(dContext,Output,& count) ; }
	NWDSCCODE	GetAttrName(NWPSTR attrName, NWCOUNT & valCount, NWSYNTAX_ID & syntax)
				{ return Status = NWDSGetAttrName(dContext,Output,attrName,& valCount,& syntax) ; }
	NWDSCCODE	GetAttrVal(NWSYNTAX_ID syntax, void * value)
				{ return Status = NWDSGetAttrVal(dContext,Output,syntax,value) ; }
	NWDSCCODE	GetClassItem(NWPSTR itemName)
				{ return Status = NWDSGetClassItem(dContext,Output,itemName) ; }
	NWDSCCODE	GetClassItemCount(NWCOUNT & count)
				{ return Status = NWDSGetClassItemCount(dContext,Output,& count) ; }
	NWDSCCODE	GetObjectCount(NWCOUNT & count)
				{ return Status = NWDSGetObjectCount(dContext,Output,& count) ; }
	NWDSCCODE	GetObjectName(NWPSTR object, NWCOUNT & count, NWOBJECT_INFO * info)
				{ return Status = NWDSGetObjectName(dContext,Output,object,& count,info) ; }

virtual	void		InitLoop      (DSIteration * iteration) ;
virtual	void		ExitLoop      (DSIteration * iteration) ;
virtual	NWDSCCODE	ListObjects   (DSIteration * iteration) ;
virtual	NWDSCCODE	ListAttributes(DSIteration * iteration, NWCOUNT attrCount  = DSCPP_NO_COUNT) ;
virtual	NWDSCCODE	ListValues    (DSIteration * iteration, NWCOUNT valueCount = DSCPP_NO_COUNT, NWSYNTAX_ID syntax = 0) ;
virtual	NWDSCCODE	InitObject    (DSIteration * iteration, NWPSTR  objectName, void * info) ;
virtual	NWDSCCODE	SetAttrName   (DSIteration * iteration, NWPSTR  objectAttr, NWSYNTAX_ID syntax) ;
} ;

# endif dsOUTPUT_H
