/*
**	Copyright  1994 Novell, Inc.  All rights reserved.
**
**	Permission is granted to the recipient of this work ("you") to use,
**	reproduce and distribute Novell's original publication of the work free
**	of charge provided that you reproduce the work in its entirety and
**	include all Novell copyright notices as they originally appear.
**
**	Novell grants you permission to modify and distribute copies of this
**	work including any portion of this work (a "modified work") provided
**	that you include prominent notification of such modification along with
**	the date of modification on a modified work; distribute or publish a
**	modified work to third parties under the same conditions and granting
**	the same rights as are extended to you by Novell under this under
**	permission notice; and provided that you include a copy of Novell's
**	original publication of the work along with any copy of a modified
**	work.
**
**	NOVELL MAKES NO WARRANTY, REPRESENTATION OR PROMISE THAT THIS WORK OR A
**	MODIFIED WORK WILL SATISFY YOUR REQUIREMENTS OR THAT THIS WORK OR A
**	MODIFIED WORK IS WITHOUT DEFECT OR ERROR.  NOVELL DISCLAIMS AND
**	EXCLUDES ANY AND ALL IMPLIED WARRANTIES OF MERCHANTABILITY, TITLE OR
**	FITNESS FOR A PARTICULAR PURPOSE.
**
**	IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW WILL NOVELL OR ANY OTHER
**	PARTY BE LIABLE FOR DAMAGES INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL,
**	CONSEQUENTIAL, INDIRECT OR PUNATIVE DAMAGES ARISING OUT OF THE USE OF
**	OR INABLITITY TO USE THE WORK OR A MODIFIED WORK.
**
**	DSCONTEX.H - October 1994
**
**	Declaration of the DSContext class.
**
**	Author: John Buckle, Asia Pacific Support Centre, Novell Australia
**	==================================================================
**	9 Jan 1995           First release              John Buckle
*/

# ifndef dsCONTEX_H
# define dsCONTEX_H

# include "dsdefs.h"

/*
** Class DSIteration	Forward declaration of the class used to
**			return the results of the iteration functions.
*/

class _DSCLASSDEC DSIteration ;

/*
** Class DSContext
**
**	Used to access the Directory Services. This class acts as a virtual
**	base for the DS buffer classes. The assignment operator and
**	initialisation contructor are declared but not defined, this is to
**	stop the directory context handle being copied and inadvertantly
**	released.
*/

#define DSCPP_CONTEXT_FLAGS	(DCV_DEREF_ALIASES  | \
				 DCV_XLATE_STRINGS  | \
				 DCV_TYPELESS_NAMES | \
				 DCV_CANONICALIZE_NAMES)

class _DSCLASSDEC DSContext
{
protected:

	NWDSCCODE		Status ;
	NWDSContextHandle	dContext ;

public:
				DSContext(NWPSTR context = 0, DWORD = DSCPP_CONTEXT_FLAGS) ;
				DSContext(DSContext &) ;
	virtual		      ~	DSContext() ;
	void			operator=(DSContext &) ;
				operator NWDSContextHandle()	{ return dContext ; }

	virtual	void   		InitLoop(DSIteration *)	{ ; }
	virtual	void   		ExitLoop(DSIteration *)	{ ; }
	NWDSCCODE		status() 	{ return Status ; }
	NWDSCCODE		reset () 	{ return Status = 0 ; }

	NWDSCCODE	AbbreviateName(NWPSTR inName, NWPSTR outName)
				{ return Status = NWDSAbbreviateName(dContext,inName,outName) ; }
	NWDSCCODE	AddSecurityEquiv(NWPSTR object, NWPSTR equalTo)
				{ return Status = NWDSAddSecurityEquiv(dContext,object,equalTo) ; }
	NWDSCCODE	AuditGetObjectID(NWPSTR object, NWCONN_HANDLE & conn, DWORD & objectID)
				{ return Status = NWDSAuditGetObjectID(dContext,object,& conn,& objectID) ; }
	NWDSCCODE	CanonicalizeName(NWPSTR inName, NWPSTR outName)
				{ return Status = NWDSCanonicalizeName(dContext,inName,outName) ; }
	NWDSCCODE	ChangeObjectPassword(NWPSTR object, NWPSTR oldPassword, NWPSTR newPassword)
				{ return Status = NWDSChangeObjectPassword(dContext,0,object,oldPassword,newPassword) ; }
	NWDSCCODE	CIStringsMatch(NWPSTR string1, NWPSTR string2, int & matches)
				{ return Status = NWDSCIStringsMatch(dContext,string1,string2,& matches) ; }
	NWDSCCODE	CloseIteration(NWDS_ITERATION iterHandle, NWDS_OPERATION operation)
				{ return Status = NWDSCloseIteration(dContext,iterHandle,operation) ; }
	NWDSCCODE	GenerateObjectKeyPair(NWPSTR object, NWPSTR password)
				{ return Status = NWDSGenerateObjectKeyPair(dContext,object,password,0) ; }
	NWDSCCODE	GetBinderyContext(NWCONN_HANDLE connHandle, BYTE * binderyContext)
				{ return Status = NWDSGetBinderyContext(dContext,connHandle,binderyContext) ; }
	NWDSCCODE	GetContext(int key, void * value)
				{ return Status = NWDSGetContext(dContext,key,value) ; }
	NWDSCCODE	GetContext(NWPSTR context)
				{ return Status = NWDSGetContext(dContext,DCK_NAME_CONTEXT,context) ; }
	NWDSCCODE	GetCountByClassAndName(NWPSTR object, NWPSTR className, NWPSTR subordinate, LONG & count)
				{ return Status = NWDSGetCountByClassAndName(dContext,object,className,subordinate,& count) ; }
	NWDSCCODE	GetEffectiveRights(NWPSTR subject, NWPSTR object, NWPSTR attribute, DWORD & privileges)
				{ return Status = NWDSGetEffectiveRights(dContext,subject,object,attribute,& privileges) ; }
	NWDSCCODE	GetServerDN(NWCONN_HANDLE connHandle, NWPSTR distName)
				{ return Status = NWDSGetServerDN(dContext,connHandle,distName) ; }
	NWDSCCODE	Login(NWPSTR object, NWPSTR password, NWDS_VALIDITY period = 0)
				{ return Status = NWDSLogin(dContext,0,object,password,period) ; }
	NWDSCCODE	LoginToNDS(NWPSTR object, NWPSTR password = 0, NWDS_VALIDITY period = 0) ;

	NWDSCCODE	Logout()
				{ return Status = NWDSLogout(dContext) ; }
	NWDSCCODE	LogoutFromNDS() ;

	NWDSCCODE	MapIDToName(NWCONN_HANDLE conn, NWOBJ_ID id, NWPSTR name)
				{ return Status = NWDSMapIDToName(dContext,conn,id,name) ; }
	NWDSCCODE	MapNameToID(NWCONN_HANDLE conn, NWPSTR name, NWOBJ_ID & id)
				{ return Status = NWDSMapNameToID(dContext,conn,name,&id) ; }
	NWDSCCODE	ModifyDN(NWPSTR oldDN, NWPSTR newDN, NWFLAGS deleteOldRDN)
				{ return Status = NWDSModifyDN(dContext,oldDN,newDN,deleteOldRDN) ; }
	NWDSCCODE	ModifyRDN(NWPSTR oldRDN, NWPSTR newRDN, NWFLAGS deleteOldRDN)
				{ return Status = NWDSModifyRDN(dContext,oldRDN,newRDN,deleteOldRDN) ; }
	NWDSCCODE	MoveObject(NWPSTR object, NWPSTR parent, NWPSTR destination)
				{ return Status = NWDSMoveObject(dContext,object,parent,destination) ; }
	NWDSCCODE	OpenStream(NWPSTR object, NWPSTR attribute, NWDS_FLAGS flags, NWDS_LOGIN_FILE & file)
				{ return Status = NWDSOpenStream(dContext,object,attribute,flags,& file) ; }
	NWDSCCODE	ReadObjectInfo(NWPSTR object, NWPSTR distName, NWOBJECT_INFO * info)
				{ return Status = NWDSReadObjectInfo(dContext,object,distName,info) ; }
	NWDSCCODE	ReadSyntaxDef(NWSYNTAX_ID syntaxID, NWSYNTAX_INFO * syntaxDef)
				{ return Status = NWDSReadSyntaxDef(dContext,syntaxID,syntaxDef) ; }
	NWDSCCODE	RemoveAllTypes(NWPSTR inName, NWPSTR outName)
				{ return Status = NWDSRemoveAllTypes(dContext,inName,outName) ; }
	NWDSCCODE	RemoveObject(NWPSTR object)
				{ return Status = NWDSRemoveObject(dContext,object) ; }
	NWDSCCODE	RemSecurityEquiv(NWPSTR object, NWPSTR equalTo)
				{ return Status = NWDSRemSecurityEquiv(dContext,object,equalTo) ; }
	NWDSCCODE	SetContext(int key, void * value)
				{ return Status = NWDSSetContext(dContext,key,value) ; }
	NWDSCCODE	SetContext(NWPSTR context)
				{ return Status = NWDSSetContext(dContext,DCK_NAME_CONTEXT,context) ; }
	NWDSCCODE	VerifyObjectPassword(NWPSTR object, NWPSTR password)
				{ return Status = NWDSVerifyObjectPassword(dContext,0,object,password) ; }
	NWDSCCODE	WhoAmI(NWPSTR object)
				{ return Status = NWDSWhoAmI(dContext,object) ; }
} ;

# endif dsCONTEX_H
