/*
**	Copyright  1994 Novell, Inc.  All rights reserved.
**
**	Permission is granted to the recipient of this work ("you") to use,
**	reproduce and distribute Novell's original publication of the work free
**	of charge provided that you reproduce the work in its entirety and
**	include all Novell copyright notices as they originally appear.
**
**	Novell grants you permission to modify and distribute copies of this
**	work including any portion of this work (a "modified work") provided
**	that you include prominent notification of such modification along with
**	the date of modification on a modified work; distribute or publish a
**	modified work to third parties under the same conditions and granting
**	the same rights as are extended to you by Novell under this under
**	permission notice; and provided that you include a copy of Novell's
**	original publication of the work along with any copy of a modified
**	work.
**
**	NOVELL MAKES NO WARRANTY, REPRESENTATION OR PROMISE THAT THIS WORK OR A
**	MODIFIED WORK WILL SATISFY YOUR REQUIREMENTS OR THAT THIS WORK OR A
**	MODIFIED WORK IS WITHOUT DEFECT OR ERROR.  NOVELL DISCLAIMS AND
**	EXCLUDES ANY AND ALL IMPLIED WARRANTIES OF MERCHANTABILITY, TITLE OR
**	FITNESS FOR A PARTICULAR PURPOSE.
**
**	IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW WILL NOVELL OR ANY OTHER
**	PARTY BE LIABLE FOR DAMAGES INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL,
**	CONSEQUENTIAL, INDIRECT OR PUNATIVE DAMAGES ARISING OUT OF THE USE OF
**	OR INABLITITY TO USE THE WORK OR A MODIFIED WORK.
**
**	DSAUDIT.H - October 1994
**
**	Declaration of the DSAudit class.
**
**	Author: John Buckle, Asia Pacific Support Centre, Novell Australia
**	==================================================================
**	9 Jan 1995           First release              John Buckle
*/

# ifndef dsAUDIT_H
# define dsAUDIT_H

# include "dsdefs.h"
# include "dsconn.h"

/*
** Class DSAudit
**
**	Used to administer NDS Audit sessions. Volume and container auditing
**	APIs have been combined into a single API set. The type of auditing
**	being performed depends on whether LoginAsVolumeAuditor or
**	LoginAsContainerAuditor is executed.
*/

class _DSCLASSDEC DSAudit : public DSConn
{
protected:
	DWORD			ObjectID ;
	WORD			AuditContainer ;
	WORD			FileCode ;
	BYTE			AuditKey[40] ;
	NWFLAGS			EofFlag ;
public:
			DSAudit(NWDSContextHandle context, NWPSTR server)
				: DSConn(context,server)
				{ ObjectID = 0 ; }
			DSAudit(NWDSContextHandle context, NWCONN_HANDLE conn = 0)
				: DSConn(context,conn)
				{ ObjectID = 0 ; }
	virtual	      ~	DSAudit() ;

	NWDSCCODE	AddAuditProperty(DWORD objectID) ;
	NWDSCCODE	ChangeAuditorPassword(BYTE * password, BYTE level) ;
	NWDSCCODE	ChangeAuditProperty(DWORD objectID, BYTE flag) ;
	NWDSCCODE	CheckAuditAccess() ;
	NWDSCCODE	CheckAuditLevelTwoAccess() ;
	NWDSCCODE	CloseOldAuditingFile() ;
	NWDSCCODE	DeleteOldAuditingFile() ;
	NWDSCCODE	DisableAuditingOnObject() ;
	NWDSCCODE	EnableAuditingOnObject() ;
	NWDSCCODE	GetAuditingFlags(NWFLAGS & flags) ;
	NWDSCCODE	GetObjectAuditStats(void * buffer, WORD size = 0) ;
	NWDSCCODE	InitAuditFileRead(int fileCode) ;
	NWDSCCODE	InitAuditLevelTwoPassword(BYTE * password) ;
	NWDSCCODE	IsObjectBeingAudited(DWORD objectID) ;
	NWDSCCODE	LoginAsVolumeAuditor(DWORD volume, BYTE * password) ;
	NWDSCCODE	LoginAsContainerAuditor(DWORD container, BYTE * password) ;
	NWDSCCODE	LogoutAsAuditor() ;
	NWDSCCODE	ReadAuditConfigHeader(void * buffer, WORD size = 0) ;
	NWDSCCODE	ReadAuditingBitMap(NWAuditBitMap * buffer, WORD size = sizeof(NWAuditBitMap)) ;
	NWDSCCODE	ReadAuditingFileRecord(void * buffer, WORD bufferSize, WORD & returnSize) ;
	NWDSCCODE	RemoveAuditProperty(DWORD objectID) ;
	NWDSCCODE	ResetAuditHistoryFile() ;
	NWDSCCODE	ResetAuditingFile() ;
	NWDSCCODE	WriteAuditConfigHeader(void * buffer) ;
	NWDSCCODE	WriteAuditingBitMap(NWEventBitMap * buffer) ;
} ;

# endif dsAUDIT_H
