/*
** AUDITC <container>
**
**	Login as container auditor and list entries in the audit file.
**
**	Author: John Buckle, Asia Pacific Support Centre, Novell Australia.
*/

extern unsigned _stklen = 8192;

# include <stdio.h>
# include <conio.h>
# include <io.h>

# include <dscontext.h>
# include <dslocale.h>
# include <dsconn.h>
# include <dsaudit.h>

int main(int argc, char * argv[])
{
	if (argc != 2){
		fprintf(stderr,"usage: AUDITC container-context\n") ;
		return 0 ;
		}

	DSLocale  dsLocale ;
	DSContext dsContext ;

	if (dsLocale.status()){
		printf("Cannot initialise unicode - 0x%X\n",dsLocale.status()) ;
		return 0 ;
		}
	if (dsContext.status()){
		printf("Cannot create context - 0x%X\n",dsContext.status()) ;
		return 0 ;
		}

	NWCONN_HANDLE	conn ;
	DWORD		objectID ;
	char		buffer[1024] ;
	char		name[256] ;
	WORD		retSize ;

	dsContext.AuditGetObjectID(argv[1],conn,objectID) ;
	if (dsContext.status()){
		printf("Cannot get audit object ID - 0x%X\n",dsContext.status()) ;
		return 0 ;
		}

	DSAudit dsAudit(dsContext,conn) ;
	if (dsAudit.status()){
		printf("Cannot create audit object - 0x%X\n",dsAudit.status()) ;
		return 0 ;
		}
	char *	password = getpass("Audit password: ") ;

	if (dsAudit.LoginAsContainerAuditor(objectID,(BYTE*)password)){
		printf("Cannot login as auditor - 0x%X\n",dsAudit.status()) ;
		return 0 ;
		}
	dsAudit.InitAuditFileRead(0) ;
	if (dsAudit.status())
		printf("Initialisation failed - 0x%X\n",dsAudit.status()) ;

	WORD		count = 0 ;
	ftime *		date ;
	AuditDSRecord *	audit = (AuditDSRecord *) buffer ;

	while (dsAudit.ReadAuditingFileRecord(buffer,sizeof(buffer),retSize) == 0){
		if (retSize > 0){
			count ++ ; date = (ftime *) & audit->dosDateTime ;
			if (dsAudit.MapIDToName(audit->userID,name))
				sprintf(name,"0x%X",dsAudit.status()) ;

			printf("EventID           %d\n",audit->eventTypeID) ;
			printf("User ID           %08lX %s\n",audit->userID,name) ;
			printf("Time              %02u/%02u/%02u %02u:%02u:%02u\n",
					date->ft_day, date->ft_month,date->ft_year,
					date->ft_hour,date->ft_min,  date->ft_tsec*2) ;
			}
		}
	printf("\n%d records read\n",count) ;

	if (dsAudit.status())
		printf("Reading failed - 0x%X\n",dsAudit.status()) ;

	if (dsAudit.LogoutAsAuditor()){
		printf("Cannot logout as auditor - 0x%X\n",dsAudit.status()) ;
		return 0 ;
		}

	return 0 ;
}

