/*
** FILE: SEARCH.H
** PROG: UEXPORT.EXE
** DATE: September 1994
** NAME: John Buckle
**
**	Declaration of the SearchUserClass class.
*/

# ifndef  Search_H
# define  Search_H

# include <nwnet.h>

class DSBuffer ;
class DSValue ;
class Control ;
class ostream ;

/*
** Class DSSearch
**
**	Used to interface the function DSContext::searchObjects() with other classes.
**	Class can be derived from DSSearch to overrided the virtual functions so
**	that the results of DSContext::searchObjects() can be processed.
*/

class DSSearch
{
public:
			DSSearch() { ; }
virtual		      ~	DSSearch() { ; }
virtual	NWDSCCODE	readObjectName(char *, NWCOUNT, NWOBJECT_INFO *)	{ return 0 ; }
virtual	NWDSCCODE	readAttrValue (char *, NWCOUNT, DSValue * )		{ return 0 ; }
virtual	NWDSCCODE	saveObjectName(char *)					{ return 0 ; }
virtual	NWDSCCODE	initSearch (DSBuffer *)					{ return 0 ; }
virtual	NWDSCCODE	exitSearch ()						{ return 0 ; }
} ;

/*
** Class SearchUserClass
**
**	Used to interface the function Context::searchObjects() with the class Control.
**	The contructor for SearchUserClass takes a reference to a Control class and a
**	ofstream to output the data returned from Context::searchObjects().
*/

class SearchUserClass : public DSSearch
{
	NWDSCCODE	Status ;
	Control *	control ;
	ostream *	stream ;
	int		inUse ;
public:
			SearchUserClass(Control * c, ostream * s)
			: DSSearch()			{ control = c ; stream = s ; }
		      ~	SearchUserClass() { ; }

	NWDSCCODE	status()			{ return Status  ; }
	NWDSCCODE	reset ()			{ return Status = 0 ; }

	NWDSCCODE	readAttrValue (char * name, NWCOUNT count, DSValue * data) ;
	NWDSCCODE	saveObjectName(char * name) ;
	NWDSCCODE	initSearch(DSBuffer * buffer) ;
	NWDSCCODE	exitSearch() ;
} ;

# endif Search_H