/*
** SCRIPT <name>
**
**	Display and modify a user's login script.
**
**	Author: John Buckle, Asia Pacific Support Centre, Novell Australia.
*/

# include "dsbuffer.h"
# include "dslocale.h"
# include "dsfile.h"

# include <fstream.h>
# include <stdio.h>
# include <fcntl.h>

void PrintFile(int fd) ;
int  ReportError(NWPSTR message,NWDSCCODE code = 0) ;

int main(int argc, char * argv[])
{
	if (argc != 2)
		return ReportError("usage: SCRIPT user-name\n") ;

	DSLocale dsLocale ;
	DSBuffer dsBuffer ;
	DSFile	 dsFile(dsBuffer) ;

	if (dsLocale.status())
		return ReportError("SCRIPT: cannot load unicode tables - 0x%X\n",dsLocale.status()) ;

	if (dsBuffer.status())
		return ReportError("SCRIPT: cannot create NDS buffer - 0x%X\n",dsBuffer.status()) ;

	if (dsFile.open(argv[1],"Login Script",DS_READ_STREAM|DS_WRITE_STREAM) == -1)
		return ReportError("SCRIPT: cannot open user's login script - 0x%X\n",dsFile.status()) ;

	printf("Login Script before change\n") ;
	PrintFile(dsFile) ;

	dsFile.lseek(0,SEEK_END) ;
	dsFile.write("REM New line at the end\r\n",25) ;
	dsFile.lseek(0,SEEK_SET) ;

	printf("Login Script after change\n") ;
	PrintFile(dsFile) ;

	return 0 ;
}

void PrintFile(int fd)
{
ifstream stream(fd) ;
char	 buffer[512] ;

	while (stream.getline(buffer,sizeof(buffer)))
		puts(buffer) ;
}

int reportError(NWPSTR message,NWDSCCODE code = 0)
{
	fprintf(stderr,message,code) ;
	return 0 ;
}
