/*
**	Copyright  1994 Novell, Inc.  All rights reserved.
**
**	Permission is granted to the recipient of this work ("you") to use,
**	reproduce and distribute Novell's original publication of the work free
**	of charge provided that you reproduce the work in its entirety and
**	include all Novell copyright notices as they originally appear.
**
**	Novell grants you permission to modify and distribute copies of this
**	work including any portion of this work (a "modified work") provided
**	that you include prominent notification of such modification along with
**	the date of modification on a modified work; distribute or publish a
**	modified work to third parties under the same conditions and granting
**	the same rights as are extended to you by Novell under this under
**	permission notice; and provided that you include a copy of Novell's
**	original publication of the work along with any copy of a modified
**	work.
**
**	NOVELL MAKES NO WARRANTY, REPRESENTATION OR PROMISE THAT THIS WORK OR A
**	MODIFIED WORK WILL SATISFY YOUR REQUIREMENTS OR THAT THIS WORK OR A
**	MODIFIED WORK IS WITHOUT DEFECT OR ERROR.  NOVELL DISCLAIMS AND
**	EXCLUDES ANY AND ALL IMPLIED WARRANTIES OF MERCHANTABILITY, TITLE OR
**	FITNESS FOR A PARTICULAR PURPOSE.
**
**	IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW WILL NOVELL OR ANY OTHER
**	PARTY BE LIABLE FOR DAMAGES INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL,
**	CONSEQUENTIAL, INDIRECT OR PUNATIVE DAMAGES ARISING OUT OF THE USE OF
**	OR INABLITITY TO USE THE WORK OR A MODIFIED WORK.
**
**	DSVMULTI.H - October 1994
**
**	Declaration of the DSVMultiValue class used to hold several NDS
**	values.
**
**	Author: John Buckle, Asia Pacific Support Centre, Novell Australia
**	==================================================================
**	9 Jan 1995           First release              John Buckle
*/

# ifndef dsVMULTI_H
# define dsVMULTI_H

# include "dsvalue.h"
# include "dsvlist.h"

/*
** Struct DSVMultiValue
**
**	Used as a platform for storing multiple DSValue objects.
*/

struct _DSCLASSDEC DSVMultiValue : public DSValue
{
	DSVList<DSValue>	List ;

	NWDSCCODE	assign (NWSYNTAX_ID, void *) ;
	NWDSCCODE	release(int index = DSCPP_DEF_INDEX) ;
	NWDSCCODE	compare(DSValue *) ;

			DSVMultiValue()				{ ; }
	virtual	      ~	DSVMultiValue()				{ release() ; }

	DSValue *	operator[](int index)			{ return List[index] ; }
	DSValueType	type()					{ return DSCPP_MULTI_VALUE ; }
	NWPSTR		text(int index = DSCPP_DEF_INDEX)	{ return List[index]->text() ; }
	WORD		count()					{ return List.Count ; }

#ifdef DSCPP_IOSTREAM
	ostream &	stream(ostream & s) ;
#endif DSCPP_IOSTREAM
} ;

typedef DSVListNode<DSValue>	 DSValueNode ;
typedef	DSVListIterator<DSValue> DSValueIterator ;

#endif dsVMULTI_H

