/*
**	Copyright  1994 Novell, Inc.  All rights reserved.
**
**	Permission is granted to the recipient of this work ("you") to use,
**	reproduce and distribute Novell's original publication of the work free
**	of charge provided that you reproduce the work in its entirety and
**	include all Novell copyright notices as they originally appear.
**
**	Novell grants you permission to modify and distribute copies of this
**	work including any portion of this work (a "modified work") provided
**	that you include prominent notification of such modification along with
**	the date of modification on a modified work; distribute or publish a
**	modified work to third parties under the same conditions and granting
**	the same rights as are extended to you by Novell under this under
**	permission notice; and provided that you include a copy of Novell's
**	original publication of the work along with any copy of a modified
**	work.
**
**	NOVELL MAKES NO WARRANTY, REPRESENTATION OR PROMISE THAT THIS WORK OR A
**	MODIFIED WORK WILL SATISFY YOUR REQUIREMENTS OR THAT THIS WORK OR A
**	MODIFIED WORK IS WITHOUT DEFECT OR ERROR.  NOVELL DISCLAIMS AND
**	EXCLUDES ANY AND ALL IMPLIED WARRANTIES OF MERCHANTABILITY, TITLE OR
**	FITNESS FOR A PARTICULAR PURPOSE.
**
**	IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW WILL NOVELL OR ANY OTHER
**	PARTY BE LIABLE FOR DAMAGES INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL,
**	CONSEQUENTIAL, INDIRECT OR PUNATIVE DAMAGES ARISING OUT OF THE USE OF
**	OR INABLITITY TO USE THE WORK OR A MODIFIED WORK.
**
**	DSLOCALE.H - October 1994
**
**	Declaration of the DSLocale class.
**
**	Author: John Buckle, Asia Pacific Support Centre, Novell Australia
**	==================================================================
**	9 Jan 1995           First release              John Buckle
*/

# ifndef dsLOCALE_H
# define dsLOCALE_H

# include "dsdefs.h"

/*
** Class DSLocale
**
**	Used to initialise and release the unicode tables. Normally there would
**	only be one instance of this class in an application. The member field
**	Initialised is used to stop the unicode tables being reloaded if
**	multiple DSLocale objects exist.
*/

class _DSCLASSDEC DSLocale
{
protected:

	NWDSCCODE		Status ;
	void *			LocalToUnicodeHandle ;
	void *			UnicodeToCollationHandle ;
	void *			UnicodeToLocalHandle ;
	void *			UnicodeToMonocaseHandle ;
	static			Initialised ;
	int			foundUnicodeTables(int drive,int country, int codePage) ;

public:
				DSLocale() ;
				DSLocale(int country, int codePage) ;
	virtual		      ~ DSLocale() ;

	static			loaded()	{ return Initialised ; }
	NWDSCCODE		status()	{ return Status ; }
	NWDSCCODE		reset()		{ return Status = 0 ; }

	NWDSCCODE		LocalToUnicode(unicode * dest, size_t maxLen, NWPSTR src, size_t & len)
					{ return Status = NWLocalToUnicode(LocalToUnicodeHandle,dest,maxLen,(BYTE*)src,0,& len) ; }
	NWDSCCODE		UnicodeToCollation(unicode * dest, size_t maxLen, unicode * src, size_t * len)
					{ return Status = NWUnicodeToCollation(UnicodeToCollationHandle,dest,maxLen,src,0,len) ; }
	NWDSCCODE		UnicodeToLocal(NWPSTR dest, size_t maxLen, unicode * src, size_t & len)
					{ return Status = NWUnicodeToLocal(UnicodeToLocalHandle,(BYTE*)dest,maxLen,src,0,& len) ; }
	NWDSCCODE		UnicodeToMonocase(unicode * dest, size_t maxLen, unicode * src, size_t * len)
					{ return Status = NWUnicodeToMonocase(UnicodeToMonocaseHandle,dest,maxLen,src,len) ; }
} ;

# endif dsLOCALE_H
