/*
**	Copyright  1994 Novell, Inc.  All rights reserved.
**
**	Permission is granted to the recipient of this work ("you") to use,
**	reproduce and distribute Novell's original publication of the work free
**	of charge provided that you reproduce the work in its entirety and
**	include all Novell copyright notices as they originally appear.
**
**	Novell grants you permission to modify and distribute copies of this
**	work including any portion of this work (a "modified work") provided
**	that you include prominent notification of such modification along with
**	the date of modification on a modified work; distribute or publish a
**	modified work to third parties under the same conditions and granting
**	the same rights as are extended to you by Novell under this under
**	permission notice; and provided that you include a copy of Novell's
**	original publication of the work along with any copy of a modified
**	work.
**
**	NOVELL MAKES NO WARRANTY, REPRESENTATION OR PROMISE THAT THIS WORK OR A
**	MODIFIED WORK WILL SATISFY YOUR REQUIREMENTS OR THAT THIS WORK OR A
**	MODIFIED WORK IS WITHOUT DEFECT OR ERROR.  NOVELL DISCLAIMS AND
**	EXCLUDES ANY AND ALL IMPLIED WARRANTIES OF MERCHANTABILITY, TITLE OR
**	FITNESS FOR A PARTICULAR PURPOSE.
**
**	IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW WILL NOVELL OR ANY OTHER
**	PARTY BE LIABLE FOR DAMAGES INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL,
**	CONSEQUENTIAL, INDIRECT OR PUNATIVE DAMAGES ARISING OUT OF THE USE OF
**	OR INABLITITY TO USE THE WORK OR A MODIFIED WORK.
**
**	DSCONN.H - October 1994
**
**	Declaration of the DSConn class.
**
**	Author: John Buckle, Asia Pacific Support Centre, Novell Australia
**	==================================================================
**	9 Jan 1995           First release              John Buckle
*/

# ifndef dsCONN_H
# define dsCONN_H

# include "dsdefs.h"

# ifndef DSCPP_NWCALLS
# include <nwserver.h>
# include <nwdentry.h>
# include <nwbindry.h>
# include <nwdpath.h>
# include <nwvol.h>
# endif

# define DSCPP_PRESERVE_CONN		0x0100
# define DSCPP_SYSTEM_DISCONNECT	0x0200
# define DSCPP_ATTACHED			0x0400
# define DSCPP_NEAREST_NDS_SERVER	0xffff

/*
** Class DSConn
**
**	Used to attach and login to NDS and Bindery servers.
*/

class _DSCLASSDEC DSConn
{
protected:

	NWDSCCODE		Status ;
	NWCONN_HANDLE		ConnHandle ;
	NWDSContextHandle	Context ;
	WORD			Flags ;

	NWDSCCODE	attach(NWPSTR server,
			       NWPSTR objectName = 0,
			       NWPSTR password   = 0,
			       NWOBJ_TYPE objectType = OT_USER) ;
	NWDSCCODE	attach(NWCONN_HANDLE conn) ;
	NWDSCCODE	detach() ;
public:
			DSConn(NWPSTR server,
			       NWPSTR objectName = 0,
			       NWPSTR password   = 0,
			       NWOBJ_TYPE objectType = OT_USER)
					{ attach(server,objectName,password,objectType) ; }
			DSConn(NWDSContextHandle context,
			       NWPSTR server)
					{ attach(server) ; Context = context ; }
			DSConn(NWDSContextHandle context,
			       NWCONN_HANDLE conn = 0)
					{ attach(conn) ; Context = context ; }
			DSConn(NWCONN_HANDLE conn = 0)
					{ attach(conn) ; }
			DSConn(DSConn &) ;
	virtual	      ~	DSConn()			{ detach() ; }
	void 		operator=(DSConn &) ;
			operator NWCONN_HANDLE()	{ return ConnHandle ; }

	NWDSCCODE	status() 	{ return Status ; }
	NWDSCCODE	reset () 	{ return Status = 0 ; }
	WORD	 	flags ()	{ return Flags ; }
	WORD		attached()	{ return Flags & DSCPP_ATTACHED ; }
	void	 	preserve()	{ Flags |=   DSCPP_PRESERVE_CONN ; }
	void	 	release()	{ Flags &= ~ DSCPP_PRESERVE_CONN ; }
	void	 	systemConnect()	{ Flags |=   DSCPP_SYSTEM_DISCONNECT ; }
	void	 	taskConnect()	{ Flags &= ~ DSCPP_SYSTEM_DISCONNECT ; }

	NWDSCCODE	AddTrustee(	NWPSTR		dirPath,
					NWOBJ_ID	objectID,
					NWRIGHTS_MASK	rights,
					NWDIR_HANDLE	dirHandle = 0)
				{ return Status = NWAddTrustee(ConnHandle,dirHandle,dirPath,objectID,rights) ; }
	NWDSCCODE	AddTrustee(	NWPSTR		dirPath,
					NWPSTR		objectName,
					NWRIGHTS_MASK	rights,
					NWDIR_HANDLE	dirHandle = 0) ;
	NWDSCCODE	Authenticate()
				{ return Status = NWDSAuthenticate(ConnHandle,0,0) ; }
	NWDSCCODE	DeleteDriveBase(int driveNumber)
				{ return Status = NWDeleteDriveBase(driveNumber,0) ; }
	NWDSCCODE	DeleteTrustee(	NWPSTR		dirPath,
					NWOBJ_ID	objectID,
					NWDIR_HANDLE	dirHandle = 0)
				{ return Status = NWDeleteTrustee(ConnHandle,dirHandle,dirPath,objectID) ; }
	NWDSCCODE	DeleteTrustee(	NWPSTR		dirPath,
					NWPSTR		objectName,
					NWDIR_HANDLE	dirHandle = 0) ;
	NWDSCCODE	GetBinderyContext(BYTE * binderyContext)
				{ return Status = NWDSGetBinderyContext(Context,ConnHandle,binderyContext) ; }
	NWDSCCODE	GetConnectionInfo(
					NWFLAGS *	status		= 0,
					NWCONN_TYPE *	type		= 0,
					NWFLAGS *	serverFlags	= 0,
					BYTE *		serverName	= 0,
					NWTRAN_TYPE *	transType	= 0,
					NWLEN *		transLength	= 0,
					BYTE *		transBuffer	= 0,
					NWDISTANCE *	distance	= 0,
					WORD *		maxPacketSize	= 0)
				{ return Status = NWDSGetConnectionInfo(ConnHandle,
						status,type,serverFlags,serverName,
						transType,transLength,transBuffer,
						distance,maxPacketSize) ; }
	NWDSCCODE	GetConnectionInformation(
					NWCONN_NUM	number,
					NWPSTR		objectName	= 0,
					NWOBJ_TYPE *	objectType	= 0,
					NWOBJ_ID *	objectID	= 0,
					BYTE *		loginTime	= 0)
				{ return Status = NWGetConnectionInformation(ConnHandle,number,
						objectName,objectType,objectID,loginTime) ; }
	NWDSCCODE	GetConnectionNumber(NWCONN_NUM & number)
				{ return Status = NWGetConnectionNumber(ConnHandle,& number) ; }
	NWDSCCODE	GetConnectionStatus(CONNECT_INFO * info,NWSTRUCT_SIZE size = sizeof(CONNECT_INFO))
				{ return Status = NWGetConnectionStatus(ConnHandle,info,size) ; }
	NWDSCCODE	GetEffectiveRights(
					NWPSTR		dirPath,
					NWRIGHTS_MASK &	rights,
					NWDIR_HANDLE	dirHandle = 0)
				{ return Status = NWGetEffectiveRights(ConnHandle,dirHandle,dirPath,& rights) ; }
	NWDSCCODE	GetFileServerName(NWPSTR name)
				{ return Status = NWGetFileServerName(ConnHandle,name) ; }
	NWDSCCODE	GetFileServerUTCTime(DWORD & serverTime)
				{ return Status = NWGetFileServerUTCTime(ConnHandle,& serverTime) ; }
	NWDSCCODE	GetInternetAddress(NWCONN_NUM number, NWINET_ADDR * address)
				{ return Status = NWGetInetAddr(ConnHandle,number,address) ; }
	NWDSCCODE	GetObjectID(NWPSTR objectName, NWOBJ_ID & objectID, NWOBJ_TYPE objectType = OT_USER)
				{ return Status = NWGetObjectID(ConnHandle,objectName,objectType,& objectID) ; }
	NWDSCCODE	GetObjectName(NWOBJ_ID objectID, NWPSTR objectName, NWOBJ_TYPE * objectType = 0)
				{ return Status = NWGetObjectName(ConnHandle,objectID,objectName,objectType) ; }
	NWDSCCODE	GetServerDN(NWPSTR distName)
				{ return Status = NWDSGetServerDN(Context,ConnHandle,distName) ; }
	NWDSCCODE	GetVolumeName(NWVOL_NUM volNumber, NWPSTR volName)
				{ return Status = NWGetVolumeName(ConnHandle,volNumber,volName) ; }
	NWDSCCODE	GetVolumeNumber(NWPSTR volName, NWVOL_NUM & volNumber)
				{ return Status = NWGetVolumeNumber(ConnHandle,volName,& volNumber) ; }
	NWDSCCODE	IsDSServer(NWPSTR treeName)
				{ return NWIsDSServer(ConnHandle,treeName) ; }
	NWDSCCODE	LockConnection()
				{ return Status = NWDSLockConnection(ConnHandle) ; }
	NWDSCCODE	LoginToFileServer(
					NWPSTR		server,
					NWPSTR		objectName = 0,
					NWPSTR		password   = 0,
					NWOBJ_TYPE	objectType = OT_USER)
				{ return detach(),attach(server,objectName,password,objectType) ; }
	NWDSCCODE	LoginToFileServer(NWCONN_HANDLE	conn)
				{ return detach(),attach(conn) ; }
	NWDSCCODE	LogoutFromFileServer()
				{ return detach() ; }
	NWDSCCODE	MapIDToName(NWOBJ_ID objectID, NWPSTR name)
				{ return Status = NWDSMapIDToName(Context,ConnHandle,objectID,name) ; }
	NWDSCCODE	MapNameToID(NWPSTR name, NWOBJ_ID & objectID)
				{ return Status = NWDSMapNameToID(Context,ConnHandle,name,& objectID) ; }
	NWDSCCODE	SetDriveBase(int driveNumber, NWPSTR drivePath, NWDIR_HANDLE dirHandle = 0)
				{ return Status = NWSetDriveBase(driveNumber,ConnHandle,dirHandle,drivePath,0) ; }
	NWDSCCODE	UnlockConnection()
				{ return Status = NWDSUnlockConnection(ConnHandle) ; }
} ;

# endif dsCONN_H
