/*
**	Copyright  1994 Novell, Inc.  All rights reserved.
**
**	Permission is granted to the recipient of this work ("you") to use,
**	reproduce and distribute Novell's original publication of the work free
**	of charge provided that you reproduce the work in its entirety and
**	include all Novell copyright notices as they originally appear.
**
**	Novell grants you permission to modify and distribute copies of this
**	work including any portion of this work (a "modified work") provided
**	that you include prominent notification of such modification along with
**	the date of modification on a modified work; distribute or publish a
**	modified work to third parties under the same conditions and granting
**	the same rights as are extended to you by Novell under this under
**	permission notice; and provided that you include a copy of Novell's
**	original publication of the work along with any copy of a modified
**	work.
**
**	NOVELL MAKES NO WARRANTY, REPRESENTATION OR PROMISE THAT THIS WORK OR A
**	MODIFIED WORK WILL SATISFY YOUR REQUIREMENTS OR THAT THIS WORK OR A
**	MODIFIED WORK IS WITHOUT DEFECT OR ERROR.  NOVELL DISCLAIMS AND
**	EXCLUDES ANY AND ALL IMPLIED WARRANTIES OF MERCHANTABILITY, TITLE OR
**	FITNESS FOR A PARTICULAR PURPOSE.
**
**	IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW WILL NOVELL OR ANY OTHER
**	PARTY BE LIABLE FOR DAMAGES INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL,
**	CONSEQUENTIAL, INDIRECT OR PUNATIVE DAMAGES ARISING OUT OF THE USE OF
**	OR INABLITITY TO USE THE WORK OR A MODIFIED WORK.
**
**	DSVCHAR.H - October 1994
**
**	Declaration of the DSVString and DSVStringList classes.
**
**	Author: John Buckle, Asia Pacific Support Centre, Novell Australia
**	==================================================================
**	9 Jan 1995           First release              John Buckle
*/

# ifndef dsVCHAR_H
# define dsVCHAR_H

# include "dsvalue.h"
# include "dsvlist.h"

/*
** Structure DSVString
**
**	Used to hold the SYN_**_STRING values.
*/

struct _DSCLASSDEC DSVString : public DSValue
{
	NWPSTR		String ;

	NWDSCCODE	assign (NWSYNTAX_ID, void *) ;
	NWDSCCODE	assign (DSVString *) ;
	NWDSCCODE	release(int = DSCPP_DEF_INDEX) ;
	NWDSCCODE	compare(DSValue *) ;

			DSVString()				{ String = 0 ; }
			DSVString(NWSYNTAX_ID s, void * v)	{ assign(s,v) ; }
			DSVString(DSVString & v)		{ assign(& v) ; }
		      ~	DSVString()				{ release() ; }
	void		operator=(DSVString & v)		{ assign(& v) ; }

	void *		data()					{ return String ; }
	DSValueType	type()					{ return DSCPP_STRING ; }
	NWPSTR		text(int = DSCPP_DEF_INDEX)		{ return (String) ? String : "" ; }
} ;

/*
** Structure DSVStringList
**
**	Used to hold the SYN_CI_LIST values.
*/

struct _DSCLASSDEC DSVStringList : public DSValue
{
	DSVList<char>	List ;

	NWDSCCODE	assign (NWSYNTAX_ID, void *) ;
	NWDSCCODE	release(int index = DSCPP_DEF_INDEX) ;
	NWDSCCODE	compare(DSValue *) ;

			DSVStringList()				{ ; }
			DSVStringList(NWSYNTAX_ID s, void * v)	{ assign(s,v) ; }
		      ~	DSVStringList()				{ release() ; }

	NWPSTR		text(int index = DSCPP_DEF_INDEX) ;
	NWPSTR		operator[](int index)			{ return List[index] ; }
	void *		data()					{ return List.Head ; }
	DSValueType	type()					{ return DSCPP_STRING_LIST ; }
	WORD		count()					{ return List.Count ; }
} ;

typedef DSVListNode<char>	DSVStringNode ;
typedef	DSVListIterator<char>	DSVStringIterator ;

#endif dsVCHAR_H

