/*
**	Copyright  1994 Novell, Inc.  All rights reserved.
**
**	Permission is granted to the recipient of this work ("you") to use,
**	reproduce and distribute Novell's original publication of the work free
**	of charge provided that you reproduce the work in its entirety and
**	include all Novell copyright notices as they originally appear.
**
**	Novell grants you permission to modify and distribute copies of this
**	work including any portion of this work (a "modified work") provided
**	that you include prominent notification of such modification along with
**	the date of modification on a modified work; distribute or publish a
**	modified work to third parties under the same conditions and granting
**	the same rights as are extended to you by Novell under this under
**	permission notice; and provided that you include a copy of Novell's
**	original publication of the work along with any copy of a modified
**	work.
**
**	NOVELL MAKES NO WARRANTY, REPRESENTATION OR PROMISE THAT THIS WORK OR A
**	MODIFIED WORK WILL SATISFY YOUR REQUIREMENTS OR THAT THIS WORK OR A
**	MODIFIED WORK IS WITHOUT DEFECT OR ERROR.  NOVELL DISCLAIMS AND
**	EXCLUDES ANY AND ALL IMPLIED WARRANTIES OF MERCHANTABILITY, TITLE OR
**	FITNESS FOR A PARTICULAR PURPOSE.
**
**	IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW WILL NOVELL OR ANY OTHER
**	PARTY BE LIABLE FOR DAMAGES INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL,
**	CONSEQUENTIAL, INDIRECT OR PUNATIVE DAMAGES ARISING OUT OF THE USE OF
**	OR INABLITITY TO USE THE WORK OR A MODIFIED WORK.
**
**	DSVCHAR.CPP - October 1994
**
**	Definition of the DSVString and DSVStringList classes.
**
**	Author: John Buckle, Asia Pacific Support Centre, Novell Australia
**	==================================================================
**	9 Jan 1995           First release              John Buckle
*/

# include "dsdefs.h"
# include "dsvchar.h"

# include <string.h>

/*
** NWDSCCODE DSVString::assign(NWSYNTAX_ID syntaxID, void * value)
*/

NWDSCCODE DSVString::assign(NWSYNTAX_ID syntaxID, void * value)
{
	if (dsValueTypeArray[(WORD)syntaxID] != DSCPP_STRING)
		return DSCPP_WRONG_TYPE ;

	release() ;
	Syntax = syntaxID ;
	String = strnew((NWPSTR)value) ;

	return 0 ;
}

/*
** NWDSCCODE DSVString::assign(DSVString * value)
*/

NWDSCCODE DSVString::assign(DSVString * value)
{
	if (this == value) return 0 ;

	release() ;
	Syntax = value->Syntax ;
	String = strnew(value->String) ;

	return 0 ;
}

/*
** NWDSCCODE DSVString::release(int = DSCPP_DEF_INDEX)
*/

NWDSCCODE DSVString::release(int)
{
	if (Syntax) delete [] String ;

	Syntax = 0 ;
	String = 0 ;

	return 0 ;
}

/*
** NWDSCCODE DSVString::compare(DSValue * value)
**
**	Compare two DSVString objects. Return TRUE(1) if they are equivalent,
**	FALSE(0) if they are not equivalent and negative for an error.
*/

NWDSCCODE DSVString::compare(DSValue * value)
{
	if (checkTypeAndSyntax(value,DSCPP_STRING))
		return checkTypeAndSyntax(value,DSCPP_STRING) ;

	NWPSTR string = ((DSVString *) value)->String ;

	switch (Syntax){
	    case SYN_CE_STRING:
		return strcmp (String,string) == 0 ;
	    default:
		return stricmp(String,string) == 0 ;
	    }
}

/*
** NWPSTR DSVList<char>::create(NWPSTR value)
**
**	Duplicate a DSVList<char> entry.
*/

NWPSTR DSVList<char>::create(NWPSTR value)
{
	return DSValue::strnew(value) ;
}

/*
** NWDSCCODE DSVStringList::assign(NWSYNTAX_ID syntax, void * value)
*/

NWDSCCODE DSVStringList::assign(NWSYNTAX_ID syntaxID, void * value)
{
	if (dsValueTypeArray[(WORD)syntaxID] != DSCPP_STRING)
		release() ;

	Syntax = SYN_CI_LIST ;

	if (dsValueTypeArray[(WORD)syntaxID] == DSCPP_STRING)
		return List.assign((NWPSTR)value) ;

	if (dsValueTypeArray[(WORD)syntaxID] != DSCPP_STRING_LIST)
		return DSCPP_WRONG_TYPE ;

	for (DSVStringIterator iter((DSVStringNode *) value) ; iter() ; iter.next()){
		NWPSTR string = DSValue::strnew(iter()) ;
		List.assign(string) ;
		}

	return 0 ;
}

/*
** NWDSCCODE DSVStringList::release(int index = DSCPP_DEF_INDEX)
*/

NWDSCCODE DSVStringList::release(int index)
{
	if (index == DSCPP_DEF_INDEX) Syntax = 0 ;

	return List.release(index) ;
}

/*
** NWPSTR DSVStringList::text(int index)
*/

NWPSTR DSVStringList::text(int index)
{
	if (index != DSCPP_DEF_INDEX) return List[index] ;

	char *	pointer = DSValue::Buffer ;
	WORD	count   = 0 ;

	for (DSVStringIterator iter(List) ; iter() ; iter.next()){
		NWPSTR string = iter() ;
		WORD   length = strlen(string) ;
		if (count + length + 3 >= MAX_DN_BYTES) break ;
		count += length + 2 ;
		* pointer++ = '[' ;
		strcpy(pointer,string) ; pointer += length ;
		* pointer++ = ']' ;
		}
	* pointer = 0 ;

	return DSValue::Buffer ;
}

/*
** NWDSCCODE DSVStringList::compare(DSValue * value)
**
**	Compare two DSVStringList objects or a DSVStringList with a DSVString.
**	In the former case return TRUE(1) if they contain the same CI strings,
**	FALSE(0) otherwise. In the latter case return TRUE if the string is
**	in the list, FALSE otherwise. Return a negative value for an error.
*/

NWDSCCODE DSVStringList::compare(DSValue * value)
{
	if (checkTypeAndSyntax(value,DSCPP_STRING) &&
	    checkTypeAndSyntax(value,DSCPP_STRING_LIST))
		return checkTypeAndSyntax(value,DSCPP_STRING) ;

	if (value->type() == DSCPP_STRING){
		NWPSTR string = ((DSVString *) value)->String ;
		for (DSVStringIterator iter(List) ; iter() ; iter.next())
			if (stricmp(iter(),string) == 0) return 1 ;
		return 0 ;
		}

	for (DSVStringIterator node1(List),
			       node2(((DSVStringList *)value)->List) ;
	     node1() && node2() ; node1.next(), node2.next())
		if (stricmp(node1(),node2())) return 0 ;

	return node1() == node2() ;
}

/*
** DSValue & dsChangeString(DSValue & value, NWPSTR data)
**
**	Modify the String field of a DSVString or DSVStringList object.
**	This function is executed when the String() stream manipulator
**	is called.
*/

DSValue & dsChangeString(DSValue & value, NWPSTR data, NWSYNTAX_ID)
{
NWSYNTAX_ID syntax = (dsValueTypeArray[(WORD)value.syntax()] == DSCPP_STRING)
			? value.syntax() : SYN_CI_STRING ;

	value.assign(syntax,data) ;

	return value ;
}

/*
** DSManipulator<NWPSTR> String(NWPSTR data)
**
**	Create an instance of a manipulator object passing the address of
**	dsChangeString() function so that the String field of a DSVString
**	or DSVStringList object can be modified.
*/

DSManipulator<NWPSTR> String(NWPSTR data)
{
	return DSManipulator<NWPSTR>(dsChangeString,data) ;
}

