/*
**	Copyright  1994 Novell, Inc.  All rights reserved.
**
**	Permission is granted to the recipient of this work ("you") to use,
**	reproduce and distribute Novell's original publication of the work free
**	of charge provided that you reproduce the work in its entirety and
**	include all Novell copyright notices as they originally appear.
**
**	Novell grants you permission to modify and distribute copies of this
**	work including any portion of this work (a "modified work") provided
**	that you include prominent notification of such modification along with
**	the date of modification on a modified work; distribute or publish a
**	modified work to third parties under the same conditions and granting
**	the same rights as are extended to you by Novell under this under
**	permission notice; and provided that you include a copy of Novell's
**	original publication of the work along with any copy of a modified
**	work.
**
**	NOVELL MAKES NO WARRANTY, REPRESENTATION OR PROMISE THAT THIS WORK OR A
**	MODIFIED WORK WILL SATISFY YOUR REQUIREMENTS OR THAT THIS WORK OR A
**	MODIFIED WORK IS WITHOUT DEFECT OR ERROR.  NOVELL DISCLAIMS AND
**	EXCLUDES ANY AND ALL IMPLIED WARRANTIES OF MERCHANTABILITY, TITLE OR
**	FITNESS FOR A PARTICULAR PURPOSE.
**
**	IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW WILL NOVELL OR ANY OTHER
**	PARTY BE LIABLE FOR DAMAGES INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL,
**	CONSEQUENTIAL, INDIRECT OR PUNATIVE DAMAGES ARISING OUT OF THE USE OF
**	OR INABLITITY TO USE THE WORK OR A MODIFIED WORK.
**
**	DSVALUE.CPP - October 1994
**
**	Definition of the DSValue class.
**
**	Author: John Buckle, Asia Pacific Support Centre, Novell Australia
**	==================================================================
**	9 Jan 1995           First release              John Buckle
*/

# include "dsdefs.h"
# include "dsvalue.h"
# include "dsvint.h"
# include "dsvchar.h"
# include "dsvaddr.h"

# include <string.h>

/*
** DSValue::Buffer[]		Static buffer used by DSValue objects to return
**				text representations of their values.
*/

char	DSValue::Buffer[MAX_DN_BYTES] ;

/*
** dsValueTypeArray[]		Array mapping syntax values to DSValue types.
*/

DSValueType dsValueTypeArray[] = {
	DSCPP_UNKNOWN,		// SYN_UNKNOWN,		 0
	DSCPP_STRING,		// SYN_DIST_NAME,	 1
	DSCPP_STRING,		// SYN_CE_STRING,	 2
	DSCPP_STRING,		// SYN_CI_STRING,	 3
	DSCPP_STRING,		// SYN_PR_STRING,	 4
	DSCPP_STRING,		// SYN_NU_STRING,	 5
	DSCPP_STRING_LIST,	// SYN_CI_LIST,		 6
	DSCPP_BOOLEAN,		// SYN_BOOLEAN,		 7
	DSCPP_INTEGER,		// SYN_INTEGER,		 8
	DSCPP_OCTET_STRING,	// SYN_OCTET_STRING,	 9
	DSCPP_STRING,		// SYN_TEL_NUMBER,	10
	DSCPP_FAX_NUMBER,	// SYN_FAX_NUMBER,	11
	DSCPP_NET_ADDRESS,	// SYN_NET_ADDRESS,	12
	DSCPP_OCTET_LIST,	// SYN_OCTET_LIST,	13
	DSCPP_EMAIL_ADDRESS,	// SYN_EMAIL_ADDRESS,	14
	DSCPP_PATH,		// SYN_PATH,		15
	DSCPP_REPLICA,		// SYN_REPLICA_POINTER,	16
	DSCPP_OBJECT_ACL,	// SYN_OBJECT_ACL,	17
	DSCPP_POSTAL_ADDRESS,	// SYN_PO_ADDRESS,	18
	DSCPP_TIMESTAMP, 	// SYN_TIMESTAMP, 	19
	DSCPP_STRING,		// SYN_CLASS_NAME,	20
	DSCPP_STREAM,		// SYN_STREAM,		21
	DSCPP_INTEGER,		// SYN_COUNTER,		22
	DSCPP_BACK_LINK, 	// SYN_BACK_LINK, 	23
	DSCPP_INTEGER,		// SYN_TIME,		24
	DSCPP_TYPED_NAME,	// SYN_TYPED_NAME,	25
	DSCPP_HOLD,		// SYN_HOLD,		26
	DSCPP_UNKNOWN,		// SYN_INTERVAL,	27
	} ;

/*
** DSValue * DSValue::create(NWSYNTAX_ID syntaxID, void * value)
**
**	Static member function used to create a DSValue object
**	from a NWSYNTAX_ID and void *. The type of object
**	returned depends on the syntax.
*/

DSValue * DSValue::create(NWSYNTAX_ID syntaxID, void * value)
{
	if (syntaxID >= SYNTAX_COUNT)
		return 0 ;

	switch (dsValueTypeArray[(WORD)syntaxID]){
	    case DSCPP_UNKNOWN:
		return new DSValue   (syntaxID,value) ;
	    case DSCPP_STRING:
		return new DSVString (syntaxID,value) ;
	    case DSCPP_STRING_LIST:
		return new DSVStringList(syntaxID,value) ;
	    case DSCPP_BOOLEAN:
		return new DSVBoolean(syntaxID,value) ;
	    case DSCPP_INTEGER:
		return new DSVInteger(syntaxID,value) ;
	    case DSCPP_OCTET_STRING:
		return new DSValue   (syntaxID,value) ;
	    case DSCPP_FAX_NUMBER:
		return new DSValue   (syntaxID,value) ;
	    case DSCPP_NET_ADDRESS:
		return new DSVNetAddress(syntaxID,value) ;
	    case DSCPP_OCTET_LIST:
		return new DSValue   (syntaxID,value) ;
	    case DSCPP_EMAIL_ADDRESS:
		return new DSVEmailAddress(syntaxID,value) ;
	    case DSCPP_PATH:
		return new DSValue   (syntaxID,value) ;
	    case DSCPP_REPLICA:
		return new DSValue   (syntaxID,value) ;
	    case DSCPP_OBJECT_ACL:
		return new DSValue   (syntaxID,value) ;
	    case DSCPP_POSTAL_ADDRESS:
		return new DSVPostalAddress(syntaxID,value) ;
	    case DSCPP_TIMESTAMP:
		return new DSValue   (syntaxID,value) ;
	    case DSCPP_STREAM:
		return new DSValue   (syntaxID,value) ;
	    case DSCPP_BACK_LINK:
		return new DSValue   (syntaxID,value) ;
	    case DSCPP_TYPED_NAME:
		return new DSValue   (syntaxID,value) ;
	    case DSCPP_HOLD:
		return new DSValue   (syntaxID,value) ;
	    case DSCPP_INTERVAL:
		return new DSValue   (syntaxID,value) ;
	    }
	return 0 ;
}

/*
** NWDSCCODE DSValue::checkTypeAndSyntax(DSValue * value, WORD type)
**
**	Checks that the DSValue pointer is non null, points to an
**	appropriate DSValue type and that the object has been initialised.
*/

NWDSCCODE DSValue::checkTypeAndSyntax(DSValue * value, WORD type)
{
	if (value == 0)
		return DSCPP_MEMORY_ERROR ;
	if (value->type() != type)
		return DSCPP_WRONG_TYPE ;
	if (value->Syntax == 0)
		return DSCPP_UNDEFINED ;

	return 0 ;
}

/*
** NWPSTR DSValue::strnew(const NWPSTR string)
**
**	Create a new copy of a string.
*/

NWPSTR DSValue::strnew(const NWPSTR string)
{
NWPSTR	copy = (string) ? new char[strlen(string)+1] : 0 ;

	return (copy) ? strcpy(copy,string) : 0 ;
}

/*
** DSValue & dsChangeValue(DSValue & value, void * data, NWSYNTAX_ID syntax)
**
**	Modify the Data field of the DSValue object. This function is
**	executed when a stream manipulator is called.
*/

DSValue & dsChangeValue(DSValue & value, void * data, NWSYNTAX_ID syntax)
{
	value.assign(syntax,data) ;

	return value ;
}

/*
** DSValue & dsChangeSyntax(DSValue & value, NWSYNTAX_ID syntax)
**
**	Modify the Synatx field on the DSValue object. This function is
**	executed when the Syntax() stream manipulator is called.
*/

DSValue & dsChangeSyntax(DSValue & value, NWSYNTAX_ID syntax, NWSYNTAX_ID)
{
	if (syntax < SYNTAX_COUNT &&
		dsValueTypeArray[(WORD)value.Syntax] == dsValueTypeArray[(WORD)syntax])
			value.Syntax = syntax ;

	return value ;
}

/*
** DSManipulator<NWSYNTAX_ID> Syntax(NWSYNTAX_ID syntax)
**
**	Create an instance of a manipulator object passing the address of
**	dsChangeSyntax() function so that the Syntax field of DSValue
**	objects can be modified.
*/

DSManipulator<NWSYNTAX_ID> Syntax(NWSYNTAX_ID syntax)
{
	return DSManipulator<NWSYNTAX_ID>(dsChangeSyntax,syntax) ;
}

