/*
**	Copyright  1994 Novell, Inc.  All rights reserved.
**
**	Permission is granted to the recipient of this work ("you") to use,
**	reproduce and distribute Novell's original publication of the work free
**	of charge provided that you reproduce the work in its entirety and
**	include all Novell copyright notices as they originally appear.
**
**	Novell grants you permission to modify and distribute copies of this
**	work including any portion of this work (a "modified work") provided
**	that you include prominent notification of such modification along with
**	the date of modification on a modified work; distribute or publish a
**	modified work to third parties under the same conditions and granting
**	the same rights as are extended to you by Novell under this under
**	permission notice; and provided that you include a copy of Novell's
**	original publication of the work along with any copy of a modified
**	work.
**
**	NOVELL MAKES NO WARRANTY, REPRESENTATION OR PROMISE THAT THIS WORK OR A
**	MODIFIED WORK WILL SATISFY YOUR REQUIREMENTS OR THAT THIS WORK OR A
**	MODIFIED WORK IS WITHOUT DEFECT OR ERROR.  NOVELL DISCLAIMS AND
**	EXCLUDES ANY AND ALL IMPLIED WARRANTIES OF MERCHANTABILITY, TITLE OR
**	FITNESS FOR A PARTICULAR PURPOSE.
**
**	IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW WILL NOVELL OR ANY OTHER
**	PARTY BE LIABLE FOR DAMAGES INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL,
**	CONSEQUENTIAL, INDIRECT OR PUNATIVE DAMAGES ARISING OUT OF THE USE OF
**	OR INABLITITY TO USE THE WORK OR A MODIFIED WORK.
**
**	DSLOCALE.CPP - October 1994
**
**	Initialise and release unicode tables
**
**	Author: John Buckle, Asia Pacific Support Centre, Novell Australia
**	==================================================================
**	9 Jan 1995           First release              John Buckle
*/

# include "dsdefs.h"
# include "dslocale.h"

# define NWL_EXCLUDE_FILE
# define NWL_EXCLUDE_TIME

# include <dir.h>

# include <nwmisc.h>
# include <unicode.h>
# include <nwlocale.h>

/*
** int DSLocale::Initialised		Indicates if the tables have already
**					been loaded.
*/

int DSLocale::Initialised = 0 ;

/*
** DSLocale::DSLocale()
**
**	Initialises the unicode tables by searching all drives for the
**	NLS directory. The memeber field Status records whether the tables
**	were loaded.
*/

DSLocale::DSLocale()
{
LCONV	lconvInfo ;

	Status = 0 ; if (Initialised++) return ;

	NWCallsInit(0,0) ;
	NWLsetlocale(LC_ALL,"") ;
	NWLlocaleconv(&lconvInfo) ;

	int currentDrive = getdisk() ;

	if ((Status = NWInitUnicodeTables(lconvInfo.country_id,lconvInfo.code_page)) == 0)
		return ;

	for (int drive = 'Z'-'A' ; drive > 'B'-'A' ; drive--){
		if (foundUnicodeTables(drive,lconvInfo.country_id,lconvInfo.code_page)) break ;
		}
	setdisk(currentDrive) ;

	if (Status) return ;

	NWGetLocalToUnicodeHandle    (&LocalToUnicodeHandle) ;
	NWGetUnicodeToLocalHandle    (&UnicodeToLocalHandle) ;
	NWGetCollationHandle(&UnicodeToCollationHandle) ;
	NWGetMonocaseHandle (&UnicodeToMonocaseHandle) ;
}

/*
** DSLocale::DSLocale(int country, int codePage)
**
**	Initialises the unicode tables by searching all drives for the
**	NLS directory. The memeber field Status records whether the tables
**	were loaded.
*/

DSLocale::DSLocale(int country, int codePage)
{
	Status = 0 ; if (Initialised++) return ;

	int currentDrive = getdisk() ;

	if ((Status = NWInitUnicodeTables(country,codePage)) == 0)
		return ;

	for (int drive = 'Z'-'A' ; drive > 'B'-'A' ; drive--){
		if (foundUnicodeTables(drive,country,codePage)) break ;
		}
	setdisk(currentDrive) ;
}

/*
** DSLocale::~DSLocale()
**
**	Releases the unicode tables if this is the last object using them.
*/

DSLocale::~DSLocale()
{
	if (--Initialised == 0 && Status == 0) NWFreeUnicodeTables() ;
}

/*
** NWDSCCODE DSLocale::foundUnicodeTables(int drive, int country, int codePage)
**
**	Test the specified drive for the unicode tables, first in the drive's
**	current directory and then in any NLS subdirectory.
*/

NWDSCCODE DSLocale::foundUnicodeTables(int drive, int country, int codePage)
{
	if (setdisk(drive) == -1)
		return 0 ;

	if ((Status = NWInitUnicodeTables(country,codePage)) == 0)
		return 1 ;

	if (chdir("NLS") == -1)
		return 0 ;

	Status = NWInitUnicodeTables(country,codePage) ;

	chdir("..") ;

	return Status == 0 ;
}


