/*
**	Copyright  1994 Novell, Inc.  All rights reserved.
**
**	Permission is granted to the recipient of this work ("you") to use,
**	reproduce and distribute Novell's original publication of the work free
**	of charge provided that you reproduce the work in its entirety and
**	include all Novell copyright notices as they originally appear.
**
**	Novell grants you permission to modify and distribute copies of this
**	work including any portion of this work (a "modified work") provided
**	that you include prominent notification of such modification along with
**	the date of modification on a modified work; distribute or publish a
**	modified work to third parties under the same conditions and granting
**	the same rights as are extended to you by Novell under this under
**	permission notice; and provided that you include a copy of Novell's
**	original publication of the work along with any copy of a modified
**	work.
**
**	NOVELL MAKES NO WARRANTY, REPRESENTATION OR PROMISE THAT THIS WORK OR A
**	MODIFIED WORK WILL SATISFY YOUR REQUIREMENTS OR THAT THIS WORK OR A
**	MODIFIED WORK IS WITHOUT DEFECT OR ERROR.  NOVELL DISCLAIMS AND
**	EXCLUDES ANY AND ALL IMPLIED WARRANTIES OF MERCHANTABILITY, TITLE OR
**	FITNESS FOR A PARTICULAR PURPOSE.
**
**	IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW WILL NOVELL OR ANY OTHER
**	PARTY BE LIABLE FOR DAMAGES INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL,
**	CONSEQUENTIAL, INDIRECT OR PUNATIVE DAMAGES ARISING OUT OF THE USE OF
**	OR INABLITITY TO USE THE WORK OR A MODIFIED WORK.
**
**	DSINPUT.CPP - October 1994
**
**	Initialisation, control and release of directory buffers.
**
**	Author: John Buckle, Asia Pacific Support Centre, Novell Australia
**	==================================================================
**	9 Jan 1995           First release              John Buckle
*/

# include "dsdefs.h"
# include "dsinput.h"

/*
** DSInput::DSInput(WORD size = DEFAULT_MESSAGE_LEN)
**
**	Allocate memory for the input buffer.
*/

DSInput::DSInput(WORD size)
{
	Input = 0 ; if (size == 0) return ;

	if ((Status = NWDSAllocBuf(size,& Input)) != 0) Input = 0 ;
}

/*
** DSInput::~DSInput()
**
**	Release memory used by the input buffer.
*/

DSInput::~DSInput()
{
	if (Input) NWDSFreeBuf(Input) ;
}

/*
** NWDSCCODE DSInput::PutAttrName(
**			NWPSTR		attr,
**			NWSYNTAX_ID	syntax,
**			void *		value)
**
**	Add an attribute name and value to the input buffer.
*/

NWDSCCODE DSInput::PutAttrName(NWPSTR attr, NWSYNTAX_ID syntax, void * value)
{
	return 	(Status = NWDSPutAttrName(dContext,Input,attr)) != 0 ||
		(Status = NWDSPutAttrVal (dContext,Input,syntax,value)) != 0 ;
}

/*
** NWDSCCODE DSInput::PutAttrName(NWPSTR attr[])
**
**	Add multiple attribute names to the input buffer.
*/

NWDSCCODE DSInput::PutAttrName(NWPSTR attr[])
{
	for (int i = 0 ; attr[i] ; i ++)
		if ((Status = NWDSPutAttrName(dContext,Input,attr[i])) != 0) break ;

	return Status ;
}

/*
** NWDSCCODE DSInput::AddAttrValue(
**			NWPSTR		attr,
**			NWSYNTAX_ID	syntax,
**			void *		value)
**
**	Insert a value into an object.
*/

NWDSCCODE DSInput::AddAttrValue(NWPSTR attr, NWSYNTAX_ID syntax, void * value)
{
	return	(Status = NWDSPutChange (dContext,Input,DS_ADD_VALUE,attr)) != 0 ||
		(Status = NWDSPutAttrVal(dContext,Input,syntax,value))      != 0 ;
}

/*
** NWDSCCODE DSInput::DelAttrValue(
**			NWPSTR		attr,
**			NWSYNTAX_ID	syntax,
**			void *		value)
**
**	Remove a value from an object.
*/

NWDSCCODE DSInput::DelAttrValue(NWPSTR attr, NWSYNTAX_ID syntax, void * value)
{
	return	(Status = NWDSPutChange (dContext,Input,DS_REMOVE_VALUE,attr)) != 0 ||
		(Status = NWDSPutAttrVal(dContext,Input,syntax,value))         != 0 ;
}

