/*
** WLOGON
**
**	Perform a Windows login to the NDS.
**
**	Author: John Buckle, Asia Pacific Support Centre, Novell Australia.
*/

# define DSCPP_IMPORT
# define DSCPP_WINDOWS

# include "dscontext.h"
# include "dslocale.h"
# include "dsconn.h"
# include "wlogon.h"
# include <stdio.h>

char		szLoginName[256] ;
char		szPassword [256] ;

int		ErrorMessage(LPSTR, NWDSCCODE) ;
BOOL CALLBACK	GetPassword(HWND, WORD, WORD, LONG) ;

int PASCAL WinMain(HINSTANCE hInstance,HINSTANCE,LPSTR cmdLine,int)
{
DSLocale  dsLocale;
DSContext dsContext ;

	if (dsLocale.status()){
		return ErrorMessage("Cannot initialise/create unicode - %d",dsLocale.status()) ;
		}

	if (dsContext.status()){
		return ErrorMessage("Cannot initialise/create context - 0x%X",dsContext.status()) ;
		}

	FARPROC	dialogBox = MakeProcInstance((FARPROC)GetPassword,hInstance) ;
	BOOL button = DialogBoxParam(hInstance,"GetPassword",0,dialogBox,(LONG)cmdLine) ;
	FreeProcInstance(dialogBox) ;

	if (button == IDCANCEL) return 0 ;

	dsContext.LoginToNDS(szLoginName,szPassword) ;
	if (dsContext.status()){
		return ErrorMessage("Cannot login to NDS - 0x%X",dsContext.status()) ;
		}

	DSConn dsConn(dsContext,DSCPP_NEAREST_NDS_SERVER) ;
	if (dsConn.status()){
		return ErrorMessage("Cannot connect to NDS server - 0x%X",dsConn.status()) ;
		}

	dsConn.SetDriveBase(26,"SYS:PUBLIC") ;
	if (dsConn.status()){
		return ErrorMessage("Cannot map drive to SYS:PUBLIC - 0x%X",dsConn.status()) ;
		}

	return 0 ;
}

/*
** int ErrorMessage(LPSTR message, NWCCODE ccode)
**
**	Display an error message with NetWare error code.
*/

int ErrorMessage(LPSTR message, NWDSCCODE ccode)
{
char buffer[256] ;

	sprintf(buffer,message,ccode) ;
	MessageBox(0,buffer,"WLOGON error",MB_OK) ;
	return 0 ;
}

/*
** BOOL CALLBACK GetPassword(HWND hDlg, WORD message, WORD wParam, LONG lParam)
**
**	Ask the user for their login name and password. If a login name was
**	given as a command line argument then the login name field is
**	automatically filled in.
*/

BOOL CALLBACK GetPassword(HWND hDlg, WORD message, WORD wParam, LONG lParam)
{
	switch (message){
	    case WM_INITDIALOG: {
		char * loginName = (LPSTR) lParam ;
		if (loginName && loginName[0]){
			SetDlgItemText(hDlg,IDC_EDIT1,loginName) ;
			SetFocus(GetDlgItem(hDlg,IDC_EDIT2)) ;
			}
		else
			SetFocus(GetDlgItem(hDlg,IDC_EDIT1)) ;
		} return FALSE ;
	    case WM_COMMAND:
		switch (wParam){
		    case IDOK:
			GetDlgItemText(hDlg,IDC_EDIT1,szLoginName,256) ;
			GetDlgItemText(hDlg,IDC_EDIT2,szPassword, 256) ;
		    case IDCANCEL:
			EndDialog(hDlg,wParam) ;
			return TRUE ;
		    }
		break ;
	    }
	return FALSE ;
}

