/*
** ACCESS <object> <name> <attribute> <rights>
**
**	Modify the <object>'s ACL to grant <rights> to <name> for attribute
**	<attribute>.
**
**	Author: John Buckle, Asia Pacific Support Centre, Novell Australia.
*/

# define DSCPP_IOSTREAM

# include "dslocale.h"
# include "dsbuffer.h"
# include "dsiterat.h"

# include <string.h>
# include <stdlib.h>

struct ObjectACL {
	NWPSTR		PtrSubjectAttr ;
	NWPSTR		PtrSubjectName ;
	DWORD		SubjectRights ;
	char		SubjectAttr[MAX_SCHEMA_NAME_BYTES] ;
	char		SubjectName[MAX_DN_BYTES] ;
} ;

class DSACLIteration : public DSIteration
{
	ObjectACL	ACL ;
	DWORD		OldRights ;
	DWORD		NewRights ;
	int		Found ;
	int		Count ;
public:
			DSACLIteration(NWPSTR name, NWPSTR attr, DWORD rights) ;

	NWDSCCODE	InitLoop()
				{ Found = Count = 0 ; return 0 ; }
	NWDSCCODE	SetAttrValue(NWSYNTAX_ID, void *) ;

	ObjectACL *	oldACL()	{ ACL.SubjectRights = OldRights ; return & ACL ; }
	ObjectACL *	newACL()	{ ACL.SubjectRights = NewRights ; return & ACL ; }
	int		found()		{ return Found ; }
	int		count()		{ return Count ; }
	DWORD		oldRights()	{ return OldRights ; }
	DWORD		newRights()	{ return NewRights ; }
} ;

DSACLIteration::DSACLIteration(NWPSTR name, NWPSTR attr, DWORD rights)
{
	strcpy(ACL.SubjectName,name) ; ACL.PtrSubjectName = ACL.SubjectName ;
	strcpy(ACL.SubjectAttr,attr) ; ACL.PtrSubjectAttr = ACL.SubjectAttr ;
	ACL.SubjectRights = NewRights = rights ;
}

NWDSCCODE DSACLIteration::SetAttrValue(NWSYNTAX_ID, void * data)
{
ObjectACL * value = (ObjectACL *) data ;

	Count ++ ;
	OldRights = value->SubjectRights ;
	Found  = (stricmp(value->PtrSubjectAttr,ACL.PtrSubjectAttr) == 0 &&
		  stricmp(value->PtrSubjectName,ACL.PtrSubjectName) == 0) ;

	cout << value->PtrSubjectAttr << " " << value->PtrSubjectName << " " << OldRights << endl ;

	return Found ;
}

NWDSCCODE GrantAccess(NWPSTR object, NWPSTR subName, NWPSTR subAttr, DWORD subRights)
{
DSBuffer	dsBuffer ;
DSACLIteration	dsACLIteration(subName,subAttr,subRights) ;

	if (dsBuffer.DoesObjectExist(object)){
		cout << "ACCESS: Object " << object << " does not exist\n" ;
		return dsBuffer.status() ;
		}
	if (dsBuffer.DoesObjectExist(subName)){
		cout << "ACCESS: Object " << subName << " does not exist\n" ;
		return dsBuffer.status() ;
		}
	dsBuffer.InitBuf(DSV_READ);
	dsBuffer.PutAttrName("ACL") ;

	// Read object's ACL attribute looking for an existing ACL value
	if (dsBuffer.Read(object,1,0,& dsACLIteration) < 0)
		return dsBuffer.status() ;

	// Determine if an ACL value already exists
	if (dsACLIteration.found() && dsACLIteration.oldRights() == subRights)
		return 0 ;

	dsBuffer.InitBuf(DSV_MODIFY_ENTRY) ;

	if (dsACLIteration.count() == 0){
		// Add ACL attribute to the object
		dsBuffer.PutChange(DS_ADD_ATTRIBUTE,"ACL") ;
		}
	if (dsACLIteration.found()){
		// Remove old ACL value from ACL attribute
		dsBuffer.DelAttrValue("ACL",SYN_OBJECT_ACL,dsACLIteration.oldACL()) ;
		}
	// Add new ACL value to ACL attribute
	dsBuffer.AddAttrValue("ACL",SYN_OBJECT_ACL,dsACLIteration.newACL()) ;

	return dsBuffer.ModifyObject(object) ;
}

/*
** int main(int argc, char * argv[])
*/

int main(int argc, char * argv[])
{
DSLocale	dsLocale ;
NWDSCCODE	status = 0 ;
DWORD		rights = 0 ;

	if (argc < 5){
		cout << "Usage: ACCESS <object> <name> <attribute> <rights>\n" ;
		return(0) ;
		}
	if (dsLocale.status()) return 0 ;

	rights = atol(argv[4]) ;

	if ((status = GrantAccess(argv[1],argv[2],argv[3],rights)) == 0)
		cout << "ACL modification successful\n" ;
	else
		cout << "Error " << hex << status << " in modification to ACL\n" ;
	return 0 ;
}

