/*
** SEARCH [search pattern [context]]
**
**	Search for all uses using [search pattern] in the context [context].
**
**	Author: John Buckle, Asia Pacific Support Centre, Novell Australia.
*/

# define DSCPP_IOSTREAM

# include "dslocale.h"
# include "dsbuffer.h"
# include "dsiterat.h"
# include <string.h>

# define PHONE_SIZE	 32
# define LOGIN_SIZE	 64
# define FULL_SIZE	127

NWPSTR	UserObjectAttributes[] = { "CN", "Full Name", "Telephone Number", 0 } ;

class DSUserObject : public DSIteration
{
	char		LoginName[LOGIN_SIZE] ;
	char		FullName [FULL_SIZE ] ;
	char		Telephone[PHONE_SIZE] ;
	WORD		Index ;
public:
	NWDSCCODE	InitObject(NWPSTR object, void * info)
				{ LoginName[0] = FullName[0] = Telephone[0] = 0 ;
				  return DSIteration::InitObject(object,info) ; }
	NWDSCCODE	SetAttrName(NWPSTR attrName, NWSYNTAX_ID syntax) ;

	NWDSCCODE	SetAttrValue(NWSYNTAX_ID syntax, void * data) ;

	NWDSCCODE	ExitObject(NWPSTR object)
				{ cout << object << endl << * this ;
				  return DSIteration::ExitObject(object) ; }

friend	ostream &	operator<<(ostream & s, DSUserObject & u) ;
} ;

NWDSCCODE DSUserObject::SetAttrName(NWPSTR attrName, NWSYNTAX_ID)
{
	for (Index = 0 ; UserObjectAttributes[Index] ; Index++)
		if (stricmp(UserObjectAttributes[Index],attrName) == 0)	break ;
	return 0 ;
}

NWDSCCODE DSUserObject::SetAttrValue(NWSYNTAX_ID, void * data)
{
	switch (Index) {
	    case 0:
		strncpy(LoginName,(NWPSTR) data,LOGIN_SIZE) ; break ;
	    case 1:
		strncpy(FullName, (NWPSTR) data,FULL_SIZE) ;  break ;
	    case 2:
		strncpy(Telephone,(NWPSTR) data,PHONE_SIZE) ; break ;
	    }
	return 0 ;
}

ostream & operator<<(ostream & s, DSUserObject & user)
{
	return s << "Login\t" << user.LoginName << "\n"
		 << "Name\t"  << user.FullName  << "\n"
		 << "Phone\t" << user.Telephone << "\n" ;
}

int main(int argc, char * argv[])
{
DSLocale	dsLocale ;
DSUserObject	dsUserObject ;
DSBuffer	dsBuffer(argc == 3 ? argv[2] : "") ;

	if (dsLocale.status() || dsBuffer.status()) return 0 ;

	NWPSTR string = (strlen(argv[1])) ? argv[1] : "*" ;

	dsBuffer.InitBuf(DSV_SEARCH) ;
	dsBuffer.PutAttrName(UserObjectAttributes) ;
	dsBuffer.InitFilter() ;
	dsBuffer.AddFilterToken(FTOK_ANAME,"Object Class",SYN_CLASS_NAME) ;
	dsBuffer.AddFilterToken(FTOK_EQ) ;
	dsBuffer.AddFilterToken(FTOK_AVAL,"USER",SYN_CLASS_NAME) ;
	dsBuffer.AddFilterToken(FTOK_AND) ;
	dsBuffer.AddFilterToken(FTOK_ANAME,"CN",SYN_CLASS_NAME) ;
	dsBuffer.AddFilterToken(FTOK_EQ) ;
	dsBuffer.AddFilterToken(FTOK_AVAL,string,SYN_CI_STRING) ;
	dsBuffer.ExitFilter() ;

	if (dsBuffer.status() == 0)
		dsBuffer.Search("",DS_SEARCH_SUBTREE,1,1,0,&dsUserObject) ;
	else
		cout << "Error " << hex << dsBuffer.status()
		     << " while constructing filter\n" ;
	return 0 ;
}
