/*
** OBJECT <common name> <last name> [context]
**
**	Create and read NDS user objects. This program will create a
**	new NDS user object if the user does not exist. Otherwise the
**	program will modify the user's language list.
**
**	Author: John Buckle, Asia Pacific Support Centre, Novell Australia.
*/

# define DSCPP_IOSTREAM

# include "dslocale.h"
# include "dsobject.h"
# include "dsvchar.h"
# include "dsvint.h"
# include "dsvmulti.h"

# include <string.h>
# include <stdio.h>

/*
** dsUserAttrNames[]		Null terminated list of attribute names present
**				in the DSUserObject. The order of these names
**				is important and must be the same as used by
**				the function FindAttribute().
*/

NWPSTR	dsUserAttrNames[] = { "Surname",
			      "Full Name",
			      "Security Equals",
			      "Language", 0 } ;

/*
** dsUserAttrCount[]		Number of attribute fields in the DSUserObject
**				for each attribute listed in dsUserAttrNames[].
*/

WORD	dsUserAttrCount[] = { 1, 1, 1, 1, 0 } ;

/*
** Class DSUserObject
**
**	Used to create and read USER objects from the NDS.
*/

class DSUserObject : public DSObject
{
protected:
    DSValue *		FindAttribute(WORD attrIndex, WORD valueIndex) ;

    NWPSTR *		AttributeNames()
				{ return dsUserAttrNames ; }
    WORD *		AttributeCount()
				{ return dsUserAttrCount ; }
    NWPSTR		ClassName()
				{ return "USER" ; }
public:
    DSVString		SurName ;
    DSVString		FullName ;
    DSVMultiValue	Security ;
    DSVStringList	Language ;

			DSUserObject() { ; }
} ;

/*
** DSValue * DSUserObject::FindAttribute(WORD attrIndex, WORD)
**
**	Given an attribute index and a value index, return a pointer to the
**	DSValue object responsible for that attribute/value pair.
*/

DSValue * DSUserObject::FindAttribute(WORD attrIndex, WORD)
{
	switch (attrIndex) {
	    case 0:
		return & SurName ;
	    case 1:
		return & FullName ;
	    case 2:
		return & Security ;
	    case 3:
		return & Language ;
	    }
	return 0 ;
}

/*
** int main(int argc, char * argv[])
*/

int main(int argc, char * argv[])
{
	if (argc < 3 || argc > 4){
		cerr << "Usage: OBJECT common_name last_name [context]\n" ;
		return 0 ;
		}
	DSLocale	dsLocale ;
	DSBuffer	dsBuffer ;
	DSUserObject	newUser, oldUser ;
	char		fullname[MAX_DN_BYTES],
			distname[MAX_DN_BYTES],
			context [MAX_DN_BYTES],
			everyone[MAX_DN_BYTES] ;

	if (dsLocale.status() || dsBuffer.status()){
		cerr << "OBJECT: Cannot initialise Unicode\n" ;
		return 0 ;
		}

	if (argc == 3)
		dsBuffer.GetContext(context) ;
	else
		strcpy(context,argv[3]) ;

	sprintf(fullname,"%s %s",argv[1],argv[2]) ;
	sprintf(distname,".%s.%s",argv[1],context) ;
	sprintf(everyone,"Everyone.%s",context) ;

	if (dsBuffer.DoesObjectExist(distname) == 0){
		if (newUser.ReadObject(distname,& dsBuffer)){
			cerr << "Cannot read user \"" << distname << "\"\n" ;
			return 0 ;
			}
		oldUser = newUser ;
		cout << "\nOld user value\n" << oldUser ;
		newUser.Language.release() ;
		newUser.Language << String("English") << String("C++")
				 << String("Pascal")  << String("Fortran") ;
		if (newUser.WriteObject(distname,& dsBuffer,& oldUser)){
			cerr << "Cannot modify user \"" << distname << "\"\n" ;
			return 0 ;
			}
		cout << "\nNew user value\n" << newUser ;
		}
	else {
		newUser.SurName  << String(argv[2])  << Syntax(SYN_CI_STRING) ;
		newUser.FullName << String(fullname) << Syntax(SYN_CI_STRING) ;
		newUser.Security << String(everyone) << Syntax(SYN_DIST_NAME) ;
		newUser.Language << String("English") ;
		if (newUser.WriteObject(distname,& dsBuffer)){
			cerr << "Cannot create user \"" << distname << "\"\n" ;
			return 0 ;
			}
		cout << "\nNew user value\n" << newUser ;
		if (dsBuffer.GenerateObjectKeyPair(distname,"")){
			cerr << "Cannot generate user's RSA keys \n" ;
			return 0 ;
			}
		}

	return 0 ;
}