/*
**	Copyright  1994 Novell, Inc.  All rights reserved.
**
**	Permission is granted to the recipient of this work ("you") to use,
**	reproduce and distribute Novell's original publication of the work free
**	of charge provided that you reproduce the work in its entirety and
**	include all Novell copyright notices as they originally appear.
**
**	Novell grants you permission to modify and distribute copies of this
**	work including any portion of this work (a "modified work") provided
**	that you include prominent notification of such modification along with
**	the date of modification on a modified work; distribute or publish a
**	modified work to third parties under the same conditions and granting
**	the same rights as are extended to you by Novell under this under
**	permission notice; and provided that you include a copy of Novell's
**	original publication of the work along with any copy of a modified
**	work.
**
**	NOVELL MAKES NO WARRANTY, REPRESENTATION OR PROMISE THAT THIS WORK OR A
**	MODIFIED WORK WILL SATISFY YOUR REQUIREMENTS OR THAT THIS WORK OR A
**	MODIFIED WORK IS WITHOUT DEFECT OR ERROR.  NOVELL DISCLAIMS AND
**	EXCLUDES ANY AND ALL IMPLIED WARRANTIES OF MERCHANTABILITY, TITLE OR
**	FITNESS FOR A PARTICULAR PURPOSE.
**
**	IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW WILL NOVELL OR ANY OTHER
**	PARTY BE LIABLE FOR DAMAGES INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL,
**	CONSEQUENTIAL, INDIRECT OR PUNATIVE DAMAGES ARISING OUT OF THE USE OF
**	OR INABLITITY TO USE THE WORK OR A MODIFIED WORK.
**
**	DSINPUT.H - October 1994
**
**	Declaration of the DSInput class.
**
**	Author: John Buckle, Asia Pacific Support Centre, Novell Australia
**	==================================================================
**	9 Jan 1995           First release              John Buckle
*/

# ifndef dsINPUT_H
# define dsINPUT_H

# include "dscontex.h"

/*
** Class DSInput
**
**	Used to initialise an NWDS buffer for input to functions such as
**	NWDSRead, NWDSList. The assignment operator and initialisation
**	contructor are declared but not defined, this is to stop the directory
**	buffer being copied and inadvertantly released.
*/

class _DSCLASSDEC DSInput : public virtual DSContext
{
protected:

	NWDS_BUFFER NWFAR *	Input ;

public:
				DSInput(WORD size = DEFAULT_MESSAGE_LEN) ;
				DSInput(DSInput &) ;
	virtual		      ~ DSInput() ;
	void			operator=(DSInput &) ;

	NWDS_BUFFER NWFAR *	input()		{ return Input ; }


	NWDSCCODE	AddObject(NWPSTR object)
				{ return Status = NWDSAddObject(dContext,object,0,0,Input) ; }
	NWDSCCODE	AddAttrValue(NWPSTR attr, NWSYNTAX_ID syntax, void * value) ;

	NWDSCCODE	BeginClassItem()
				{ return Status = NWDSBeginClassItem(dContext,Input) ; }
	NWDSCCODE	Compare(NWPSTR object, NWFLAGS & matched)
				{ return Status = NWDSCompare(dContext,object,Input,& matched) ; }
	NWDSCCODE	DelAttrValue(NWPSTR attr, NWSYNTAX_ID syntax, void * value) ;

	NWDSCCODE	InitBuf(NWDS_OPERATION function)
				{ return Status = NWDSInitBuf(dContext,function,Input) ; }
	NWDSCCODE	ModifyObject(NWPSTR object)
				{ return Status = NWDSModifyObject(dContext,object,0,0,Input) ; }
	NWDSCCODE	PutAttrName(NWPSTR attr)
				{ return Status = NWDSPutAttrName(dContext,Input,attr) ; }
	NWDSCCODE	PutAttrName(NWPSTR attr, NWSYNTAX_ID syntax, void * value) ;

	NWDSCCODE	PutAttrName(NWPSTR attr[]) ;

	NWDSCCODE	PutAttrValue(NWSYNTAX_ID syntax, void * value)
				{ return Status = NWDSPutAttrVal(dContext,Input,syntax,value) ; }
	NWDSCCODE	PutChange(NWCHANGE_TYPE type, NWPSTR attrName)
				{ return Status = NWDSPutChange(dContext,Input,type,attrName) ; }
	NWDSCCODE	PutClassItem(NWPSTR name)
				{ return Status = NWDSPutClassItem(dContext,Input,name) ; }
	NWDSCCODE	PutSyntaxName(NWPSTR className)
				{ return Status = NWDSPutSyntaxName(dContext,Input,className) ; }
} ;

# endif dsINPUT_H
