/*
**	Copyright  1994 Novell, Inc.  All rights reserved.
**
**	Permission is granted to the recipient of this work ("you") to use,
**	reproduce and distribute Novell's original publication of the work free
**	of charge provided that you reproduce the work in its entirety and
**	include all Novell copyright notices as they originally appear.
**
**	Novell grants you permission to modify and distribute copies of this
**	work including any portion of this work (a "modified work") provided
**	that you include prominent notification of such modification along with
**	the date of modification on a modified work; distribute or publish a
**	modified work to third parties under the same conditions and granting
**	the same rights as are extended to you by Novell under this under
**	permission notice; and provided that you include a copy of Novell's
**	original publication of the work along with any copy of a modified
**	work.
**
**	NOVELL MAKES NO WARRANTY, REPRESENTATION OR PROMISE THAT THIS WORK OR A
**	MODIFIED WORK WILL SATISFY YOUR REQUIREMENTS OR THAT THIS WORK OR A
**	MODIFIED WORK IS WITHOUT DEFECT OR ERROR.  NOVELL DISCLAIMS AND
**	EXCLUDES ANY AND ALL IMPLIED WARRANTIES OF MERCHANTABILITY, TITLE OR
**	FITNESS FOR A PARTICULAR PURPOSE.
**
**	IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW WILL NOVELL OR ANY OTHER
**	PARTY BE LIABLE FOR DAMAGES INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL,
**	CONSEQUENTIAL, INDIRECT OR PUNATIVE DAMAGES ARISING OUT OF THE USE OF
**	OR INABLITITY TO USE THE WORK OR A MODIFIED WORK.
**
**	DSCONTEX.CPP - October 1994
**
**	Initialisation and release of directory context handles.
**
**	Author: John Buckle, Asia Pacific Support Centre, Novell Australia
**	==================================================================
**	9 Jan 1995           First release              John Buckle
*/

# include "dsdefs.h"
# include "dscontex.h"
# include <stdio.h>
# include <string.h>
# include <nwserver.h>
# include <nwlocale.h>

# define UNI_CONTEXT_CREATION	((NWDSContextHandle) ERR_CONTEXT_CREATION)

/*
** DSContext::DSContext(NWPSTR context)
**
**	Create a directory context.
*/

DSContext::DSContext(NWPSTR context, DWORD flags)
{
	Status = 0 ;

	if ((dContext = NWDSCreateContext()) == UNI_CONTEXT_CREATION)
		Status = ERR_CONTEXT_CREATION ;
	else if (SetContext(DCK_FLAGS,&flags) == 0 && context && context[0])
		SetContext(context) ;
}

/*
** DSContext::~DSContext()
**
**	Release the directory context.
*/

DSContext::~DSContext()
{
	if (dContext != UNI_CONTEXT_CREATION) NWDSFreeContext(dContext) ;
}

/*
** NWDSCCODE DSContext::LoginToNDS(
**				NWPSTR object,
**				NWPSTR password = 0,
**				NWDS_VALIDITY period = 0)
**
**	Attach to the NDS by executing NWDSLogin. If the object does not
**	exist in the default context then the server context is used.
*/

NWDSCCODE DSContext::LoginToNDS(NWPSTR object, NWPSTR password, NWDS_VALIDITY period)
{
char		serverName[48] ;
BYTE		type = 0 ;
NWCONN_HANDLE	connHandle ;

	if (password == 0) password = "" ;

	if ((Status = NWGetPreferredConnName((BYTE*)serverName,& type)) != 0)
		return Status ;

	if (type != NWNDS_CONNECTION){
		char	treeName[48] ;
		if (NWGetConnectionHandle((BYTE*)serverName,0,& connHandle,0) &&
		    NWAttachToFileServer ((char*)serverName,0,& connHandle))
			return Status = 0x8847 ;

		if (NWIsDSServer(connHandle,treeName) == 0)
			return Status = 0x8847 ;

		if ((Status = NWSetPreferredDSTree(strlen(treeName),(BYTE*)treeName)) != 0)
			return Status ;
		}

	if ((Status = NWGetPreferredDSServer(&connHandle)) != 0){
		return Status ;
		}

	if (Login(object,password,period)){
		char	serverBuffer[MAX_DN_BYTES] ;
		char	objectBuffer[MAX_DN_BYTES] ;
		char *	serverContext ;
		Status = NWGetNearestDirectoryService(& connHandle) ;

		if (Status || GetServerDN(connHandle,serverName)
			   || CanonicalizeName(serverName,serverBuffer))
			return Status ;

		serverContext = NWLstrchr(serverBuffer,'.') ;
		sprintf(objectBuffer,".%s%s",object,serverContext) ;

		Login(objectBuffer,password,period) ;
		}
	return Status ;
}

/*
** NWDSCCODE DSContext::LogoutFromNDS()
**
**	Perform a Logout() and close all connections. After executing this
**	function all DSConn objects will be invalid.
*/

NWDSCCODE DSContext::LogoutFromNDS()
{
	if (Logout()) return Status ;

	NWNUMBER maxConnections = 0,
		 numConnections = 0 ;

	NWGetMaximumConnections(& maxConnections) ;

	NWCONN_HANDLE * connList = new NWCONN_HANDLE[maxConnections] ;
	CONNECT_INFO	connInfo ;

	Status = NWGetConnectionList(0,connList,maxConnections,& numConnections) ;
	if (Status) return Status ;

	for(int i = 0 ; i < numConnections ; i++){
		if (NWGetConnectionStatus(connList[i],& connInfo,sizeof(CONNECT_INFO)) == 0){
			if(connInfo.connectFlags & CONNECTION_NDS){
				NWFreeConnectionSlot(connList[i],SYSTEM_DISCONNECT) ;
				}
			else {
				NWLogoutFromFileServer(connList[i]) ;
				NWDetachFromFileServer(connList[i]) ;
				}
			}
		}
	return Status ;
}
