/* This is file PAGING.H */
/*
** Copyright (C) 1993 DJ Delorie, 24 Kirsten Ave, Rochester NH 03867-2954
**
** This file is distributed under the terms listed in the document
** "copying.dj", available from DJ Delorie at the address above.
** A copy of "copying.dj" should accompany this file; if not, a copy
** should be available from where this file was obtained.  This file
** may not be distributed without a verbatim copy of "copying.dj".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#ifndef _PAGING_H_
#define _PAGING_H_

/* active if set */
#define PT_P	0x001	/* present (else not) */
#define PT_W	0x002	/* writable (else read-only) */
#define	PT_U	0x004	/* user mode (else kernel mode) */
#define PT_A	0x020	/* accessed (else not) */
#define PT_D	0x040	/* dirty (else clean) */
#define PT_I	0x200	/* Initialized (else not read from a.out file yet) */
#define PT_S	0x400	/* Swappable (else not) */
#define	PT_C	0x800	/* Candidate for swapping */

#define EMU_TEXT 0xb0000000L

/*  If not present and initialized, page is in swap file.
**  If not present and not initialized, page is in a.out file.
*/

void paging_set_file(char *fname);
word32 ptr2linear(void far *ptr);
word32 paging_brk(word32 b);
word32 paging_sbrk(int32 b);
word32 stack_used(void);
void clearDPMIstate(void);

int page_in(void);
unsigned page_out(int);
int page_is_valid(word32 vaddr);
void page_in_everything(void);
void page_out_everything(void);

int emu_install(char *filename); /* returns 1 if installed, 0 if not */
word32 emu_start_ip(void);

typedef struct AREAS {
  word32 first_addr;	/* in linear space, not program space */
  word32 last_addr;	/* in linear space, not program space */
  word32 foffset;	/* corresponding to first_addr; -1 = zero fill only */
  word16 fileno;	/* which file to get pages from */
  word16 filler;
  } AREAS;

typedef enum {
  A_text,
  A_data,
  A_bss,
  A_arena,
  A_stack,
  A_vga,
  A_syms,
  A_syms2,
  A_emu,
  A_max
} AREA_TYPES;
#define MAX_AREA        9
extern AREAS areas[MAX_AREA];

void loadAout(const AREAS* areas);

#endif
