//
// $Header$
// $Log$
//
// Copyright 1991
//
// Objective Systems, Inc.
//  Richard A. Doust        3/13/91
//  Phone:                  (201) 335-0691
//

#include <iostream.h>
#include <pxengine.h>
#include <pdxpp.h>
#include <string.h>
#include <stdio.h>
#include <ui_win.hpp>
#include "menu.hpp"
#include "menuids.h"
#include "prndlg.hpp"
#include "magdlg.hpp"

UIW_WINDOW *window;
UI_WINDOW_MANAGER *windowManager;

void MenuHandler(void *item, UI_EVENT &event);

int main(int argc, char **argv)
{

    UI_DISPLAY *display = new UI_DOS_BGI_DISPLAY;
    if (argc > 1)
    {
        if (*argv[1] == '-' && argv[1][1] == 't' || argv[1][1] == 'T')
        {
            delete display;
            display = new UI_DOS_TEXT_DISPLAY;
        }
    }

    if (!display->installed)
    {
        delete display;
        display = new UI_DOS_TEXT_DISPLAY;
    }

    UI_EVENT_MANAGER *eventManager = new UI_EVENT_MANAGER(100, display);

    *eventManager + new UI_BIOS_KEYBOARD
                  + new UI_MS_MOUSE
                  + new UI_CURSOR;

    windowManager = new UI_WINDOW_MANAGER(display, eventManager);
    _errorSystem = new UI_ERROR_WINDOW_SYSTEM;

    window = new UIW_WINDOW(0, 1, 80, 20, WOF_NO_FLAGS, WOAF_NO_FLAGS,
            NO_HELP_CONTEXT);

    *window + new UIW_BORDER
            + new UIW_MAXIMIZE_BUTTON
            + new UIW_MINIMIZE_BUTTON
            + new UIW_SYSTEM_BUTTON
            + new UIW_TITLE("Material Maintenance", WOF_NO_ALLOCATE_DATA);

    *window + new PxMenu("Main", MenuHandler);

    *windowManager + window;

    int ccode;
    UI_EVENT event;
    do
    {
        eventManager->Get(event, Q_NORMAL);
        ccode = windowManager->Event(event);
    } while (ccode != L_EXIT && ccode != S_NO_OBJECT);

    delete windowManager;
    delete eventManager;
    delete display;

    return 0;
}

void MenuHandler(void *item, UI_EVENT &event)
{
PxSubMenuItem *pMenu = (PxSubMenuItem *)item;

    switch (pMenu->GetId())
    {
        case IDM_PRINTERS:
            *windowManager + new PrinterDialog();
            break;

        case IDM_MAGAZINES:
            *windowManager + new MagazineDialog();
            break;

        case IDM_EXIT:
            event.type = L_EXIT;
            pMenu->eventManager->Put(event, Q_BEGIN);
            break;

        default:
            _errorSystem->ReportError(windowManager, -1, 
                    "Executing Menu Id %d", pMenu->GetId());
            break;
    }
}

