//==============================================================
//
//	Filename	:	DLLDB.H
//
//	Purpose		:	Header file for DLLDB
//
//	Date			:	January 5, 1992
//
//	Prog/Dev	:	Edward B. Toupin
//
//==============================================================
//
//	COMPILER	:	Borland C++ / TCW++
//							Borland Resource Workshop
//
//	MODEL			:	Compact
//
//	NOTICE		:	(c)1992 Edward B. Toupin
//							All Rights Reserved
//
//							The reader may use as seen fit, for profit
//							and otherwise, so long as credit is given
//							to the author Edward B. Toupin.
//
//==============================================================

//Defines Database Calls
#define	INT					1
#define	CHAR				2
#define	STRING			3
#define	FLOAT				4

#define	ULONGINT		6
#define LONGINT			7
#define	UCHAR				8
#define	UINT     		9


//Maximum number of databases and indexes per database
#define	MAX_DB			5
#define	MAX_INDEX   5
#define	MAX_IENTRY  5

//------------------------------------------------------
//
//	Imports from DLLDB
//
//------------------------------------------------------
extern "C"
{
	BOOL FAR PASCAL SetupDatabase(LPSTR,long,LPSTR);
	BOOL FAR PASCAL OpenDatabase(LPSTR);
	BOOL FAR PASCAL CloseDatabase(LPSTR);
	BOOL FAR PASCAL AddRecord(LPSTR,LPSTR);
	BOOL FAR PASCAL GetNextRecord(LPSTR,LPSTR);
	BOOL FAR PASCAL GetPreviousRecord(LPSTR,LPSTR);
	BOOL FAR PASCAL GetFirstRecord(LPSTR,LPSTR);
	BOOL FAR PASCAL GetLastRecord(LPSTR,LPSTR);
	BOOL FAR PASCAL GetCurrentRecord(LPSTR,LPSTR);
	BOOL FAR PASCAL PurgeDatabases();
	BOOL FAR PASCAL DeleteRecord(LPSTR);
	BOOL FAR PASCAL UpdateRecord(LPSTR,LPSTR);
	long FAR PASCAL GetCurrentRecordNumber(LPSTR);
	BOOL FAR PASCAL RecordDeleted(LPSTR);
	BOOL FAR PASCAL	FindRecord(LPSTR,LPSTR,LPSTR,int,long);
	BOOL FAR PASCAL CreateIndex(LPSTR,int,int,int,LPSTR,long,long);
	BOOL FAR PASCAL SetIndex(LPSTR,int);
	BOOL FAR PASCAL AddIndex(long,LPSTR,int);
	BOOL FAR PASCAL GetPreviousIndexEntry(LPSTR,int,LPSTR);
	BOOL FAR PASCAL GetNextIndexEntry(LPSTR,int,LPSTR);
	BOOL FAR PASCAL GetFirstIndexEntry(LPSTR,int,LPSTR);
	int  FAR PASCAL GetCurrentIndex(LPSTR);
	BOOL FAR PASCAL FindIndexEntry(LPSTR,int,LPSTR,LPSTR);
	BOOL FAR PASCAL FindIndexEntryPartial(LPSTR,int,LPSTR,LPSTR);
}
