#include <dos.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <mem.h>
#include "vidlib.h"

void L40set(void);

int _select_scanline_count(int scans)
{
   union REGS r;
   if ((scans != 200)&&(scans != 350)&&(scans != 400))
      return(0);
   r.h.ah=0x12;
   r.h.al=(unsigned char)scans;
   int86(0x10,&r,&r);
   return(r.h.al);
}

int _select_character_points(int points)
{
   union REGS r;
   if ( points == 16 ) {
      r.x.ax=0x1114;
      r.h.bl=0;
      int86(0x10,&r,&r);
      return(1);
   }
   if ( points == 14 ) {
      r.x.ax=0x1111;
      r.h.bl=0;
      int86(0x10,&r,&r);
      return(1);
   }
   if ( points == 8 ) {
      r.x.ax=0x1112;
      r.h.bl=0;
      int86(0x10,&r,&r);
      return(1);
   }
   return(0);
}

int Textmode(int lines)
{
    _select_scanline_count(400);
    VGAmode(3, NULL); /* default to 25 */
    switch (lines) {
       case 25:    break; /* already 25 */
       case 28:    _select_character_points(14); break;
       case 33:    L33set();
                   BIOScrtbuflen=0x2000; /* allow 8k pages */
                   break;
       case 40:    L40set();
                   BIOScrtbuflen=0x4000;  /* allow 16k pages */
                   break;
       case 50:    _select_character_points(8);  break;
    }
    return(BIOScrtrows+1);
}


