#include <dos.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <mem.h>
#include "vidlib.h"

/* video to video copy, 16 colors, planar */
int Vcopy16(unsigned dx, unsigned dy,
            unsigned sx, unsigned sy, unsigned sdx, unsigned sdy)
{
   char *dest;
   char *src;
   unsigned yo;
   int  oldWmode;

   /* check parameters */
   if ( (dx+sdx > _screen_width) || (sx+sdx > _screen_width) ||
        (dy+sdy > _memory_length) || (sy+sdy > _memory_length) ||
        ((long)(sdx * sdy) > 0xFFFFL ) )
       return(0);
   if ( vgadebug != NULL ) {
      sprintf(tdbg,"Vc16: dx=%u, dy=%u, sx=%u, sy=%u, sdx=%u, sdy=%u\n",
                   dx, dy, sx, sy, sdx, sdy);
      fputs(tdbg,vgadebug);
   }

   oldWmode=What_Wmode();
   Select_Wmode(1);
   dest=(char *)normalize(_screen_start + dy*_screen_width + dx);
   src=(char *)normalize(_screen_start + sy*_screen_width + sx);
   if ( vgadebug != NULL ) {
     sprintf(tdbg,"     : dest=%Fp, src=%Fp, m1=%u, m2=%u\n",
                  dest, src, oldWmode, What_Wmode());
     fputs(tdbg,vgadebug);
   }
   for (yo=0; yo < sdy; yo++) {
          /* must use a byte-at-a-time copy only here! */
          memcpyb(dest, src, sdx);
          dest=(char *)normalize(dest + _screen_width);
          src=(char *)normalize(src + _screen_width);
   }
   Select_Wmode(oldWmode);
   return(1);
}

/* Memory to video copy, 16 color, planar memory to planar  video */
int Vdisp16( unsigned dx, unsigned dy,
             char *s, unsigned sw, unsigned sl,
             unsigned sx, unsigned sy, unsigned sdx, unsigned sdy)
{
   char *dest;
   char *src;
   unsigned yo;

   /* check parameters */
   if ( ( dx+sdx > _screen_width) || (dy+sdy > _memory_length) ||
        ( sx+sdx > sw) || (sy+sdy > sl) ) {
      printf("Invalid parameters to Vdisp16\n");
      return(0);
   }
   dest=(char *)normalize(_screen_start + dy*_screen_width + dx);
   src=(char *)normalize(s + sy*sw*4 + sx);

   if ( vgadebug != NULL ) {
      sprintf(tdbg,"Vd16: dx=%u, dy=%u, s=%Fp, sw=%u, sl=%u, sx=%u\n"
                   "      sy=%u, sdx=%u, sdy=%u\n",
                   dx, dy, s, sw, sl, sx, sy, sdx, sdy);
      fputs(tdbg,vgadebug);
      sprintf(tdbg,"    : dest=%Fp, src=%Fp\nGC[0]=%x, GC[1]=%x, GC[2]=%u"
                   ", GC[3]=%u, GC[5]=%u, GC[8]=%x\n", dest, src,
                   GCread_reg(0), GCread_reg(1), GCread_reg(2), GCread_reg(3),
                   GCread_reg(5), GCread_reg(8));
      fputs(tdbg,vgadebug);
   }
   Select_Wmode(0);

   for (yo=0; yo < sdy; yo++) {
       Select_WPlane(WPlane0);
       memcpy(dest,src,sdx);
       src=(char *)normalize(src + sw);

       Select_WPlane(WPlane1);
       memcpy(dest,src,sdx);
       src=(char *)normalize(src + sw);

       Select_WPlane(WPlane2);
       memcpy(dest,src,sdx);
       src=(char *)normalize(src + sw);

       Select_WPlane(WPlane3);
       memcpy(dest,src,sdx);
       dest=(char *)normalize(dest + _screen_width);
       src=(char *)normalize(src + sw);
   }
   Select_WPlane(WPlaneALL);
   return(1);
}

/* Video to Memory copy, 16 color, planar video to planar memory */
int Vcapt16( char *d, unsigned dw, unsigned dl,
                          unsigned dx, unsigned dy,
                      unsigned sx, unsigned sy, unsigned sdx, unsigned sdy)
{
   char *dest;
   char *src;
   unsigned yo;

   /* check parameters */
   if ( ( sx+sdx > _screen_width) || (sy+sdy > _memory_length) ||
        ( dx+sdx > dw) || (dy+sdy > dl) ) {
      printf("Invalid parameters to Vdisp16\n");
      return(0);
   }
   src=(char *)normalize(_screen_start + sy*_screen_width + sx);
   dest=(char *)normalize(d + dy*dw*4 + dx);

   if ( vgadebug != NULL ) {
      sprintf(tdbg,"Vct16: d=%Fp, dw=%u, dl=%u, dx=%u, dy=%u\n"
                   "       sx=%u, sy=%u, sdx=%u, sdy=%u\n",
                   d, dw, dl, dx, dy, sx, sy, sdx, sdy);
      fputs(tdbg,vgadebug);
      sprintf(tdbg,"    : dest=%Fp, src=%Fp\n", dest, src);
      fputs(tdbg,vgadebug);
   }

   for (yo=0; yo < sdy; yo++) {
       Select_RPlane(0);
       memcpy(dest, src, sdx);
       dest=(char *)normalize(dest + dw);

       Select_RPlane(1);
       memcpy(dest, src, sdx);
       dest=(char *)normalize(dest + dw);

       Select_RPlane(2);
       memcpy(dest, src, sdx);
       dest=(char *)normalize(dest + dw);

       Select_RPlane(3);
       memcpy(dest, src, sdx);
       src=(char *)normalize(src + _screen_width);
       dest=(char *)normalize(dest + dw);
   }
   return(1);
}


