/* 
**		file:		dbf.h
**		purpose:	header file defining structures and error codes for dbase access
**					routines.
**		notes:	this file must be included in any programs which use the dbase
**					access routines included in dbf.lib.  do not use -a option with
**					this header file.
**		author:	Mark Sadler
**		revised:	6/18/87
*/ 

#define		DB2FILE			2
#define		DB3FILE			3
#define		DB3WITHMEMO		0x83
#define		FIELD_REC_LEN	32		/*	length of field description record */
#define		HEADER_PROLOG	32		/*	length of header without field desc and terminator */
#define		MAX_HEADER		4129	/*	maximum length of dBase III header	*/
#define		MAX_RECORD		4000	/*	dBase III record limit */
#define		MAX_FIELDS		128	/*	dBase III field limit */
#define		MAX_MEMO_BYTES	512	/*	dBase III memo field record size */

#define 		MAXPATH			80
/* error codes */
#define		OUT_OF_MEM		8		/*	insufficient memory error */
#define		NO_FILE			2		/*	file not found error */
#define		BAD_FORMAT		11		/*	file not dBASE III file */
#define		RECNO_TOO_BIG	105	/*	requested record too big */

typedef unsigned char UCHAR;

struct	FIELD_RECORD					/* This structure is filled in memory */
{												/* with a fread.	do not change. */
		char	 name[11];					/* name of field in asciz */
		char	 typ;						 	/* type of field...char,numeric etc. */
		char *field_data_address; 		/* offset of field in record */
		#if defined(__TINY__) || defined(__SMALL__) || defined (__MEDIUM__)
		int space_holder;					/* field_data_address must be 32 bits */
		#endif
		UCHAR	len;						 	/* length of field */
		UCHAR	dec;						 	/* decimals in field */
		UCHAR	reserved_bytes[14];		/* reserved by dbase */
};

struct	DBF
{
		char filename[MAXPATH];					/* dos filename */
		FILE *file_ptr;						/* c file pointer */
		unsigned long int current_record;/* current record in memory */
		enum								 		/* status of file */
		{
			not_open=0,
			not_updated,
			updated
		} status;
		UCHAR	num_fields;				 		/* number of fields */

		/* the following 7 variables are filled with a fread, do not change order or size */
		UCHAR	dbf_version;					/* version character */
		UCHAR	update_yr;						/* date of last update - year	(-1900) */
		UCHAR	update_mo;						/* date of last update - month */
		UCHAR	update_day;				 		/* date of last update - day	*/
		unsigned long int records;			/* number of records in dbf */
		unsigned int	header_length;		/* length of header structure */
		unsigned int	record_length;		/* length of a record */
		/*															 */
		struct FIELD_RECORD *fields_ptr;	/* pointer to field array */
		char *record_ptr;					 	/* pointer to current record struct */
};

int d_addrec(struct DBF *d);
int d_blank(struct DBF *d);
int d_close(struct DBF *d);
int d_cpystr(struct DBF *s,struct DBF *d);
char d_getfld(struct DBF *d,int f,char *buff);
int d_getrec(struct DBF *d,unsigned long int r);
int d_open(struct DBF *d);
int d_putfld(struct DBF *d,int f,char *buff);
int d_putrec(struct DBF *d,unsigned long int r);

