///////////////////////////////////////////////////////
// EXAMPLE.EXE                                       //
// Programmed by: Chris Bomar                        //
// Apocalyptic Dimensions Software                   //
//                                                   //
// Example program for the ADS Database Library v1.0 //
///////////////////////////////////////////////////////

#include <iostream.h>
#include <string.h>
#include "database.h"

int main(void)
{
// Variables for each of the fields.
char name[100];
int age;
char phone[100];
float salary;

// Open EXAMPLE.DAT as our datafile.
database example("EXAMPLE.DAT");

// Create our fields.
example.createField("STRING");
example.createField("INT");
example.createField("STRING");
example.createField("FLOAT");
// Initialize the record.
example.InitRecord();

// Create 3 records.
strcpy(name, "Sandy Sansing");
age = 25;
strcpy(phone, "456-1934");
salary = 20000;
example.putField(1, name);
example.putField(2, age);
example.putField(3, phone);
example.putField(4, salary);
example.putRecord(1);

strcpy(name, "Pete Moore");
age = 31;
strcpy(phone, "484-0934");
salary = 22000;
example.putField(1, name);
example.putField(2, age);
example.putField(3, phone);
example.putField(4, salary);
example.putRecord(2);

strcpy(name, "Justine Mist");
age = 19;
strcpy(phone, "456-1934");
salary = 18000;
example.putField(1, name);
example.putField(2, age);
example.putField(3, phone);
example.putField(4, salary);
example.putRecord(3);


cout << "\nExample program for the Database Library.\n";
cout << "-----------------------------------------\n";

example.getRecord(2);
cout << "\nName of record #2: ";
example.getField(1, name);
cout << name << "\n";
cout << "Age of record #2: ";
example.getField(2, &age);
cout << age << "\n";

example.deleteRecord(2);

// Error Check this one for example.
// You should always error check but I made this program a bit fast.
// If your error checking on a large scale you might want to make an error
// handling funtion to drop to if an error occurs.
if ((example.getRecord(1)) != 0)
   {cout << "Error!\n"; return 1;}
cout << "\nSalary of record #1: ";
if ((example.getField(4, &salary)) != 0)
   {cout << "Error!\n"; return 1;}
cout << salary << "\n";
return 0;
}


