////////////////////////////////////////
// DATABASE.H                         //
// Apocalyptic Dimensions             //
// Programmed by:  Chris Bomar        //
// Copyright 1995 Chris Bomar         //
//                                    //
// Declaration for the database class //
////////////////////////////////////////

#ifndef __DATABASE_H
#define __DATABASE_H

#include <string.h>
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <fstream.h>

class database {
   char fileName[255];
   char version[5];
   unsigned char recordExist;
   char record_locked;
   int movetoField(unsigned int);
   long length;
   unsigned int totalFields;
   unsigned char DataFile;

protected:
   struct Node
   {
   char string_data[99];
   unsigned char unchar_data;
   unsigned int unint_data;
   short int shint_data;
   int int_data;
   unsigned long unlong_data;
   long long_data;
   float float_data;
   double double_data;
   long double lgdouble_data;
   Node *next;
   unsigned char datatype;
   };

   FILE *in, *out;
   unsigned int field;
   unsigned long record;
   unsigned char datatype;
   Node *node, *list_h, *list_t;

public:
   database(char *);
   ~database(void);
   int createField(char *);
   int putField(unsigned int, char *);
   int putField(unsigned int, unsigned char);
   int putField(unsigned int, unsigned int);
   int putField(unsigned int, short int);
   int putField(unsigned int, int);
   int putField(unsigned int, unsigned long);
   int putField(unsigned int, long);
   int putField(unsigned int, float);
   int putField(unsigned int, double);
   int putField(unsigned int, long double);
   int getField(unsigned int, char *);
   int getField(unsigned int, unsigned char *);
   int getField(unsigned int, unsigned int *);
   int getField(unsigned int, short int *);
   int getField(unsigned int, int *);
   int getField(unsigned int, unsigned long *);
   int getField(unsigned int, long *);
   int getField(unsigned int, float *);
   int getField(unsigned int, double *);
   int getField(unsigned int, long double *);
   int putRecord(unsigned long);
   int getRecord(unsigned long);
   int deleteRecord(unsigned long);
   int InitRecord(void);
};

#endif