/*[]------------------------------------------------------------[]*/
/*|                                                              |*/
/*|     'Critical error handler' example that can be used        |*/
/*|      to determine if a floppy disk has been formatted        |*/
/*|          Valid ONLY with DOS version 3.0 or greater          |*/
/*|                                                              |*/
/*|     Copyright (c) 1991 by Borland International              |*/
/*|     All Rights Reserved.                                     |*/
/*|                                                              |*/
/*[]------------------------------------------------------------[]*/

/* Written by Jeff Peters */

#include <stdio.h>
#include <dos.h>

void interrupt (*old_24) (void);
void open_file (char *);
void interrupt new_24 (bp,di,si,ds,es,dx,cx,bx,ax,ip,cs,flags)
{
  ax = 3;  /* simply fail the function */
           /* note: this only works on DOS 3.0 and above */
}

int main (void)
{
  char *fname = "A:\\nul";   /* try to open device 'nul' on root dir of A: */
  old_24 = getvect (0x24);   /* grab old handler */
  setvect (0x24, new_24);    /* set new handler */
  open_file (fname);         /* try to do the open */
  setvect (0x24, old_24);    /* reset vector */
  return 0;                  /* exit program */
}

void open_file (char *name)
{
  unsigned int flags, error;
  FILE *fp;

  _DX = FP_OFF (name);       /* address of string to open */
  _AX = 0x3D00;              /* open for read  function */
  geninterrupt (0x21);
  __emit__ (0x9C, 0x59);     /* pushf, pop cx */
  flags = _CX;               /* save the flags into cx */
  error = _AX;
  if (flags & 1 == 1)        /* test the carry_flag */
  {
    if (error == 3)   /* 3 = path not found, meaning no root directory */
    {
      /* fp = fopen ("c:\\formatted", "wt");
         fclose (fp);    this sets your flag file    */
         printf ("\nDisk not formatted!\n");
    }
    else
      printf ("\nDOS error %04X\n", error);
  }
  else
  {
    printf ("\nDisk is formatted.\n");
    _BX = error;
    _AH = 0x3E;
    geninterrupt (0x21);   /* close file */
  }
}

