#include  <stdio.h>
#include <stdlib.h>
#include     <io.h>
#include  <fcntl.h>
#include <string.h>
#include   <stat.h>


void console_iterate( void *arg1, int arg2 );  // required here 
                                               // for sample program
                                               // only

void error_handler( char *msg )
{
    fprintf( stderr, msg );
    exit( 0 );
}

#define HIBYTE(w) ((unsigned char)(((unsigned)(w) >> 8) & 0xFF))
#define LOBYTE(w) ( ((unsigned)(w) & 0x00ff) )


#define DEFAULT_ACCESS  ( O_RDONLY | O_BINARY )
#define DEFAULT_MODE    ( S_IREAD )

class cIO {
private:

    int    access;
    int    handle;
    unsigned mode;

protected:

    void set_private_to_zero( void ) {
         handle = 0;
         access = 0;
         mode   = 0;
    }
    
public:

    int io_open( char *fname,
                 int accss = DEFAULT_ACCESS,
                 unsigned md = DEFAULT_MODE  ) {
        if( handle )
            io_close();
        access = accss;
        mode   = md;
        handle = open( fname, access, mode );
        if( handle < 0 ) {
            char Deb_CIO[ 50 ];
            sprintf( Deb_CIO, "Unable to access %s", fname );
            error_handler( Deb_CIO );
        }
        return( handle );
    }

    cIO( void ) {
         set_private_to_zero();
    }
    
    ~cIO( void ) {
        if( handle )
            io_close();
        set_private_to_zero();
    }

    int io_write( void *buffer, unsigned length ) {
        if( handle )
            return( write( handle, buffer, length ) == length );
        return( 0 );
    }

    void io_close( void ) {
        if( handle )
            close( handle );
        set_private_to_zero();
    }

    int io_read( void *buffer, unsigned length ) {
        if( handle )
            return( read( handle, buffer, length ) == length );
        return( 0 );
    }

    long io_lseek( long target, int fromwhence = SEEK_SET ) {
        if( handle )
            return( lseek( handle, target, fromwhence ) );
        return( -1L );
    }

    long io_tell( void ) {
        if( handle )
            return( tell( handle ) );
        return( -1L );
    }

}; // end of cIO




typedef int ( *tCHAIN_COMPARE )( void *, void  * );
typedef void ( *tCHAIN_ITERATE )( void  *, int );
#define CHAIN_FIRST  1
#define CHAIN_MIDDLE 2
#define CHAIN_LAST   3
#define CHAIN_DUPLICATE 4
//--------------------------------------------------------------
//  
//
//
//
//--------------------------------------------------------------
typedef struct tHNODE {
    int  word_alignment;
    char          *body;
    struct tHNODE *next;
    }tHND;

class cCHAIN {
private:

    struct tHNODE *Root;
    tCHAIN_ITERATE func_iterate;  // iteration function
    tCHAIN_COMPARE func_compare;  // comparison function
                                  // if this function is not initialized
                                  // by the application, the class
                                  // defaults to a LIFO stack
    
    //  all allocation calls come here !
    void *chain_malloc( unsigned len ) {
        void *ret = malloc( len );
        if( !ret ) {
            chain_fault();
        }
        memset( ret, 0, len );
        return( ret );
    }
    
    //  all memory releases come here !
    void chain_release( void *block ) {
        free( block );
    }
    
    //  all allocation failures come here !
    void chain_fault( void ) {
        error_handler( "cCHAIN unable to get memory" );
    }

protected:

    struct tHNODE *chain_allocate_node( ) {
        struct tHNODE *ret;
        ret = ( tHNODE * ) chain_malloc( sizeof( struct tHNODE ) );
        return( ret );
    }

    char *chain_alloc_body( unsigned size ) {
        char *ret = (char *)chain_malloc( size );
        return( ret );
    }

    int chain_walk( tCHAIN_ITERATE fi ) {
        for( struct tHNODE *s = Root; s; s = s -> next ) {
             if( s == Root ) {
                 fi( s -> body, CHAIN_FIRST );
             } else if( !s -> next ) {
                 fi( s -> body, CHAIN_LAST );
             } else {
                 fi( s -> body, CHAIN_MIDDLE );
             }
        }
        return( 1 );
    }

    int chain_compare( void *a1, void *a2 ) {
        if( func_compare == (tCHAIN_COMPARE) NULL ) {
            return( 1 );
        }
        return( func_compare( a1, a2 ) );
    }
    
    int chain_new_node( char *newbody, unsigned size ) {
        struct tHNODE *n = chain_allocate_node( );
        struct tHNODE *i;
        struct tHNODE *p;
        n -> body = ( char * ) chain_alloc_body( size );
        n -> next = NULL;
        memmove( n -> body, newbody, size );
        if( !Root ) {
            Root = n;
            return( CHAIN_FIRST );
        }
        if( chain_compare( Root -> body, newbody ) > 0 ) {
            n -> next = Root;
            Root = n;
            return( CHAIN_FIRST );
        }
        p = Root;
        for( i = Root; i; i = i -> next ) {
             if( chain_compare( i -> body, newbody ) == 0 ) {
                 chain_release( n -> body );
                 chain_release( n );
                 return( CHAIN_DUPLICATE );
             }
             if( chain_compare( i -> body, newbody ) > 0 )
                 break;
             p = i;
        }
        n -> next = p -> next;
        p -> next = n;
        return( CHAIN_MIDDLE );
    }
    
public:

    cCHAIN( tCHAIN_COMPARE cmpfunc = (tCHAIN_COMPARE) NULL ) {
        Root = (struct tHNODE *) NULL;
        func_compare = (tCHAIN_COMPARE) cmpfunc;
        func_iterate = (tCHAIN_ITERATE) NULL;
    }

    ~cCHAIN() {
        struct tHNODE *f = (struct tHNODE *) NULL;
        struct tHNODE *i = Root;
        int fcount = 0;
        while( i ) {
               f = i;
               i = i -> next;
               if( f ) {
                   chain_release( f -> body );
                   chain_release( f );
                   ++fcount;
               }
        }
    }
    
    int chain_insert( char *newbody, unsigned size ) {
        return( chain_new_node( newbody, size ) );
    }

    void chain_set_compare_function( tCHAIN_COMPARE cmpfunc ) {
        func_compare = (tCHAIN_COMPARE) cmpfunc;
    }

    int chain_iterate( tCHAIN_ITERATE fi ) {
        return( chain_walk( fi ) );
    }

};  // end of cCHAIN


#define EXCEL_MAX_RECORD 2080
#define IS_EXCEL_INTEGER(c) ((c==0x02))
#define IS_EXCEL_NUMBER(c)  ((c==0x03))
#define IS_EXCEL_LABEL(c)   ((c==0x04))
#define IS_EXCEL_RK(c)      ((c==126))
#define IS_EXCEL_EOF(c)     ((c==0x0a))
#define IS_EXCEL_BOF(c)     ((c==0x09))
#define IS_EXCEL_DATA(c)    ((c==2||c==3||c==4||c==126))
#define MAX_HEAP_BUFFER  50

void build_excel_header( char *dest, int opcode, unsigned len, int row, int col );
void build_label_record( char *dest, int row, int col, char *label );
int parse_excel_block_header( char *buffer, unsigned *opcode, unsigned *buffsize );
int parse_excel_row_col( char *buffer, int *row, int *col );
int parse_excel_label( char *buffer, char *dest );
double parse_rk_record( char *buffer );
double parse_number_record( char *buffer );
int compare_xls_keys( void *s1, void *s2 );

class cXLS;
typedef struct sXLS {
    char        sort_key[ 11 ];
    unsigned    opcode;
    char        buffer[ MAX_HEAP_BUFFER ];
    cXLS        *reference;
    unsigned    size_of_block;
    }xls;

class cXLS {
private:

    cCHAIN     chain;
    struct sXLS sxls;
    char    *xlsname;
    cIO       xlfile;
    char    *generic;

    void write_BOF( void ) {
        char BOF_image[ 10 ] = {0x09,0x02,0x06,0,0,0,0x10,0,0xba,0x04};
        xlfile.io_write( BOF_image, 10U );
    }

    void write_EOF( void ) {
        char EOF_image[ 4 ] = {0x0a,0,0,0};
        xlfile.io_write( EOF_image, 4U );
    }

    void write_DATA( struct sXLS *p1 ) {
        xlfile.io_write( p1 -> buffer, p1 -> buffer[ 2 ] + 4 );
    }

    int add_BLOCK() {
        int row;
        int col;
        parse_excel_row_col( sxls.buffer, &row, &col );
        sxls.reference = this;
        sprintf( sxls.sort_key, "%05d%05d", row, col );
        unsigned size = sizeof( struct sXLS );
        return( chain.chain_insert( (char *) &sxls, size ) );
        return( 1 );
    }

    int read_HEADER( void ) {
        memset( generic, 0, EXCEL_MAX_RECORD );
        if( xlfile.io_read( generic, 4 ) ) {
            parse_excel_block_header( generic, &sxls.opcode, &sxls.size_of_block );
            return( sxls.opcode );
        } else {
            printf( "failed to read header\n" );
            return( 0 );
        }
    }

    int read_BLOCK( void ) {
        xlfile.io_read( generic + 4, sxls.size_of_block );
        if( IS_EXCEL_DATA(sxls.opcode) ) {
            if( sxls.size_of_block < (MAX_HEAP_BUFFER - 4) ) {
                memset( sxls.buffer, 0, MAX_HEAP_BUFFER );
                memmove( sxls.buffer, generic, sxls.size_of_block + 4 );
                return( 1 );
            }
        }
        return( 0 );
    }

protected:

    friend void data_output( void *, int );
    char *request( unsigned l ) {
        char *m = (char *) malloc( l );
        if( !m )
            error_handler( "memory" );
        return( m );
    }

public:

    cXLS( char *fname ) {
        xlsname = request( strlen( fname ) + 1 );
        strcpy( xlsname, fname );
        chain.chain_set_compare_function( compare_xls_keys );
        generic = request( EXCEL_MAX_RECORD );
    }

    ~cXLS() {
        free( xlsname );
        free( generic );
    }

    int create_label( int r, int c, char *label ) {
        build_label_record( sxls.buffer, r, c, label );
        sxls.opcode    = 0x04;
        sxls.reference = this;
        sprintf( sxls.sort_key, "%05d%05d", r, c );
        return( chain.chain_insert( (char *) &sxls, sizeof( struct sXLS ) ) );
        return( 1 );
    }
    
    void create_number( int r, int c, double num ) {
        //build_excel_header( sxls.buffer, 0x0003, strlen( label ) + 8, row, col );
    }

    void write_XLS( void ) {
        xlfile.io_open( xlsname, O_RDWR | O_BINARY | O_CREAT | O_TRUNC, S_IREAD | S_IWRITE );
        write_BOF();
        chain.chain_iterate( data_output );
        write_EOF();
        xlfile.io_close();
    }

    void read_XLS( void ) {
        if( xlfile.io_open( xlsname, O_RDONLY | O_BINARY ) ) {
            int i = 0;
            int op = read_HEADER();
            if( !IS_EXCEL_BOF(op) )
                error_handler( "invalid xls" );
            read_BLOCK();
            op = read_HEADER();
            while( !IS_EXCEL_EOF(op) ) {
                   if( !sxls.size_of_block )
                       break;
                   read_BLOCK();
                   if( IS_EXCEL_DATA(op) ) {
                       add_BLOCK();
                   } else {
                   }
                   ++i;
                   op = read_HEADER();
            }
            xlfile.io_close();
        }
    }

    int read_XLS_cell( int r, int c, char *destination ) {
        if( xlfile.io_open( xlsname, O_RDONLY | O_BINARY ) ) {
            int i = 0;
            int op = read_HEADER();
            if( !IS_EXCEL_BOF(op) )
                error_handler( "invalid xls" );
            read_BLOCK();
            op = read_HEADER();
            while( !IS_EXCEL_EOF(op) ) {
                   if( !sxls.size_of_block )
                       break;
                   read_BLOCK();
                   if( IS_EXCEL_DATA(op) ) {
                       int row, col;
                       parse_excel_row_col( sxls.buffer, &row, &col );
                       if( row == r ) {
                           if( col == c ) {
                               if( IS_EXCEL_LABEL(op) ) {
                                   parse_excel_label( sxls.buffer, destination );
                                   return( op );
                               } else if( IS_EXCEL_NUMBER(op) ) {
                                   sprintf( destination, "%lf", parse_number_record( sxls.buffer ) );
                                   return( op );
                              } else if( IS_EXCEL_RK(op) ) {
                                   sprintf( destination, "%lf", parse_rk_record( sxls.buffer ) );
                                   return( op );
                              }
                           }
                       }
                       if( row > r && col > c ) {
                           xlfile.io_close();
                           return( 0 );
                       }
                   }
                   ++i;
                   op = read_HEADER();
            }
            xlfile.io_close();
        }
        return( 0 );
    }

    void to_console( void ) {
        chain.chain_iterate( console_iterate );
    }

    void iterate( tCHAIN_ITERATE fi ) {
        chain.chain_iterate( fi );
    }
};  // end of cXLS
/**************************************************************/
/*                                                            */
/*                                                            */
/*                                                            */
/*                                                            */
/*                                                            */
/**************************************************************/
void build_excel_header( char *dest, int opcode, unsigned len, int row, int col )
{
    dest[ 0 ] = LOBYTE( opcode );
    dest[ 1 ] = HIBYTE( opcode );
    dest[ 2 ] = len;
    dest[ 3 ] = 0;
    dest[ 4 ] = LOBYTE( row );
    dest[ 5 ] = HIBYTE( row );
    dest[ 6 ] = LOBYTE( col );
    dest[ 7 ] = HIBYTE( col );
    dest[ 8 ] = 0x0f;
    dest[ 9 ] = 0x00;
}
/**************************************************************/
/*                                                            */
/*                                                            */
/*                                                            */
/*                                                            */
/*                                                            */
/**************************************************************/
void build_label_record( char *dest, int row, int col, char *label ) {
    build_excel_header( dest, 0x0204, strlen( label ) + 8, row, col );
    dest[ 10 ] = strlen( label );
    dest[ 11 ] = 0x00;
    strcpy( dest + 12, label );
}
/**************************************************************/
/*                                                            */
/*                                                            */
/*                                                            */
/*                                                            */
/*                                                            */
/**************************************************************/
int parse_excel_block_header( char *buffer, unsigned *opcode, unsigned *buffsize )
{
    *opcode   = buffer[ 0 ] | ( buffer[ 1 ] << 8 );
    *buffsize = buffer[ 2 ] | ( buffer[ 3 ] << 8 );
    *opcode &= 0xfdff;
    return( ( *buffsize > 0 ) );
}
/**************************************************************/
/*                                                            */
/*                                                            */
/*                                                            */
/*                                                            */
/*                                                            */
/**************************************************************/
int parse_excel_row_col( char *buffer, int *row, int *col )
{
    memmove( row, buffer + 4, sizeof( int ) );
    memmove( col, buffer + 6, sizeof( int ) );
    return( 1 );
}
/**************************************************************/
/*                                                            */
/*                                                            */
/*                                                            */
/*                                                            */
/*                                                            */
/**************************************************************/
int parse_excel_label( char *buffer, char *dest )
{
    strcpy( dest, buffer + 12 );
    return( 1 );
}
/**************************************************************/
/*                                                            */
/*                                                            */
/*                                                            */
/*                                                            */
/*                                                            */
/**************************************************************/
double parse_rk_record( char *buffer )
{union {char c[ 8 ];double d;};
    memset( c, 0, 8 );
    memmove( &c[ 4 ], buffer + 10, 4 );
    return( d );
}
/**************************************************************/
/*                                                            */
/*                                                            */
/*                                                            */
/*                                                            */
/*                                                            */
/**************************************************************/
void build_rk_record( char *dest, int row, int col, double rk ) {
    build_excel_header( dest, 0x0204, strlen( label ) + 8, row, col );
    dest[ 10 ] = strlen( label );
    dest[ 11 ] = 0x00;
    strcpy( dest + 12, label );
}
/**************************************************************/
/*                                                            */
/*                                                            */
/*                                                            */
/*                                                            */
/*                                                            */
/**************************************************************/
double parse_number_record( char *buffer )
{union {char c[ 8 ];double d;};
    memset( c, 0, 8 );
    memmove( c, buffer + 10, 8 );
    return( d );
}
/**************************************************************/
/*                                                            */
/*                                                            */
/*                                                            */
/*                                                            */
/*                                                            */
/**************************************************************/
int compare_xls_keys( void *s1, void *s2 )
{
struct sXLS *p1 = (struct sXLS *)s1;
struct sXLS *p2 = (struct sXLS *)s2;
    return( strcmp( p1 -> sort_key, p2 -> sort_key ) );
}
/**************************************************************/
/*                                                            */
/*                                                            */
/*                                                            */
/*                                                            */
/*                                                            */
/**************************************************************/
void data_output( void *s1, int flag )
{
struct sXLS *p1 = (struct sXLS *)s1;
cXLS *t = p1 -> reference;
    t -> write_DATA( p1 );
}

void console_iterate( void *arg1, int arg2 )
{
struct sXLS *ptr = ( struct sXLS * )arg1;
    fprintf( stdout, "BLK SIZE:  %d\n", ptr -> size_of_block );
    if( IS_EXCEL_NUMBER( ptr -> opcode ) ) {
        double d = parse_number_record( ptr -> buffer );
        fprintf( stdout, "RC:  %s  OP %04X  BUF:  %lf\n",
                 ptr -> sort_key, 
                 ptr -> opcode, d );
    } else if( IS_EXCEL_RK( ptr -> opcode ) ) {
        double rk = parse_rk_record( ptr -> buffer );
        fprintf( stdout, "RC:  %s  OP %04X  BUF:  %lf\n",
                 ptr -> sort_key, 
                 ptr -> opcode, rk );
    }

}


int main()
{
    cXLS Anysheet( "DIDDLE.XLS" );
    Anysheet.read_XLS();
    Anysheet.to_console();
    return( 0 );
}
