/*
	CSTRINGS.LBR VERSION 1.0
	Spark Software, Inc.

		If you find this software of use, it is requested that you send
		a donation ($10.00 suggested) to:

			Spark Software, Inc.
			24 Royal Crest Dr., #5
			Nashua, NH  03060

		Upon receiving your donation, your name will be added to the 
		List of Registered Users, and future updates can be obtained
		from the SPARKIE RBBS at (603) 888-8179.

		If you include an extra $10.00 with your donation, the newest
		version of CSTRINGS.LBR will be mailed to you.

		Call SPARKIE RBBS at the number above for other Spark Software
		products!!!
*/
		
/*
 *	char *
 *	index (str, c)
 *	char *str;
 *	int c;	/* just to allow c to be a register variable */
 *
 *	This function returns a pointer to the first occurrence of the
 *	character c in string str.  It returns the NULL pointer if c does
 *	not appear in str.
 */

char *index(str, c)
register char *str;
register int c;
{
					/* Loop through str */
	while (*str) {

					/* We found c, so return the
					   current pointer */
		if (*str == c)
			return (str);

					/* We did not find c, so keep
					   looping */
		++str;
	}

					/* We never found c, so return
					   the NULL pointer which is
					   (almost) always defined as
					   (char *) 0 */
	return ((char *) 0);

} /* index */

/*
 *	char *
 *	rindex (str, c)
 *	char *str;
 *	int c;	/* just to allow c to be a register variable */
 *
 *	This function returns a pointer to the last occurrence of the
 *	character c in string str.  It returns the NULL pointer if c does
 *	not appear in str.
 */

char *rindex(str, c)
register char *str;
register int c;
{
	register char *lastc;

					/* First set up the default
					   return value of NULL */
	lastc = (char *) 0;

					/* Now loop through str saving the
					   latest occurence of c */
	do {
		if (*str == c)
			lastc = str;
	} while (*str++);

					/* Finally return the last location
					   of c (still NULL if c was never
					   found in str */
	return (lastc);

} /* rindex */

/*
 *	char *
 *	strchr (str, c)
 *	char *str;
 *	int c;	/* just to allow c to be a register variable */
 *
 *	This function returns a pointer to the first occurrence of the
 *	character c in string str.  It returns the NULL pointer if c does
 *	not appear in str.  It is simply to be compatible with some
 *	compilers which use strchr/strrchr instead of index/rindex
 */

char *strchr (str, c)
register char *str;
register int c;
{

					/* Just return what index
					   would normally return */
	return (index (str, c));

} /* strchr */

/*
 *	char *
 *	strrchr (str, c)
 *	char *str;
 *	int c;	/* just to allow c to be a register variable */
 *
 *	This function returns a pointer to the last occurrence of the
 *	character c in string str.  It returns the NULL pointer if c does
 *	not appear in str.  It is simply to be compatible with some
 *	compilers which use strchr/strrchr instead of index/rindex.
 */

char *strrchr (str, c)
register char *str;
register int c;
{

					/* Just return what rindex
					   would normally return */
	return (rindex (str, c));

} /* strrchr */
