/*
	CSTRINGS.LBR VERSION 1.0
	Spark Software, Inc.

		If you find this software of use, it is requested that you send
		a donation ($10.00 suggested) to:

			Spark Software, Inc.
			24 Royal Crest Dr., #5
			Nashua, NH  03060

		Upon receiving your donation, your name will be added to the 
		List of Registered Users, and future updates can be obtained
		from the SPARKIE RBBS at (603) 888-8179.

		If you include an extra $10.00 with your donation, the newest
		version of CSTRINGS.LBR will be mailed to you.

		Call SPARKIE RBBS at the number above for other Spark Software
		products!!!
*/

/*
 *	char *
 *	strcat (destination, source)
 *	char *destination, *source;
 *
 *	This function appends source (including the null terminator) to
 *	destination, and returns a pointer to the result.
 */

char *strcat(destination, source)
register char *destination, *source;
{
	char *start_pointer;

					/* First save the pointer to the
					   destination so that it can be
					   returned at the end */
	start_pointer = destination;

					/* Now find the end of the
					   destination string */
	while (*destination)
		++destination;

					/* Copy source */
	while (*destination++ = *source++)
		;
					/* Return a pointer to the result */
	return (start_pointer);

} /* strcat */

/*
 *	char *
 *	strncat (destination, source, length)
 *	char *destination, *source;
 *	int length;
 *
 *	This function appends length bytes from source to destination, and
 *	returns a pointer to the result.  If the length of source is less
 *	than length, then the result is null padded.  If the length of source
 *	is greater than or equal to length, then the result will not have a
 *	null terminator added.
 */

char *strncat(destination, source, length)
register char *destination, *source;
int length;
{
	char *start_pointer;

					/* First save the pointer to the
					   destination so that it can be
					   returned at the end */
	start_pointer = destination;

					/* Now find the end of the
					   destination string */
	while (*destination)
		++destination;

					/* Copy source */
	do {

		if (length-- == 0) {
					/* Woops!  The source is too short.
					   Null padding is required */
			*destination = 0;
			break;
		}
	} while (*destination++ = *source++);

					/* Return a pointer to the result */
	return (start_pointer);

} /* strncat */
