/*
        cstrstream.h -- fast strstream operations
        (C) Copyright 1996  John Webster Small
        All rights reserved
*/

#include "cstrstrm.h"

orcstrstream::orcstrstream(cstr& cs)
    : ostrstream((char *)&cs.str()[cs.len()],
         int(cs.vacancy()))
    , _packed(0), _pcount(0)
    , cs_(cs)
    , csStartLen(cs.len())
{
  assert(cs.vacancy() && cs.vacancy() <= size_t(INT_MAX));
}

char * orcstrstream::str()
{
     cs_.setLen(size_t(pcount())+csStartLen);
     return (char *)cs_.str();
}

int orcstrstream::pcount()
{
     if (_packed)
         return _pcount;
     return _pcount = ostrstream::pcount();
}

void orcstrstream::reset()
{
    assert(!_packed);
//    (ostrstream::rdbuf())->freeze(0);
    (void) seekp(0,ios::beg);
    cs_.setLen(csStartLen);
}

void orcstrstream::pack()
{
    if (!_packed)  {
        cs_.setLen(size_t(pcount())+csStartLen);
        cs_.pack();
        (void) ostrstream::str();
        ostrstream::clear
            (int(ios::failbit) | int(ios::badbit));
        _packed = 1;
    }
}

orcstrstream::~orcstrstream()
{
    cs_.setLen(size_t(pcount())+csStartLen);
}

rcstrstream::rcstrstream(cstr& cs)
    : strstream((char *)&cs.str()[cs.len()],
        int(cs.vacancy()),int(ios::ate))
    , _packed(0), _pcount(0)
    , cs_(cs)
    , csStartLen(cs.len())
{
  assert(cs.vacancy() && cs.vacancy() <= size_t(INT_MAX));
}

char * rcstrstream::str()
{
     cs_.setLen(size_t(pcount())+csStartLen);
     return (char *)cs_.str();
}

int rcstrstream::pcount()
{
    if (_packed)
        return _pcount;
    (void) peek();  // initialize gptr!
    long tmp = tellp() - tellg();
    assert(tmp <= INT_MAX);
    return _pcount = (int) tmp;
}

void rcstrstream::reset()
{
    assert(!_packed);
//    (strstream::rdbuf())->freeze(0);
    (void) seekg(0,ios::beg);
    (void) seekp(0,ios::beg);
    cs_.setLen(csStartLen);
}

void rcstrstream::pack()
{
    if (!_packed)  {
        cs_.setLen(size_t(pcount())+csStartLen);
        cs_.pack();
        (void) strstream::str();
        strstream::clear
            (int(ios::failbit) | int(ios::badbit));
        _packed = 1;
    }
}

rcstrstream::~rcstrstream()
{
    cs_.setLen(size_t(pcount())+csStartLen);
}

#ifdef CSTRSTRM_DEMO

main()
{
        cstr hw(20U);
        hw << "Hello " << 9 << " World!";
        hw.printOn(cout) << endl; // "Hello 9 World!"

        int one, two, three;
        cstr ints("1 2 3");
        ints >> one >> two >> three;
        cout << one << two << three << endl; // 123
        return 0;
}

#endif
