/*
        cstrstream.h -- fast strstream operations
        (C) Copyright 1996  John Webster Small
        All rights reserved
        For demo:  CC -DCSTRSTRM_DEMO cstrstrm cstr
*/

#ifndef cstrstrm_h
#define cstrstrm_h

/* LINTLIBRARY */

// 0 < CSTRSTRM_EXTRA_DEFAULT < INT_MAX
#ifndef CSTRSTRM_EXTRA_DEFAULT
  #define CSTRSTRM_EXTRA_DEFAULT  4095
#endif

#ifndef cstr_h
  #include "cstr.h"
#endif

#ifndef strstream_h
  #include <strstream.h>
  #ifndef strstream_h
    #define strstream_h
  #endif
#endif

class orcstrstream : public ostrstream
{
    int _packed, _pcount;
    cstr& cs_;
    size_t csStartLen;
  public:
    orcstrstream(cstr& cs);
    char * str();
    int pcount();
    strstreambuf * rdbuf() const
        { assert(0); return 0; }
    void reset();
    void pack();
    ~orcstrstream();
};

template <class TYPE>
inline cstr& operator<<(cstr & cs, const TYPE & t)
{ orcstrstream(cs) << t; return cs; }

template <class TYPE>
inline cstr& operator>>(cstr & cs, TYPE & t)
{
    assert(cs.len() && (cs.len() < size_t(INT_MAX)));
    istrstream tmp((char *)cs.str(),int(cs.len()));
    tmp >> t;
    return cs.rmv(0,(size_t)(long)tmp.tellg());
}

class ocstrstream : cstr, public orcstrstream
{
  public:
    ocstrstream(int extra = CSTRSTRM_EXTRA_DEFAULT)
        : cstr((size_t)extra)
        , orcstrstream(*(cstr *)this)
        {}
    ocstrstream(const char * S, int extra = 0)
        : cstr(S,(size_t)extra)
        , orcstrstream(*(cstr *)this)
        {}
    char * str() { return orcstrstream::str(); }
    void pack() { orcstrstream::pack(); }
};

class rcstrstream : public strstream
{
    int _packed, _pcount;
    cstr& cs_;
    size_t csStartLen;
  public:
    rcstrstream(cstr& cs);
    char * str();
    int pcount();
    strstreambuf * rdbuf() const
        { assert(0); return 0; }
    void reset();
    void pack();
    ~rcstrstream();
};

class cstrstream : cstr, public rcstrstream
{
  public:
    cstrstream(int extra = CSTRSTRM_EXTRA_DEFAULT)
        : cstr((size_t)extra)
        , rcstrstream(*(cstr *)this)
        {}
    cstrstream(const char * S, int extra = 0)
        : cstr(S,(size_t)extra)
        , rcstrstream(*(cstr *)this)
        {}
    char * str() { return rcstrstream::str(); }
    void pack() { rcstrstream::pack(); }
};

#endif
