/***********************************************************************

                                       CSA Library, Version 1.7.a 


			   The CSA Library.
		   A demonstration of the PANEL class.

                                           Copyright(c) 1994,1995 
                                                           Combis 
                                                  The Netherlands 
***********************************************************************/


#include "conio.h"
#include "stdio.h"
#include "cskeys.h"
#include "cspanel.h"





void main(void)
{

  desktop();

////////////////////// Explanation ////////////////////////////////

  WINDOW w1;
  w1.head(" Panel Demonstration Program ");
  w1.activate();

  cprintf("\n\n\r ");
  cprintf("\n\r                    This program will show you     ");
  cprintf("\n\r                    three PANELS.                  ");
  cprintf("\n\r                    The first one will be very     ");
  cprintf("\n\r                    simple. It is intended to      ");
  cprintf("\n\r                    demonstrate the defaults.      ");
  cprintf("\n\r                                                   ");
  cprintf("\n\r                    The second panel is quite      ");
  cprintf("\n\r                    elaborate, using most of       ");
  cprintf("\n\r                    the available options.         ");
  cprintf("\n\r                                                   ");
  cprintf("\n\r                    The last panel shows the       ");
  cprintf("\n\r                    automatic data validation,     ");
  cprintf("\n\r                    applied to different data      ");
  cprintf("\n\r                    types.                         ");
  cprintf("\n\r                                                   ");
  cprintf("\n\r                    Hit any key to continue.       ");

  cskey();


  w1.clear();
  cprintf("\n\r ");
  cprintf("\n\r                           About data validation.      ");
  cprintf("\n\r                                                       ");
  cprintf("\n\r               The validation of the edited fields is done afterwards.   ");
  cprintf("\n\r               This means you can enter almost anything, but you can only    ");
  cprintf("\n\r               advance to the next field if the string satisfies the   ");
  cprintf("\n\r               validation restrains.                   ");
  cprintf("\n\r                                                       ");
  cprintf("\n\r               strings:  No validation by default.     ");
  cprintf("\n\r               integers: Maximal 5 digits and no       ");
  cprintf("\n\r                         preceding zero's.             ");
  cprintf("\n\r               longs:    Maximal 10 digits and no      ");
  cprintf("\n\r                         preceding zero's.             ");
  cprintf("\n\r               date:     Valid calendar date,          ");
  cprintf("\n\r                         leap years are accounted for. ");
  cprintf("\n\r               float:                                  ");
  cprintf("\n\r               double:   Valid floating point number,  ");
  cprintf("\n\r                         meaningless preceding         ");
  cprintf("\n\r                         zero's are not allowed.       ");
  cprintf("\n\r                                                       ");
  cprintf("\n\r                    Hit any key to continue.           ");

  cskey();


/////////////////////// The Keys ////////////////////////////////////
  w1.clear();
  cprintf("\n\n\n\r                             A VERY simple panel. ");
  cprintf("\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\r");
  cprintf("         EDIT KEYS: delete, backspace, cursor, insert, tab.   \n\r" );
  cprintf("         EXIT:      enter or esc.               \n\r");
  cprintf("\n                    All fields can be edited.     ");


/////////////////////// Variables for the 1st panel ///////////////////

  char st[26]="The first field."; // Allocate for at least 25 characters
  int i=25;
  char c='Y';


/////////////////////// Define the 1st panel //////////////////////////
  PANEL pan1;			  // Declare panel.

  pan1.height(9);		  // Set the height
  pan1.width(40);		  // Set the width

  pan1.add_field(2,2,25,st);	  // Add field at pos 2,2 with length 25
  pan1.add_field(4,2,7,i);	  // Add field at pos 4,2 with length 7
  pan1.add_field(6,2,1,c);	  // Add field at pos 6,2 with length 1

/////////////////////// Browse through it //////////////////////////////

  pan1.read();			  // Display and edit


/////////////////////// Show the code //////////////////////////////////
  w1.activate();
  w1.clear();

  WINDOW w2;
  w2.set_dim(-1,-1,24,80);
  w2.head(" This is all it took! ");
  w2.activate();
  cprintf("                                                                        \n\r");
  cprintf(" char st[26]=\"The first field.\"; // Allocate for at least 25 characters \n\r");
  cprintf(" int i=25;                                                              \n\r");
  cprintf(" char c='Y';                                                            \n\r");
  cprintf("                                                                        \n\r");
  cprintf(" PANEL pan1;                     // Declare panel.                      \n\r");
  cprintf("                                                                        \n\r");
  cprintf(" pan1.height(9);                 // Set the height                      \n\r");
  cprintf(" pan1.width(40);                 // Set the width                       \n\r");
  cprintf("                                                                        \n\r");
  cprintf(" pan1.add_field(2,2,25,st);      // Add field at pos 2,2 with length 25 \n\r");
  cprintf(" pan1.add_field(4,2,7,i);        // Add field at pos 4,2 with length 7  \n\r");
  cprintf(" pan1.add_field(6,2,1,c);        // Add field at pos 6,2 with length 1  \n\r");
  cprintf("                                                                        \n\r");
  cprintf(" pan1.read();                    // Display and edit                    \n\r");
  cprintf("                                                                        \n\r");
  cprintf("               // Notice the conversion from integer to string and      \n\r");
  cprintf("               // vice versa is done automatically.                     \n\r");
  cprintf("               // The syntax for adding a field is the same             \n\r");
  cprintf("               // in all cases.                                           \n\r");
  cprintf("                                                                        \n\r");
  cprintf("    Hit any key to continue......                                       ");


  cskey();




/////////////////////// Complex Panel ///////////////////////////////

  cprintf("\n\n\r      A complicated panel. ");


  w2.remove();
  w2.set_dim(-1,-1,19,60);
  w2.head(" Panel 2 ");
  w2.activate();

  w2.clear();

  cprintf("\n\n\r");
  cprintf("   The next panel you can only 'exit' by pressing    \n\r");
  cprintf("   F10 while the cursor is in the 'exit' field.      \n\r");
  cprintf("   The 'ESC' key has been disabled.                  \n\r");
  cprintf("                                                     \n\r");
  cprintf("   Strings which are longer then the                 \n\r");
  cprintf("   field will SCROLL within the field.               \n\r");
  cprintf("                                                     \n\r");
  cprintf("   Two fields are 'browse only' which                \n\r");
  cprintf("   means you are able to put the cursor              \n\r");
  cprintf("   at the field, but are not allowed to edit.        \n\r");
  cprintf("   One field is 'display only', which make           \n\r");
  cprintf("   the cursor skip it.                               \n\r");
  cprintf("                                                     \n\r");
  cprintf("                Hit any key to continue. ");

  cskey();
  w2.remove();


/////////////////////// Variables for the panel ///////////////////

  char name[]="Neil A. Armstrong ";
  char ship[]="USS Enterprise  ";
  char rank[]="Retired ";
  char acco[]="The first man ever to set foot on the moon. ";
  char info[]="Neil Armstrong was an astronaut in the years 1962-1970.";
  char birth[]="22/03/1930";
  char ok[]="You can leave the panel by pressing F10 in this field.";


///////////////////////// PANEL DEFINITION /////////////////////
  PANEL panel;

  panel.set_dim(4,11,17,65);		       // Size and Position of panel
  panel.head(" Panel 2 ");                     // Heading
  panel.border(BORDER_DOUBLE);		       // Type of border
  panel.activate();			       // Make panel-window visible

  gotoyx(2,10); cprintf("Astronaut: ");
  panel.add_field(3,10,25,name);

  gotoyx(5,10); cprintf("Favourite space ship: ");
  panel.add_field(6,10,25,ship);
  panel.protect(DISPLAY);		       // Display only (no editting).

  gotoyx(2,40); cprintf("Rank: ");
  panel.add_field(3,40,15,rank);

  gotoyx(5,40); cprintf("Birthday (DD/MM/YYYY): ");
  panel.add_field(6,40,birth);

  gotoyx(8,10); cprintf("Accomplishment: ");
  panel.add_field(9,10,30,acco);
  panel.mod_field.max_len(60);		       // Max. 60 pos. for the string

  gotoyx(10,10); cprintf("Additional info: ");
  panel.add_field(11,10,25,info);
  panel.protect(BROWSE);

  panel.add_field(15,4,strlen(ok)+2,ok);
  panel.mod_field.border(BORDER_SINGLE);       // A field with a border!
  panel.mod_field.head("Exit");
  panel.mod_field.border_color(panel.screen_color());
  panel.protect(BROWSE);
  panel.exit_field(TRUE);

  panel.exit_key(F10);

  panel.escape_off();


/////////////////////// Browse through it //////////////////////////////

  panel.read();

/////////////////////// Removing panel /////////////////////////////////

  panel.remove();

/////////////////////// Do some explaining //////////////////////////
  w1.clear();


  w2.remove();
  w2.head(" Data validation example ");
  w2.set_dim(3,-1,20,60);
  w2.activate();

  w2.clear();

  cprintf("\n\r");
  cprintf("   The last panel gives an impression          \n\r");
  cprintf("   of the capabilities concerning              \n\r");
  cprintf("   data validation.                            \n\r");
  cprintf("                                               \n\r");
  cprintf("   For each supported type a field             \n\r");
  cprintf("   is present.                                 \n\r");
  cprintf("                                               \n\r");
  cprintf("   You can't leave a field until               \n\r");
  cprintf("   the edited string is considered             \n\r");
  cprintf("   valid.                                      \n\r");
  cprintf("                                               \n\r");
  cprintf("   Leave the panel by pressing 'F10' or 'ESC'. \n\r");
  cprintf("   'ESC' will exit the panel immediately,      \n\r");
  cprintf("   even with invalid fields.                   \n\r");
  cprintf("   See for yourself!                           \n\r");
  cprintf("                                               \n\r");
  cprintf("                Hit any key to continue. ");
  cskey();
  w2.remove();
  w1.clear();


/////////////////////// Variables for the panel ///////////////////

  char str[]="Some string.";
  char ch='c';
  int  in=123;
  long lo=1234567890;
  float fl=3.14159265358;
  double df=1.1;
  DATE date="22/03/1930";



///////////////////////// PANEL DEFINITION /////////////////////


  panel.set_dim(-1,-1,21,75);
  panel.head(" Data Validation  ");
  panel.border(BORDER_DOUBLE);
  panel.activate();

  gotoyx(1,40); cprintf(" Min        Max        Picture");
  gotoyx(2,40); cprintf("                     String");
  gotoyx(3,40); cprintf("                             ");

  gotoyx(4,10); cprintf("String: ");
  panel.add_field(4,20,15,str);
  panel.mod_field.set_max("zyx");
  panel.mod_field.set_min("Aaa");
  gotoyx(4,40); cprintf("'AAA' < X < 'zyx'");



  gotoyx(6,10); cprintf("Character: ");
  panel.add_field(6,20,1,ch);
  panel.mod_field.set_max('z');
  panel.mod_field.set_min('a');
  gotoyx(6,40); cprintf("  'a' < X < 'z'");


  gotoyx(8,10); cprintf("Integer: ");
  panel.add_field(8,20,9,in);
  panel.mod_field.picture("ooo");
  panel.mod_field.set_max(399);
  panel.mod_field.set_min(100);
  gotoyx(8,40); cprintf("  100 < X < 399          ooo");



  gotoyx(10,10); cprintf("Long: ");
  panel.add_field(10,20,18,lo);
  panel.mod_field.set_min(10L);
  gotoyx(10,40); cprintf("   10 < X");



  gotoyx(12,10); cprintf("Float: ");
  panel.add_field(12,20,15,fl);
  panel.mod_field.set_max(9e10);
  panel.mod_field.set_min(1e-10);
  gotoyx(12,40); cprintf("1e-10 < X < 9e10");



  gotoyx(14,10); cprintf("Double: ");
  panel.add_field(14,20,25,df);
  panel.mod_field.set_max(1e6);
  panel.mod_field.picture("o.oo[0|e|E]o");
  gotoyx(14,40); cprintf("        X < 1e6     o.oo[0|e|E]o");


  gotoyx(16,10); cprintf("Date: ");
  panel.add_field(16,20,date);

  DATE dm="31/12/1999";
  DATE di="01/01/1900";
  panel.mod_field.set_max(dm);
  panel.mod_field.set_min(di);
  gotoyx(16,35); cprintf("01/01/1900 < X < 31/12/1999" );
  gotoyx(19,25); cprintf("Exit with ESC or F10");


  panel.exit_key(F10);


/////////////////////// Browse through it //////////////////////////////

  panel.read();

/////////////////////// removing panel /////////////////////////////////


  panel.remove();
  pan1.remove();


}
