// System  : CSH 1.00 - Color Syntax Highlighter
// File    : TCSHTEXT.H
// Author  : Eric Woodruff,  CIS ID: 72134,1150
// Updated : Wed 08/02/95 21:57:57
// Note    : Copyright 1995, Eric Woodruff, All rights reserved
// Compiler: Borland C++ 3.1 to 4.xx
//
// This file contains the class declaration for the static text class
// that uses a color syntax highlighter.
//

#if !defined(__FLAT__)

#if !defined(_NEAR)
#define _NEAR   near
#endif

#if !defined(_FAR)
#define _FAR    far
#endif

#endif

class _FAR TRect;
class _FAR TStaticText;
class _FAR ColorSyntaxHighlighter;

class TCSHText : public TStaticText
{
private:
    ColorSyntaxHighlighter *csh;

public:
    TCSHText(const TRect &bounds, const char *aText);

    virtual void draw();

// This stuff makes it streamable.
private:
    virtual const char *streamableName() const
	    { return name; }

protected:
    TCSHText( StreamableInit ) : TStaticText( streamableInit ) {}

public:
    static const char * const _NEAR name;
    static TStreamable *build();

protected:
    virtual void *read( ipstream& );
};

inline ipstream& operator >> ( ipstream& is, TCSHText& cl )
    { return is >> (TStreamable&)cl; }
inline ipstream& operator >> ( ipstream& is, TCSHText*& cl )
    { return is >> (void *&)cl; }

inline opstream& operator << ( opstream& os, TCSHText& cl )
    { return os << (TStreamable&)cl; }
inline opstream& operator << ( opstream& os, TCSHText* cl )
    { return os << (TStreamable *)cl; }
