// File    : CSHDEMO2.CPP
// Author  : Eric Woodruff,  CIS ID: 72134,1150
// Updated : Wed 08/02/95 21:57:57
// Note    : Copyright 1995, Eric Woodruff, All rights reserved
// Compiler: Borland C++ 3.1 to 4.xx
//
// More functions for the CSH demo program.
//

#include <ctype.h>
#include <dir.h>
#include <io.h>
#include <stdarg.h>
#include <string.h>

#define Uses_MsgBox
#define Uses_TApplication
#define Uses_TButton
#define Uses_TColorDialog
#define Uses_TColorGroup
#define Uses_TColorItem
#define Uses_TDeskTop
#define Uses_TFileDialog
#define Uses_TKeys
#define Uses_TMenuBar
#define Uses_TProgram
#define Uses_TResourceFile
#define Uses_TScreen
#define Uses_TStaticText
#define Uses_TStatusLine
#define Uses_TVCOLR             // Use this if you modified the TV.H file.
#define Uses_fpstream
#include <tv.h>

#if !defined(cpDefSize)
// Use this if you chose not to modify the Turbo Vision files.
#include <tvcolr.h>
#endif

#include <csh.h>
#include <tcshtext.h>

#define Uses_TCSHApp
#include "cshdemo.h"

extern TPoint shadowSize;   // Altered when screen size changes.

extern TResourceFile *rsc;
extern char demo_cfg[MAXPATH];
extern short CmdLinePalette;

// ****************************************************************************
// More standard front end functions.  Modify as needed.

//
// Desktop initialization.
//
TDeskTop *TCSHApp::initDeskTop(TRect r)
{
    // Prevent drawing the desktop until the colors are set correctly.
    TProgram::application->setState(sfExposed, False);

    r.a.y++;
    r.b.y--;
    return new TDeskTop(r);
}

//
// Screen initialization.  This is overridden so that a command line
// specified color palette can be used.  If not, the default initScreen()
// will reset the palette based on monitor type every time it is called.
//
void TCSHApp::initScreen()
{
    TProgram::initScreen();

    // Force palette to equal the user-specified palette.
    if(CmdLinePalette > -1 && TApplication::appPalette != CmdLinePalette)
    {
        TApplication::appPalette = CmdLinePalette;

        // If monochrome, turn off shadows and turn on markers.
        if(CmdLinePalette == apMonochrome)
        {
            shadowSize.x = 0;
            shadowSize.y = 0;
            showMarkers = True;
        }
    }
}

//
// Menubar initialization.
//
TMenuBar *TCSHApp::initMenuBar(TRect)
{
    TMenuBar *menuBar = (TMenuBar *)rsc->get("MenuBar");

    // Set menubar width in case the application starts up in anything other
    // than a screen mode of 80x25 lines.
    menuBar->size.x = TScreen::screenWidth;

    return menuBar;
}

//
// Create statusline.
//
TStatusLine *TCSHApp::initStatusLine( TRect )
{
    TStatusLine *statLine = (TStatusLine *)rsc->get("StatusLine");

    // Set status line width and position in case the application starts up
    // in anything other than a screen mode of 80x25 lines.
    statLine->origin.y = TScreen::screenHeight - 1;
    statLine->size.x = TScreen::screenWidth;

    return statLine;
}

// Standard Out Of Memory error dialog.
void TCSHApp::outOfMemory(void)
{
    messageBox("Not enough memory for this operation.", mfError | mfCancelButton);
}

//
// Standard load config file.  Modify as needed.
//
void TCSHApp::loadConfig(Boolean UseFileSetting)
{
    fpstream *f = new fpstream(demo_cfg, ios::in | ios::nocreate | ios::binary);

    if(!f->good())
    {
        //  Turn on the screen?
        if(!(state & sfExposed))
        {
            setScreenMode(TScreen::screenMode);

#if _TV_VERSION == 0x0103       // Fixed in TV 2.0.
            if(TMouse::present())       // Adjust mouse limits if present.
                TMouse::setRange(TScreen::screenWidth - 1,
                    TScreen::screenHeight - 1);
#endif
        }

        messageBox(mfError | mfCancelButton,
            "Could not open configuration file: %s", demo_cfg);

        delete f;
        return;
    }

    ipstream &strm = *f;

    // Read palettes from the configuration file.
    short curr_palette = appPalette;
    for(short i = 0; i < apTotalPalettes; i++)
    {
        appPalette = i;
        TPalette *palette = &getPalette();
        strm.readBytes(palette->data, palette->data[0] + 1);
    }
    appPalette = curr_palette;

    // Get the video mode
    ushort scrMode;
    strm.readBytes(&scrMode, sizeof(scrMode));

    // Get the palette that was in use.
    short usePalette;
    strm.readBytes(&usePalette, sizeof(usePalette));

    // If not overridden from the command line, set the palette.
    if(CmdLinePalette == -1 || (CmdLinePalette != -1 && UseFileSetting))
        CmdLinePalette = usePalette;

    setScreenMode(scrMode);

#if _TV_VERSION == 0x0103   // Fixed in TV 2.0.
    if(TMouse::present())       // Adjust mouse limits if present.
        TMouse::setRange(TScreen::screenWidth - 1, TScreen::screenHeight - 1);
#endif

    // ************************************************************************
    // Add code here to load non-standard application-specific config data.

    delete f;
}

//
// Standard save config file.  Modify as needed.
//
void TCSHApp::saveConfig(void)
{
    fpstream *f = new fpstream(demo_cfg, ios::trunc | ios::binary);

    if(!f->good())
    {
        messageBox(mfError | mfCancelButton,
            "Could not open configuration file: %s", demo_cfg);

        delete f;
        return;
    }

    opstream &strm = *f;

    // Store the palettes
    short curr_palette = appPalette;
    for(short i = 0; i < apTotalPalettes; i++)
    {
        appPalette = i;
        TPalette *palette = &getPalette();
        strm.writeBytes(palette->data, palette->data[0] + 1);
    }
    appPalette = curr_palette;

    // Store current video mode
    strm.writeBytes(&TScreen::screenMode, sizeof(TScreen::screenMode));

    // Store current palette in use.
    strm.writeBytes(&appPalette, sizeof(appPalette));

    // ************************************************************************
    // Add code here to save non-standard application-specific config data.

    delete f;
}

// ****************************************************************************
// More functions not in the standard front end.

// This is a simple test of the TCSHText object.  An example of
// streaming TCSHText can be found in BLDRSC.CPP.
void TCSHApp::textDemo(void)
{
    TDialog *dlg = new TDialog(TRect(0, 0, 55, 8),
        "CSH Static Text");

    dlg->options |= ofCentered;

    dlg->insert(new TCSHText(TRect(2, 2, 53, 3),
        "NOTE: *This is a \"test\" (Color Syntax Highlighter)*"));

    dlg->insert(new TButton(TRect(22, 5, 32, 7), "O~K~", cmOK, bfDefault));

    executeDialog(dlg, NULL);
}

// ****************************************************************************
// This is for the Color Syntax Highlighter.  It allows you to alter the
// colors for the topmost view that is using CSH (if there is one).

void TCSHApp::setCSHColors(void)
{
    char colors[csMaxGroups];
    char *colorPalette[] = { "Color", "Black & White", "Monochrome",
        "Alt. Color" };

    // There's nobody to work with.
    if(!message(deskTop, evBroadcast, cmCSHGetColors, colors))
        return;

    TColorGroup &group1 =
        *new TColorGroup(colorPalette[appPalette]) +
            *new TColorItem("Group A",        1)+
            *new TColorItem("Group B",        2)+
            *new TColorItem("Group C",        3)+
            *new TColorItem("Group D",        4)+
            *new TColorItem("Group E",        5)+
            *new TColorItem("Group F",        6)+
            *new TColorItem("Group G",        7)+
            *new TColorItem("Group H",        8)+
            *new TColorItem("Group I",        9)+
            *new TColorItem("Group J",       10)+
            *new TColorItem("Group K",       11)+
            *new TColorItem("Group L",       12)+
            *new TColorItem("Group M",       13)+
            *new TColorItem("Group N",       14)+
            *new TColorItem("Group O",       15)+
            *new TColorItem("Group P",       16);

    TPalette *pal = new TPalette(colors, csMaxGroups);

    TColorDialog *c = new TColorDialog(pal, &group1);

    if(validView(c))
    {
        // Execute the color dialog box.
        if(deskTop->execView(c) != cmCancel)
        {
            *pal = *(c->pal);

            memcpy(colors, &pal->data[1], csMaxGroups);
            message(deskTop, evBroadcast, cmCSHSetColors, colors);

            // Repaint the entire desktop by calling
            // setScreenMode().  Calling deskTop->setState()
            // to set sfVisible off and then on as in TVDEMO
            // doesn't always redraw the entire screen if
            // there is a window or some other view on the
            // desktop that has the focus.
            setScreenMode(TScreen::screenMode);

            // If allowed, save the colors to the defaults file for
            // permanent use.
            if(messageBox("Save color set to defaults file?",
              mfConfirmation | mfYesNoCancel) == cmYes)
                message(deskTop, evBroadcast, cmCSHSaveColors, NULL);
        }
        destroy(c);
    }
    delete pal;
}
