// File    : CSHDEMO1.CPP
// Author  : Eric Woodruff,  CIS ID: 72134,1150
// Updated : Wed 08/02/95 21:57:57
// Note    : Copyright 1995, Eric Woodruff, All rights reserved
// Compiler: Borland C++ 3.1 to 4.xx
//
// This program demonstrates the Color Syntax Highlighter classes.
// Included is my standard front end.  It will also serve as a fairly good
// tutorial on selecting color palettes from the command line as well as
// saving and restoring colors to a configuration file.  This same front
// end and all references to TVCOLR.H, TVCOLR.DOC, and COLUPDT.DOC can be
// found in TVCOLR.ZIP also in BCPPDOS library 11 on CompuServe.  It is *not*
// required that you have it for TVMEditor use though.  It simply describes
// a method of extending the Turbo Vision color palettes.
//
// You may use any of the following command line parameters:
//
//     /MC | /MB | /MM | /MA    -  Select color, black & white, monochrome,
//                                 or alternate color palette.  If not
//                                 specified, it defaults to the palette
//                                 best suited for the monitor in use.
//
//     /Cdr:\path\filename.ext  -  Specify different default config filename.
//
//     /Rdr:\path\filename.ext  -  Specify different resource filename.
//
//     dr:\path\filename.ext    -  Load file into an editor from command line.
//
// This program uses a resource file for some of the objects like the menu
// bar, status line, color dialog box, etc.  If you use this code elsewhere
// without a resource file, you can generally replace the rsc->get() calls
// with calls to the functions from BLDRSC.CPP that create the objects.  Just
// include those functions in here or in a separate module and remove all
// references to the resource file.
//

// Uncomment the following line to allow searching the the end of the
// executable for the resource file.
//
// NOTE: The resource file cannot be appended to the executable if the
//       application is compiled to run under protected mode.  It won't let
//       you access it (sort of like the problem when including debug info).
//#define FINAL

#include <conio.h>
#include <ctype.h>
#include <dir.h>
#include <dos.h>
#include <float.h>
#include <io.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

extern unsigned _stklen = 10240U;       // Increase stack size to 10K.

#define Uses_MsgBox
#define Uses_TApplication
#define Uses_TColorDialog
#define Uses_TChDirDialog
#define Uses_TDeskTop
#define Uses_TDialog
#define Uses_TEvent
#define Uses_TFileDialog
#define Uses_TKeys
#define Uses_TMenuBar
#define Uses_TMenuItem
#define Uses_TPalette
#define Uses_TResourceFile
#define Uses_TScreen
#define Uses_TScrollBar
#define Uses_TScroller
#define Uses_TStatusDef
#define Uses_TStatusItem
#define Uses_TStatusLine
#define Uses_TStreamableClass
#define Uses_TSubMenu
#define Uses_TWindow
#define Uses_TVCOLR             // Use this if you modified the TV.H file.
#define Uses_fpstream
#include <tv.h>

#if !defined(cpDefSize)
// Use this if you chose not to modify the Turbo Vision files.
#include <tvcolr.h>
#endif

// ****************************************************************************
// Headers not in the standard front end file.

#include <csh.h>
#include <ttxtview.h>

#ifdef INCLUDE_HEAPVIEW
#include <heapview.h>
#endif

#define Uses_TCSHApp
#include "cshdemo.h"             // Demo program header file.

// ****************************************************************************

#include "link.h"              // Resource file link definitions.

//extern int    _Cdecl _argc;  // Global pointers to the command line args.
//extern char **_Cdecl _argv;  // This way the app's constructor can access
                               // them.  Declarations are in DOS.H too.

char demo_cfg[MAXPATH],     // Configuration filename.
     demo_rsc[MAXPATH],     // Resource filename.
     demo_csh[MAXPATH];     // Default location of the CSH data file.

// Resource file pointers.
fpstream *s;
TResourceFile *rsc = NULL;  // NULL to start with.

// The value of this variable determines what is printed when the program
// exits back to DOS.
short ExitValue = EXIT_NOERR;

// Monitor type palette index as set from the command line (/MC | /MB | /MM |
// /MA).  Default it is -1 to let the application use the default palette
// selected by TProgram::initScreen().
short CmdLinePalette = -1;

// Global pointer to the user screen buffer for the User Screen event.
char *ScrBuf = NULL;

// ****************************************************************************
// Global variables not in the standard front end file.

// Indent for new editor windows.
short winIndent = 0;

//*****************************************************************************
// Standard functions.  Modify as needed.

void exitfunc(void)
{
#if _TV_VERSION != 0x0103
    // Prevent the screen from being cleared on exit.
    TScreen::clearOnSuspend = False;
#endif

    switch(ExitValue)
    {
        case EXIT_NOERR:
            cout << endl << "Thank you for using this demo program." << endl;
            break;

        case EXIT_RSCERR:
            cout << "Could not locate or open resource file: " <<
                demo_rsc << endl;
            break;

        case EXIT_SWERR:
            cout << "Bad parameter: " << _argv[_argc] << endl << endl;
            // Fall through and display command line syntax.

        case EXIT_SYNTAX:
            cout << "Command line syntax:" << endl << _argv[0] << endl <<
                " [/MC | /MB | /MM | /MA] [/Rrsc_file.ext] [/Ccfg_file.ext]" <<
                endl << " [dr:\\path\\filespec(s)...]" << endl;
            break;
    }
}

#if _TV_VERSION == 0x0103
// Tell the exit code to call the display function just prior to quiting.
#pragma exit exitfunc 31
#endif

//
// This will kick everything off.  Note that no argc, or argv parameters are
// used.  The global _argc and _argv variables are used instead so that we
// don't have to pass them to the constructor.  You don't need to do things
// this way, it's just one alternative.
//
void main(void)
{
    short index = 1;

#if _TV_VERSION != 0x0103
    // Prevent the screen from being cleared on exit until we've had a
    // chance to check things out.
    TScreen::clearOnSuspend = False;

    // Register the exit function so that the exit messages are still
    // displayed.
    atexit(exitfunc);
#endif

    // To begin with, assume that the resource file is appended to the
    // executable.  If it isn't, we'll try a different approach.
    // To append the resource file to the executable you would issue the
    // command:
    //          COPY /B filename1.EXE+filename.RSC filename2.EXE
    //
    // Make sure the destination .EXE name is not the same as the source
    // .EXE name or you will overwrite the source .EXE file.
    // Also note that the source .EXE can't have debug info at the end of it.
    //
    strcpy(demo_rsc, _argv[0]);

// Until the final production version, don't bother trying to access the
// executable.  Debugging from within the IDE will cause a general access
// failure on the drive when it tries to open it.  TResourceFile won't
// read past the debug info at the end of the executable anyway so use a
// separate resource file until debugging is all done.
#ifndef FINAL
    strcpy(strrchr(demo_rsc, '.') + 1, "RSC");
#endif

    // Modify executable name to get location and name of the default
    // configuration file.  We'll assume the config file (if any) is in the
    // same directory as the executable and has the same name with a .CFG
    // extension.  It can be changed with a /C command line switch to
    // specify a different path to it or a different name.

    strcpy(demo_cfg, _argv[0]);
    strcpy(strrchr(demo_cfg, '.') + 1, "CFG");

    // Look for command line switches affecting configuration and resource
    // files.  A check for a user requested palette is also included here.
    // That way everything will come up in the proper colors when
    // setScreenMode() is called in the application's constructor or in
    // the loadConfig() function.
    //
    // I've found it best to scan for and process these items here because
    // I do have some cases where the command line arguments are processed
    // in the application's constructor to insert some default objects into
    // the desktop such as file or directory viewers, editor windows, etc
    // specified with other command line switches.  If there is an error
    // doing one of them, you need the screen active so that you can see
    // the error message box.  Also, you don't have to do anything special
    // in the application's constructor to switch palettes if one of these
    // is found.
    //
    while(index != _argc)
    {
        // Allow -opt or /opt.
        if(_argv[index][0] == '/' || _argv[index][0] == '-')
            switch(toupper(_argv[index][1]))
            {
                case 'M':       // Change the default palette.
                    switch(toupper(_argv[index][2]))
                    {
                        case 'C':
                            CmdLinePalette = apColor;
                            break;

                        case 'B':
                            CmdLinePalette = apBlackWhite;
                            break;

                        case 'M':
                            CmdLinePalette = apMonochrome;
                            break;

                        case 'A':
                            CmdLinePalette = apAltColor;
                            break;

                        default:
                            ExitValue = EXIT_SWERR;  // Signal bad switch value.
                            _argc = index;
                            exit(EXIT_SWERR);
                    }
                    break;

                case 'C':           // Use a different configuration filename.
                    strcpy(demo_cfg, &_argv[index][2]);
                    break;

                case 'R':           // Use a different resource filename.
                    strcpy(demo_rsc, &_argv[index][2]);
                    break;

                case '?':
                    ExitValue = EXIT_SYNTAX;    // Display command syntax.
                    exit(EXIT_SYNTAX);

//                case 'X':         // Ignore other valid switches that
//                case 'Y':         // will be processed in the application's
//                case 'Z':         // constructor.
//                    break;

                default:
                    ExitValue = EXIT_SWERR;  // Signal bad switch value.
                    _argc = index;
                    exit(EXIT_SWERR);
            }

        index++;
    }

    // Now try to open the resource file and use it.
    s = new fpstream(demo_rsc, ios::in | ios::nocreate | ios::binary);
    if(s->good())
    {
        rsc = (TResourceFile *)new TResourceFile(s);

        if(!rsc->count())
        {
            TObject::destroy(rsc);      // No resource file in the EXE or
            rsc = NULL;                 // user supplied filename.
        }
    }
    else
        delete s;

    if(!rsc)
    {
        // As long as a /R switch wasn't specified, modify the executable name
        // to get the location and name of the default resource file.
        // We'll assume the resource file is in the same directory as the
        // executable and has the same name with a .RSC extension.  It can be
        // changed with a /R command line switch to specify a different path
        // to it or a different name.  If that is the case, it wasn't
        // accessible.
        if(!strnicmp(_argv[0], demo_rsc, strlen(_argv[0]) - 3))
        {
            strcpy(strrchr(demo_rsc, '.') + 1, "RSC");
            s = new fpstream(demo_rsc, ios::in | ios::nocreate | ios::binary);

            if(!s->good())
                ExitValue = EXIT_RSCERR;      // Still not accessible.
            else
            {
                rsc = (TResourceFile *)new TResourceFile(s);
                if(!rsc->count())
                {
                    TObject::destroy(rsc);      // Not a valid resource file.
                    ExitValue = EXIT_RSCERR;
                }
            }
        }
        else
            ExitValue = EXIT_RSCERR;   // User specified file isn't accessible.

        if(ExitValue)
            exit(EXIT_RSCERR);
    }

#if _TV_VERSION != 0x0103
    // Now it's okay to clear the screen upon exit.
    TScreen::clearOnSuspend = True;
#endif

    // Set the location of the default CSH data set file.
    strcpy(demo_csh, _argv[0]);
    strcpy(strrchr(demo_csh, '\\') + 1, "CSHDEFLT.DTA");

    TTextFileViewer::CSHDataSetName = demo_csh;

    // Application Instance.  Change class name of application as needed.
    TCSHApp Demo;
    Demo.run();

    // Shutdown the app and close the resource file.
    Demo.shutDown();
    TObject::destroy(rsc);

    if(ScrBuf)
        delete [] ScrBuf;     // Delete User Screen buffer if used.

#if _TV_VERSION != 0x0103
    // Be neat and get rid of the desktop display so that the exit message
    // can be seen clearly.
    Demo.suspend();
#endif

    exit(EXIT_NOERR);
}

// ****************************************************************************
// Standard front end functions follow, modify as needed.

//
// Constructor for the application.
//
TCSHApp::TCSHApp(void) :
  TProgInit( &TCSHApp::initStatusLine, &TCSHApp::initMenuBar,
    &TCSHApp::initDeskTop )
{
    TRect  r;
    TEvent event;
    short  index = 1,
           Ignored = 0;        // Count of ignored command line parameters.

#if _TV_VERSION == 0x0103
    // This line insures snow checking is off to speed up the display.
    // It can be removed if you've modified TSCREEN.CPP or are using TV 2.0.
    TScreen::checkSnow = False;
#endif

#ifdef INCLUDE_HEAPVIEW
    // Create the heap view (optional).
    r = getExtent();
    r.a.x = r.b.x - 22;
    r.b.y = r.a.y + 1;
    heap = new THeapView( r );
    insert(heap);
#endif
    // **********************************************************************
    // Application-specific setup code.

    // **********************************************************************
    // All the default objects and views have been constructed, now we
    // can do some stuff with the desktop.

    // If there is a configuration file, read in the data now.
    // Then, here or in loadConfig, turn on the screen and redraw it.
    // If it is done earlier than this, the proper colors won't be used
    // for the initial screen when an alternate palette is specified.
    if(!access(demo_cfg, 0))
        loadConfig(False);
    else
    {
        setScreenMode(TScreen::screenMode);

#if _TV_VERSION == 0x0103       // Fixed in TV 2.0
        if(TMouse::present())       // Adjust mouse limits if present.
            TMouse::setRange(TScreen::screenWidth - 1,
                TScreen::screenHeight - 1);
#endif
    }

    // **********************************************************************

    // Process any other command line arguments now.
    // Don't forget to ignore any of the one's parsed in main().
    while(index != _argc)
    {
        if(_argv[index][0] == '/' || _argv[index][0] == '-')
        {
            switch(toupper(_argv[index][1]))
            {
//                case 'X':
//                case 'Y':
//                case 'Z':
//                    do something
//                    break;

                case 'C':                  // Ignore config file selection
                case 'R':                  // Ignore resource file selection
                case 'M':                  // Ignore palette selection
                    Ignored++;             // They're already taken care of.
                    break;

                default:
                    Ignored++;
                    messageBox(mfError | mfOKButton,
                        "Invalid command line switch: %s", _argv[index]);
                    break;
            }
        }
        else  // If not a switch, default to doing something else with it.
        {
//            // Ignored by default.
//            Ignored++;
//            messageBox(mfError | mfOKButton,
//                "Invalid command line parameter: %s", _argv[index]);

            // For the editor demo, assume it is a valid filename or wildcard.
            openViewer(_argv[index], True);
        }

//      Processing to be done after each switch command (if any).
//      Insert other default views, etc.

        index++;
    }

    // Display the About Box if no command line parameters are passed
    // or only /Mx, /C, or /R parameters were used.
    if(_argc < 2 || (_argc - Ignored) < 2)
    {
        event.what = evCommand;
        event.message.command = cmAbout;
        putEvent(event);
    }
}

// This is where the palettes for the application are defined.
TPalette &TCSHApp::getPalette() const
{
    // The Color and Alternate Color attribute maps are swapped in these
    // definitions so that my color preferences are used by default for
    // color monitors.

    static TPalette color( cpExtAltColor, sizeof( cpExtAltColor)-1 );
    static TPalette blackwhite( cpExtBlackWhite, sizeof( cpExtBlackWhite)-1 );
    static TPalette monochrome( cpExtMonochrome, sizeof( cpExtMonochrome)-1 );
    static TPalette altcolor( cpExtColor, sizeof( cpExtColor)-1 );

    static TPalette *palettes[] =
    {
        &color,
        &blackwhite,
        &monochrome,
        &altcolor        // Additional palettes must come after standard ones
                         // in this array.
    };
    return *(palettes[appPalette]);
}

//
// Application idle function.  Modify or remark out as required.
//
void TCSHApp::idle(void)
{
    TProgram::idle();

#ifdef INCLUDE_HEAPVIEW
    heap->update();
#endif

    // Turn off Tile and Cascade if other window commands are disabled.
    if(!commandEnabled(cmPrev))
    {
        disableCommand(cmCloseAll);
        disableCommand(cmTile);
        disableCommand(cmCascade);
    }
    else
    {
        enableCommand(cmCloseAll);
        enableCommand(cmTile);
        enableCommand(cmCascade);
    }

    // Select the menu bar if the desktop is empty.
    if(!deskTop->current && !menuBar->getState(sfSelected))
    {
        TEvent event;
        event.what = evCommand;
        event.message.command = cmMenu;
        putEvent(event);
    }
}

//
//  Event handler to distribute the work.
//
void TCSHApp::handleEvent(TEvent &event)
{
    TColorDialog *c;

    TApplication::handleEvent(event);

    if(event.what == evCommand)
    {
        switch(event.message.command)
        {
    // Standard front end evCommand events.

            case cmAbout:               //  About Dialog Box
                executeDialog((TDialog *)rsc->get("AboutBox"), NULL);
                break;

            case cmRepaint:
                setScreenMode(TScreen::screenMode);
                break;

            case cmDosShell:
                suspend();          // Suspend Turbo Vision and shell to DOS.
                cout << endl << "Type EXIT to return..." << endl;
                system(getenv("COMSPEC"));
                _fpreset();         // Reset math co-processor.

                if(!ScrBuf)
                    ScrBuf = new char[4100];    // At least 4000 bytes.

                gettext(1, 1, 80, 25, ScrBuf);  // Get screen image.

                resume();       // Restart Turbo Vision.
                redraw();
                break;

            case cmTile:                //  Tile current windows
                deskTop->tile(deskTop->getExtent());
                break;

            case cmCascade:             //  Cascade current windows
                deskTop->cascade(deskTop->getExtent());
                break;

            case cmCloseAll:    // Close all views that have ofTileable set.
                TView *vw;
                while((vw = deskTop->firstThat(isTileable, 0)) != NULL)
                    message(vw, evCommand, cmClose, NULL);
                break;

            case cmScreenSize:          // Change screen size.
                // If already in 43/50 line mode, return to the startup mode.
                if(TScreen::screenMode == (TDisplay::smCO80 | TDisplay::smFont8x8))
                    setScreenMode(TScreen::startupMode);
                else
                    setScreenMode(TDisplay::smCO80 | TDisplay::smFont8x8);

#if _TV_VERSION == 0x0103
                // Adjust mouse limits if present.  (Fixed in TV 2.0)
                if(TMouse::present())
                    TMouse::setRange(TScreen::screenWidth - 1,
                        TScreen::screenHeight - 1);
#endif
                break;

            case cmUserScreen:
                suspend();      // Suspend Turbo Vision and display user
                if(ScrBuf)      // screen if there is one.
                    puttext(1, 1, 80, 25, ScrBuf);

                getch();        // Wait for keypress and restart Turbo Vision.
                resume();
                redraw();
                break;

            case cmColors:
                c = (TColorDialog *)rsc->get("ColorDlg");

                if(validView(c))
                {

#if _TV_VERSION == 0x0103

//* TV 1.03 NOTE: I have found that this is the *proper* way to set up *all*
//* TColorDialog boxes.  If you follow the TVDEMO example, you pass
//* TColorDialog a NULL pointer in its constructor (the palette pointer is
//* also NULL after you restore it from a resource file!).
//* You then call its setData() member to initialize the color set.  The
//* problem is that TColorDialog::setData() does a memcpy() using that NULL
//* pointer.  If you trace into the assembler code at that point, you'll see
//* that it takes the address stored in interrupt zero (the Divide by Zero
//* handler) and copies the palette to that address.  Most of the time you
//* don't know anything is wrong, but I have found cases where it crashes
//* immediately or at some point shortly after that.  Even if it doesn't
//* crash, you are still asking for trouble.  The method below is the only
//* way to get a TColorDialog box to work safely and properly when created
//* at runtime or stored in a resource file.

                    TPalette x = getPalette();      // Create temporary
                    c->pal = &x;                    // palette and assign it.

// TV 2.0 NOTE: In TV 2.0, this has been fixed.  The above two lines
//              should not be used or a crash will result.
#endif

                    c->setData(&getPalette());      // Call setData() with
                                                    // the initial colors.
                    // Execute the color dialog box.
                    if(deskTop->execView(c) != cmCancel)
                    {
                        // Do a straight assignment to get the modified colors.
                        getPalette() = *(c->pal);

                        // Repaint the entire desktop by calling
                        // setScreenMode().  Calling deskTop->setState()
                        // to set sfVisible off and then on as in TVDEMO
                        // doesn't always redraw the entire screen if
                        // there is a window or some other view on the
                        // desktop that has the focus.
                        setScreenMode(TScreen::screenMode);
                    }
                    destroy(c);
                }
                break;

            case cmChangePalettes:
                CmdLinePalette = appPalette + 1;

                if(CmdLinePalette == apTotalPalettes)
                    CmdLinePalette = apColor;

                setScreenMode(TScreen::screenMode);
                break;

            case cmLoadCfg:
                if(executeDialog(new TFileDialog(demo_cfg, "Load Configuration",
                  "~N~ame", fdOpenButton, 100), demo_cfg) != cmCancel)
                    loadConfig(True);
                break;

            case cmSaveCfg:
                if(executeDialog(new TFileDialog(demo_cfg, "Save Configuration",
                  "~N~ame", fdOKButton, 100), demo_cfg) != cmCancel)
                    saveConfig();
                break;

    // Non-standard evCommand events.

            case cmOpen:
                openViewer("*.*", True);
                break;

            case cmChDir:
                executeDialog(new TChDirDialog( cdNormal, 0 ), 0);
                break;

            case cmCSHColors:
                setCSHColors();
                break;

            case cmTextDemo:
                textDemo();
                break;

            default:
                return;
        }
        clearEvent (event);
    }
}

// ****************************************************************************
//
// The isTileable() function checks for a visible, tileable view on the
// desktop.
//
Boolean isTileable(TView *p, void *)
{
    // Must ignore such objects as the clipboard when they are hidden!
    if(!(p->options & ofTileable) || !(p->state & sfVisible))
        return False;

    return True;
}

// ****************************************************************************
// **** In TV 2.0, TProgram::executeDialog() replaces this.
// ****
#if _TV_VERSION == 0x0103

// This function executes any dialog passed to it and destroys it when done.
ushort executeDialog(TDialog *d, void *data)
{
    TView *p = TProgram::application->validView(d);
    if(!p)
        return cmCancel;

    if(data)
        p->setData(data);

    ushort result = TProgram::deskTop->execView(p);

    if(result != cmCancel && data)
        p->getData(data);

    TObject::destroy(p);
    return result;
}

#endif
// ****************************************************************************

// ****************************************************************************
// End of standard front end functions.
// ****************************************************************************
// Other functions not in the standard front end file.

TTextViewWindow *TCSHApp::openViewer(const char *fName, Boolean visible)
{
    char fileName[MAXPATH] = "";

    ffblk finfo;

    // Make a copy of the filename.
    if(fName)
        strcpy(fileName, fName);

    // When not opening an untitled file, check for a directory name or
    // wildcards.
    if(fileName[0])
    {
        finfo.ff_attrib = 0;
        findfirst(fileName, &finfo, FA_NORMAL | FA_HIDDEN | FA_SYSTEM |
            FA_RDONLY | FA_ARCH | FA_DIREC);

        // If there are no wildcard characters in the filename, see if the
        // entry is a directory or drive reference only.  If so, append a
        // default "\*.*" to it.
        if((!strchr(fileName, '*') && !strchr(fileName, '?') &&
          (finfo.ff_attrib & FA_DIREC)) ||
          (fileName[1] == ':' && !fileName[2]) ||
           fileName[strlen(fileName) - 1] == '\\')
        {
            // Strip any existing trailing backslash?
            if(fileName[strlen(fileName) - 1] == '\\')
                fileName[strlen(fileName) - 1] = EOS;

            strcat(fileName, "\\*.*");
        }

        // Wildcard?  If so, prompt for a real name.
        if(strchr(fileName, '*') || strchr(fileName, '?'))
            if(executeDialog(new TFileDialog(fileName, "Open file",
              "~N~ame", fdOpenButton, 100), fileName) == cmCancel)
                return NULL;
    }

    // Got a filename or null (untitled file), so open it.
    TRect r = deskTop->getExtent();

    // Indent each window's upper border so that the titles of all loaded
    // files stay visible.
    r.a.y += winIndent;
    if(++winIndent > 11)
        winIndent = 0;

    TTextViewWindow *p = (TTextViewWindow *)validView(new TTextViewWindow(r,
      fileName, wnNoNumber));

    if(p)
    {
        if(!visible)
            p->hide();

        deskTop->insert(p);
    }
    return p;
}

// ****************************************************************************
// End of standard front end file.
// ****************************************************************************
