// System  : CSH 1.00 - Color Syntax Highlighter
// File    : TTXTVIEW.H
// Author  : Eric Woodruff,  CIS ID: 72134,1150
// Updated : Wed 08/02/95 21:57:57
// Note    : Copyright 1995, Eric Woodruff, All rights reserved
// Compiler: Borland C++ 3.1 to 4.xx
//
// This is the header file for the simple text file viewer that uses
// a color syntax highlighter.
//

class TTextViewWindow : public TWindow
{
public:
    TTextViewWindow(const TRect &bounds, const char *aFileName, short aNumber);
};

class _FAR ColorSyntaxHighlighter;
class _FAR TNSCollection;

class TTextFileViewer : public TScroller
{
private:
    ColorSyntaxHighlighter *csh;

    TNSCollection *lines;

public:
    // Static pointer to the Color Syntax Highligher's data file.
    static const char * _NEAR CSHDataSetName;

    TTextFileViewer(const TRect& bounds, const char *aFileName,
        TScrollBar *hsb, TScrollBar *vsb);

    ~TTextFileViewer();

    virtual void handleEvent(TEvent &event);
    virtual void draw(void);
};
