// System  : CSH 1.00 - Color Syntax Highlighter
// File    : TTXTVIEW.CPP
// Author  : Eric Woodruff,  CIS ID: 72134,1150
// Updated : Wed 08/02/95 21:57:57
// Note    : Copyright 1995, Eric Woodruff, All rights reserved
// Compiler: Borland C++ 3.1 to 4.xx
//
// This file contains the code for the simple text file viewer that uses
// a color syntax highlighter.  This is not a very powerful viewer.  It
// is only intended to show how the highlighter works.
//

#include <alloc.h>
#include <io.h>
#include <stdio.h>
#include <string.h>

#define Uses_MsgBox
#define Uses_TApplication
#define Uses_TDeskTop
#define Uses_TEvent
#define Uses_TNSCollection
#define Uses_TProgram
#define Uses_TScrollBar
#define Uses_TScroller
#define Uses_TWindow
#define Uses_TVMemMgr
#include <tv.h>

#include  <csh.h>

#include <ttxtview.h>

//*****************************************************************************
// Default data set name.
const char * _NEAR TTextFileViewer::CSHDataSetName = "CSHDEFLT.DTA";

//*****************************************************************************

TTextViewWindow::TTextViewWindow(const TRect& bounds, const char *aFileName,
  short aNumber) :
    TWindow( bounds, aFileName, aNumber),
    TWindowInit( &TTextViewWindow::initFrame )
{
    options |= ofTileable;

    TScrollBar *vsb = standardScrollBar(sbVertical | sbHandleKeyboard);
    TScrollBar *hsb = standardScrollBar(sbHorizontal | sbHandleKeyboard);

    TRect r = getClipRect();
    r.grow( -1, -1 );

    insert(new TTextFileViewer(r, aFileName, hsb, vsb));
}

// ****************************************************************************

TTextFileViewer::TTextFileViewer(const TRect &bounds, const char *aFileName,
  TScrollBar *hsb, TScrollBar *vsb) :
    TScroller(bounds, hsb, vsb)
{
    FILE *fp;
    short lineCount = 0;
    char  buf[256], *p, ext[10] = "..";

    // Extract the filename extension to search for.  Search forward
    // from the last backslash in case a directory name has an extension.
    p = strrchr((char *)aFileName, '\\');
    if(!p)
        p = (char *)aFileName;

    p = strchr(p, '.');
    if(p)
    {
        strcpy(ext, p);
        strcat(ext, ".");
        strlwr(ext);
    }

    // No extension is handled by ".<>."
    if(!strcmp(ext, ".."))
        strcpy(ext, ".<>.");

    TTextFileViewer *vw = (TTextFileViewer *)message(TProgram::deskTop,
        evBroadcast, cmCSHSetLoaded, ext);

    // Did another view have this syntax set loaded?  If not, load it now.
    if(!vw)
        csh = new ColorSyntaxHighlighter(CSHDataSetName, aFileName);
    else
        csh = vw->csh;

    csh->RefCount++;        // Increase the reference count.

    lines = new TNSCollection(20,20);

    growMode = gfGrowHiX | gfGrowHiY;
    options = options | ofFramed;

    fp = fopen(aFileName, "r");
    if(fp)
    {
        // A quick check to see if there might be enough memory.
        // Slightly exaggerated, but require twice the size of the file.
        if(filelength(fileno(fp)) * 2 > farcoreleft())
        {
            messageBox("Not enough memory", mfError | mfCancelButton);
            lines->insert(newStr(""));
            lineCount++;
        }
        else
            // Nothing special, just load up as many lines as possible.
            while(!lowMemory() && !ferror(fp) && !feof(fp) && lineCount < 32000)
            {
                buf[0] = EOS;
                fgets(buf, 256, fp);

                // Strip line feed?
                if(buf[strlen(buf) - 1] == '\n')
                    buf[strlen(buf) - 1] = EOS;

                lines->insert(newStr(buf));
                lineCount++;
            }

        fclose(fp);
    }
    setLimit(256, lineCount);
}

TTextFileViewer::~TTextFileViewer()
{
    destroy(lines);

    csh->RefCount--;

    // Only delete the syntax highlighter if this was the only
    // one using it.
    if(!csh->RefCount)
        delete csh;
}

void TTextFileViewer::handleEvent(TEvent &event)
{
    TScroller::handleEvent(event);

    if(event.what == evBroadcast)
        switch(event.message.command)
        {
            case cmCSHGetColors:
                // Get the syntax highlighter's color palette
                csh->getColorPalette(TProgram::application->appPalette,
                    (char *)event.message.infoPtr);
                clearEvent(event);
                break;

            case cmCSHSetColors:
                // Set the syntax highlighter's color palette
                csh->setColorPalette(TProgram::application->appPalette,
                    (char *)event.message.infoPtr);
                clearEvent(event);
                break;

            case cmCSHSetLoaded:
                // Check the extension to see if this editor can
                // share its sytnax highlighter with another.
                if(strstr(csh->SetName, (char *)event.message.infoPtr))
                    clearEvent(event);
                break;

            case cmCSHSaveColors:
                // Save the colors to the data file for permanent use.
                csh->SaveColors(CSHDataSetName);
                clearEvent(event);
                break;
        }
}

void TTextFileViewer::draw(void)
{
    ushort buffer[256];

    // Insure that the palette is set correctly.
    if(TProgram::application->appPalette != csh->getPalette())
        csh->setPalette(TProgram::application->appPalette);

    ushort color = getColor(0x0301);
    for( short i = 0; i < size.y; i++ )
    {
        int j = delta.y + i;

        // Color in the line.
        if(j < lines->getCount())
            csh->HighlightLine((char *)lines->at(j), (uchar *)&buffer[0],
                color, 256);
        else
            csh->HighlightLine("", (uchar *)&buffer[0], color, 256);

        // Draw it.
        writeBuf(0, i, size.x, 1, &buffer[delta.x]);
    }
}
