// File    : BLDRSC.CPP
// Author  : Eric Woodruff,  CIS ID: 72134,1150
// Updated : Wed 08/02/95 21:57:57
// Note    : Copyright 1994-95, Eric Woodruff, All rights reserved
// Compiler: Borland C++ 3.1 to 4.xx
//
// This program is the resource file builder for the demo.
//

// NOTE: The 32 bit version of the resource file is *NOT* compatible with
//       the 16 bit version!  This is because 'int' values stored in it are
//       32 bits long not 16 so they no long match 'short' values which are
//       16 bits long in either version.  See HISTORY.DOC for a required fix
//       to TSTATUSL.CPP before building the 32 bit version of the resource
//       file.
//
#if defined(__DPMI16__)
    #define RSC_FILENAME    "CSHDEM16.RSC"   // File to create.
#else
    #if defined(__DPMI32__)
        #define RSC_FILENAME    "CSHDEM32.RSC"   // File to create.
    #else
        #define RSC_FILENAME    "CSHDEMO.RSC"   // File to create.
    #endif
#endif

#if _TV_VERSION == 0x0103
#define WriteResource(a,b,c) \
    cout << c << endl; \
    a = b(); \
    if( a == 0 ) \
    { \
        strcpy(endString, RSC_FILENAME ": Creation failure\n"); \
        TObject::destroy(rsc); \
        exit(1); \
    } \
    rsc->put(a,c); \
    TObject::destroy(a)

#define WriteObject(a,c) \
    cout << c << endl; \
    if(a == 0) \
    { \
        strcpy(endString, RSC_FILENAME ": Creation failure\n"); \
        TObject::destroy(rsc); \
        exit(1); \
    } \
    rsc->put(a,c); \
    TObject::destroy(a)
#else
#define WriteResource(a,b,c) \
    cout << c << endl; \
    a = b(); \
    if( a == 0 ) \
    { \
        cout << endl << RSC_FILENAME << ": Creation failure" << endl; \
        TObject::destroy(rsc); \
        exit(1); \
    } \
    rsc->put(a,c); \
    TObject::destroy(a)

#define WriteObject(a,c) \
    cout << c << endl; \
    if(a == 0) \
    { \
        cout << endl << RSC_FILENAME << ": Creation failure" << endl; \
        TObject::destroy(rsc); \
        exit(1); \
    } \
    rsc->put(a,c); \
    TObject::destroy(a)
#endif

#include <conio.h>
#include <dir.h>
#include <io.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#define Uses_TButton
#define Uses_TCheckBoxes
#define Uses_TColorDialog
#define Uses_TColorGroup
#define Uses_TColorItem
#define Uses_TDialog
#define Uses_THistory
#define Uses_TInputLine
#define Uses_TKeys
#define Uses_TLabel
#define Uses_TMenuBar
#define Uses_TMenuItem
#define Uses_TRadioButtons
#define Uses_TRect
#define Uses_TResourceFile
#define Uses_TScreen
#define Uses_TScrollBar
#define Uses_TSItem
#define Uses_TStaticText
#define Uses_TStatusDef
#define Uses_TStatusItem
#define Uses_TStatusLine
#define Uses_TStreamableClass
#define Uses_TSubMenu
#define Uses_TVCOLR             // Use this if you modified the TV.H file.
#define Uses_fpstream
#include <tv.h>

#if !defined(cpDefSize)
// Use this if you chose not to modify the Turbo Vision files.
#include <tvcolr.h>
#endif

#include <csh.h>
#include <tcshtext.h>

#include "link.h"           // Resource file link definitions
#include "cshdemo.h"        // Demo header file

// ============================================================================
TDialog *Colors(void);
TDialog *AboutBox(void);

TMenuBar *initMenuBar(void);
TStatusLine *initStatusLine(void);

// ============================================================================

fpstream *s;
TResourceFile* rsc;

// ============================================================================

// The exit function is no longer needed in the TV 2.0 version due to
// the new TScreen::clearOnSuspend data member.
#if _TV_VERSION == 0x0103

char endString[255] = "";

void exitfunc(void)
{
   cout << endl << endString << endl;
}

#pragma exit exitfunc 31

#endif

void main(void)
{
    TDialog *dlg;
    TMenuBar *menuBar;
    TStatusLine *statusLine;

#if _TV_VERSION != 0x0103
    // Prevent the screen from being cleared on exit.
    TScreen::clearOnSuspend = False;
#endif

    cout << "Creating " RSC_FILENAME << endl;

    // Construct stream and resource file.
    s = new fpstream (RSC_FILENAME, ios::trunc | ios::binary);
    rsc = new TResourceFile(s);

    // Create all of the necessary dialogs for the demo.
    WriteResource(dlg, AboutBox, "AboutBox");
    WriteResource(dlg, Colors, "ColorDlg");

    // Create the menus and status line.
    WriteResource(menuBar, initMenuBar, "MenuBar");
    WriteResource(statusLine, initStatusLine, "StatusLine");

    TObject::destroy(rsc);

#if _TV_VERSION == 0x0103
    strcpy(endString, RSC_FILENAME ": Creation completed.");
#else
    cout << endl << RSC_FILENAME << ": Creation completed." << endl;
#endif

    exit(0);
}

// ============================================================================
TDialog *AboutBox(void)
{
    TDialog *aboutBox = new TDialog(TRect(0, 0, 46, 14), "About");
    aboutBox->options |= ofCentered;

    aboutBox->insert(new TCSHText(TRect(1, 2, 45, 10),
        "\003Ŀ\n\003 CSH " CSH_STRING
        " Class Library \n\003\n\n"
        "\003Color Syntax Highlighter Demo\n\n"
        "\003(c) 1995 Eric Woodruff\n\003CIS ID: 72134,1150"));

    TButton *b = new TButton(TRect(11,11,23,13), "O~K~", cmOK, bfDefault);
    b->options |= ofCenterX;
    aboutBox->insert(b);

    return aboutBox;
}

TDialog *Colors(void)
{
    TColorGroup &group1 =
        *new TColorGroup("Desktop") +
            *new TColorItem("Background",        1)+

        *new TColorGroup("Menus") +
            *new TColorItem("Normal text",       2)+
            *new TColorItem("Disabled text",     3)+
            *new TColorItem("Shortcut key",      4)+
            *new TColorItem("Selection bar",     5)+
            *new TColorItem("Selected disabled", 6)+
            *new TColorItem("Shortcut selected", 7);

    TColorGroup &group3 =
//        *new TColorGroup("Gray Dialog Box") +
        *new TColorGroup("Dialog Box") +
            *new TColorItem("Frame inactive",   32)+
            *new TColorItem("Frame active",     33)+
            *new TColorItem("Frame icons",      34)+
            *new TColorItem("Scrollbar page",   35)+
            *new TColorItem("Scrollbar icons",  36)+

        // Selected Shortcut is only applicable if you made the
        // changes described in COLUPDT.DOC in TVCOLR.ZIP/TVCLR2.ZIP.
            *new TColorItem("Normal label",            38)+
            *new TColorItem("Selected label",          39)+
            *new TColorItem("Label shortcut key",      40)+
#ifdef MODIFIED_TV_COLORS
    #if _TV_VERSION == 0x0103
            *new TColorItem("Selected shortcut", 66)+   // Added by me - TV 1.03 location
    #else
            *new TColorItem("Selected label shortcut key", 138)+  // Same, but TV 2.0 location
    #endif
#endif

        // Default and Selected Shortcut are only applicable if you made
        // the changes described in COLUPDT.DOC in TVCOLR.ZIP/TVCLR2.ZIP
            *new TColorItem("Normal button",            41)+
            *new TColorItem("Default button",           42)+
            *new TColorItem("Selected button",          43)+
            *new TColorItem("Disabled button",          44)+
            *new TColorItem("Button shortcut key",      45)+
#ifdef MODIFIED_TV_COLORS
    #if _TV_VERSION == 0x0103
            *new TColorItem("Default shortcut",  64)+   // Added by me - TV 1.03 location
            *new TColorItem("Selected shortcut", 65)+
    #else
            *new TColorItem("Default button shortcut key",  136)+ // Same, but TV 2.0 location
            *new TColorItem("Selected button shortcut key", 137)+
    #endif
#endif
            *new TColorItem("Button shadow",            46)+

            *new TColorItem("Cluster normal",    47)+
            *new TColorItem("Cluster selected",  48)+
            *new TColorItem("Cluster shortcut",  49)+

            *new TColorItem("Input line normal",    50)+
            *new TColorItem("Input line selected",  51)+
            *new TColorItem("Input line arrow",     52)+
            *new TColorItem("History button",       53)+
            *new TColorItem("History sides",        54)+
            *new TColorItem("History scrollbar",    55)+
            *new TColorItem("History icons",        56)+

            *new TColorItem("Normal list item",     57)+
            *new TColorItem("Focused list item",    58)+
            *new TColorItem("Selected list item",   59)+
            *new TColorItem("List divider",         60)+
            *new TColorItem("Information pane",     61);

    TColorGroup &group4 =
        *new TColorGroup("Help Window") +
#if _TV_VERSION == 0x0103
    #ifdef MODIFIED_TV_COLORS
            *new TColorItem("Frame inactive",   67)+        // TV 1.03 locations after
            *new TColorItem("Frame active",     68)+        // TVCOLR/TVCLR2.ZIP modifications.
            *new TColorItem("Frame icons",      69)+
            *new TColorItem("Scrollbar page",   70)+
            *new TColorItem("Scrollbar icons",  71)+
            *new TColorItem("Normal text",      72)+
            *new TColorItem("Keyword",          73)+
            *new TColorItem("Selected keyword", 74);
    #else
            *new TColorItem("Frame inactive",   64)+        // Standard unmodified TV 1.03
            *new TColorItem("Frame active",     65)+        // locations.
            *new TColorItem("Frame icons",      66)+
            *new TColorItem("Scrollbar page",   67)+
            *new TColorItem("Scrollbar icons",  68)+
            *new TColorItem("Normal text",      69)+
            *new TColorItem("Keyword",          70)+
            *new TColorItem("Selected keyword", 71);
    #endif
#else
            *new TColorItem("Frame inactive",   128)+       // The help colors are a part
            *new TColorItem("Frame active",     129)+       // of the base palette in
            *new TColorItem("Frame icons",      130)+       // TV 2.0.  These are the standard
            *new TColorItem("Scrollbar page",   131)+       // unmodified locations.
            *new TColorItem("Scrollbar icons",  132)+
            *new TColorItem("Normal text",      133)+
            *new TColorItem("Keyword",          134)+
            *new TColorItem("Selected keyword", 135);
#endif

    TColorGroup &All = group1 + group3 + group4;

    // See the notes in handleEvent() about the proper usage of TColorDialog.
    TColorDialog *c = new TColorDialog((TPalette*)0, &All);

    return c;
}

TMenuBar *initMenuBar(void)
{
    TSubMenu& MiscMenu = *new TSubMenu( "~\xF0~", 0) +
        *new TMenuItem( "~A~bout...", cmAbout, kbNoKey)+
        *new TMenuItem( "~R~epaint desktop", cmRepaint, kbNoKey);

    TSubMenu& FileMenu = *new TSubMenu("~F~ile", 0) +
        *new TMenuItem("~O~pen...", cmOpen, kbF3, hcNoContext, "F3") +
        *new TMenuItem("~T~ext demo", cmTextDemo, kbF4, hcNoContext, "F4") +
            newLine() +
        *new TMenuItem("~C~hange dir...", cmChDir, kbNoKey)+
        *new TMenuItem( "~D~OS shell", cmDosShell, kbNoKey) +
            newLine() +
        *new TMenuItem( "~Q~uit", cmQuit, kbAltX, hcNoContext, "Alt+X" );

    TSubMenu& WindowMenu = *new TSubMenu( "~W~indows", 0) +
        *new TMenuItem( "~S~ize/Move", cmResize, kbCtrlF5, hcNoContext, "Ctrl+F5" ) +
        *new TMenuItem( "~Z~oom", cmZoom, kbF5, hcNoContext, "F5" ) +
        *new TMenuItem( "C~a~scade", cmCascade, kbNoKey) +
        *new TMenuItem( "~T~ile", cmTile, kbNoKey) +
        *new TMenuItem( "Ne~x~t", cmNext, kbF6, hcNoContext, "F6" ) +
        *new TMenuItem( "~P~revious", cmPrev, kbShiftF6, hcNoContext, "Shift+F6" ) +
        *new TMenuItem( "~C~lose", cmClose, kbAltF3, hcNoContext, "Alt+F3" ) +
        *new TMenuItem( "Clos~e~ all", cmCloseAll, kbNoKey) +
            newLine() +
        *new TMenuItem( "To~g~gle Screen Size", cmScreenSize, kbNoKey) +
        *new TMenuItem( "~U~ser screen", cmUserScreen, kbAltF5, hcNoContext, "Alt+F5");

    TSubMenu& OptionsMenu = *new TSubMenu("~O~ptions", 0) +
        *new TMenuItem( "~C~olors...", cmColors, kbNoKey ) +
        *new TMenuItem( "Color Synta~x~...", cmCSHColors, kbNoKey ) +
        *new TMenuItem( "C~h~ange palettes", cmChangePalettes, kbNoKey ) +
            newLine() +
        *new TMenuItem( "~L~oad configuration...", cmLoadCfg, kbNoKey) +
        *new TMenuItem( "~S~ave configuration...", cmSaveCfg, kbNoKey);

    return new TMenuBar(TRect(0, 0, 80, 1), MiscMenu + FileMenu + WindowMenu +
        OptionsMenu);
}

TStatusLine *initStatusLine(void)
{
    return new TStatusLine( TRect(0, 24, 80, 25),
      *new TStatusDef( 0, 0xFFFF ) +
        *new TStatusItem("~F3~ Open", kbF3, cmOpen) +
        *new TStatusItem("~Alt+F3~ Close", kbAltF3, cmClose) +
        *new TStatusItem("~F5~ Zoom", kbF5, cmZoom) +
        *new TStatusItem("~F6~ Next", kbF6, cmNext) +

        *new TStatusItem(0, kbF10, cmMenu));
}
