// System  : CSH 1.00 - Color Syntax Highlighter
// File    : TCSHTEXT.CPP
// Author  : Eric Woodruff,  CIS ID: 72134,1150
// Updated : Wed 08/02/95 21:57:57
// Note    : Copyright 1995, Eric Woodruff, All rights reserved
// Compiler: Borland C++ 3.1 to 4.xx
//
// This file contains the code for the static text class that uses a
// color syntax highlighter.
//

#include <ctype.h>
#include <string.h>

#define Uses_TStaticText
#define Uses_TStreamableClass
#define Uses_ipstream
#define Uses_opstream
#include <tv.h>

__link(RStaticText)

#include <csh.h>
#include <tcshtext.h>

#include "fixedset.h"       // Fixed syntax set header file.

// ****************************************************************************
// Pointer to the fixed set.  This gets created by the first object that
// needs it and it remains allocated.  It is shared between all objects
// that make use of it.
static ColorSyntaxHighlighter *fixedSet = NULL;

// ****************************************************************************
// Make it streamable.
//
const char * const _NEAR TCSHText::name = "TCSHText";

TStreamableClass RCSHText(TCSHText::name, TCSHText::build,
    __DELTA(TCSHText));

void *TCSHText::read(ipstream &is)
{
    TStaticText::read(is);

    if(!fixedSet)
        fixedSet = new ColorSyntaxHighlighter(NULL, NULL, (char *)tcshtext);

    // NOTE: Do not delete csh when this object is destroyed!
    csh = fixedSet;

    return this;
}

TStreamable *TCSHText::build()
{
    return new TCSHText( streamableInit );
}

// ****************************************************************************

TCSHText::TCSHText(const TRect &bounds, const char *aText) :
    TStaticText(bounds, aText)
{
    if(!fixedSet)
        fixedSet = new ColorSyntaxHighlighter(NULL, NULL, (char *)tcshtext);

    // NOTE: Do not delete csh when this object is destroyed!
    csh = fixedSet;
}

void TCSHText::draw()
{
    ushort buffer[256];
    Boolean center = False;

    uchar color = getColor(1);
    int startPos, wrapPos, len, pos, curLine;
    char s[256], line[256];

    getText(s);
    len = strlen(s);
    pos = curLine = 0;

    // Draw each line.
    while(curLine < size.y)
    {
        memset(line, ' ', 255);

        // Fill in line if not at the end of the string.
        if(pos < len)
        {
            // Center the line?
            if(s[pos] == '\003')
            {
                center = True;
                ++pos;
            }

            startPos = pos;

            // Find end of line.
            do
            {
               wrapPos = pos;

               while(pos < len && s[pos] == ' ')
                   ++pos;

               while(pos < len && s[pos] != ' ' && s[pos] != '\n')
                   ++pos;

            } while(pos < len && pos < startPos + size.x && s[pos] != '\n');

            // Word wrap the text?
            if(pos > startPos + size.x)
                if(wrapPos > startPos)
                    pos = wrapPos;
                else
                    pos = startPos + size.x;

            if(center)
               wrapPos = (size.x - pos + startPos) / 2 ;
            else
               wrapPos = 0;

            memcpy(line + wrapPos, s + startPos, (pos - startPos));
            line[wrapPos + (pos - startPos)] = EOS;

            // Skip trailing blanks.
            while((pos < len) && (s[pos] == ' '))
                pos++;

            // If line ended in a line feed, skip it and turn
            // off centering.
            if(pos < len && s[pos] == '\n')
            {
                center = False;
                pos++;
            }
        }
        csh->HighlightLine(line, (uchar *)&buffer[0], color, 256);
        writeLine(0, curLine++, size.x, 1, buffer);
    }
}
