#// System  : CSH 1.00 - Color Syntax Highlighter
#// File    : DEMO.MAK
#// Author  : Eric Woodruff,  CIS ID: 72134,1150
#// Updated : Wed 08/02/95 21:57:57
#// Note    : Copyright 1994-95, Eric Woodruff, All rights reserved
#// Compiler: Borland C++ 3.1 to 4.xx
#//
#   Make file for building the CSH 1.0 demo.  Unless overridden by command
#   line flags, this will generate real mode, non-overlay executables.
#
#   NOTE: To create a demo that uses the Color Syntax Highlighter with
#         TVMEditor, create a CSH directory under the TVMEDIT3 directory and
#         copy the CSH library and header files to that directory.  Then, use
#         the '-DCSH_LIBRARY=libname' option when you run make where
#         'libname' is the name of the library to use.
#         Example:  make -fdemo -DCSH_LIBRARY=CSH.LIB
#         You will also need to copy the CSHDEFLT.DTA file to the TVMEDIT2
#         directory so that the executable can find it.
#
# File location assumptions:
#
# Directory Tree for CSH 1.0:
#   CSH                    - Base directory. The name is not significant.
#                            The source and library files are found here.
#                            The executables are left here after the build.
#   CSH\SOURCE             - Source code directory.
#   CSH\OBJ???             - Object file dir(s) generated by the build.
#                            Each build uses a unique name for the object dir
#                            associated with the executables being created.
#                            Once the demo(s) are built, you can delete these.
#
# ** NOTE: Run the make file from the base directory (i.e. CSH above).
#
# MAKE with:
#
# No command line flags:
#       Compile for Borland C++ 4.xx using Turbo Vision 2.0
#       Executables created will be for real mode, non-overlay.
#       Directories: Compiler Root: C:\BC4
#                          Include: C:\BC4\INCLUDE
#                        Libraries: C:\BC4\LIB
#                       TV Include: C:\BC4\INCLUDE\TVISION
#
# -DBC31
#       Compile for Borland C++ 3.1 using Turbo Vision 1.03
#       Executables created will be for real mode, non-overlay.
#       Directories: Compiler Root: C:\BC
#                          Include: C:\BC\INCLUDE
#                        Libraries: C:\BC\LIB;C:\BC\TVISION\LIB
#                       TV Include: C:\BC\TVISION\INCLUDE
#
# -DBC31 -DTV2
#       Compile for Borland C++ 3.1 using Turbo Vision 2.0
#       Library created will be for real mode, non-overlay.
#       Directories: Compiler Root: C:\BC
#                          Include: C:\BC\INCLUDE
#                       TV Include: C:\BC\INCLUDE\TVISION
#
# -DTV103
#       Compile for Borland C++ 4.xx using Turbo Vision 1.03
#       Executables created will be for real mode, non-overlay.
#       Directories: Compiler Root: C:\BC4
#                          Include: C:\BC4\INCLUDE
#                        Libraries: C:\BC4\LIB;C:\BC4\TVISION\LIB
#                       TV Include: C:\BC4\TVISION\INCLUDE
#
# Flags for DEMO.MAK:
#
# These command line switches alter the build flags used during
# compilation.  You can use them to alter the build characteristics or you
# can edit the default option flag settings in the make file down below.
#
#     -DBC31         Build using Borland C++ 3.1
#                    TV103 is automatically defined to use Turbo Vision 1.03
#                    unless -DTV2 is specified (see below).
#                    If not specified, Borland C++ 4.xx is assumed
#
#     -DTV2          Specify this with -DBC31 to compile for use with
#                    BC++ 3.1 and TV 2.0.
#
#     -DTV103        Build for use with TV 1.03
#                    If not specified, TV 2.0 is assumed (unless -DBC31 is
#                    specified without -DTV2)
#
#     -DCPU286       Build demo for the 80286 and up (CPUFLAG = -2)
#                    If not specified, compile for 8088 (CPUFLAG = -1- -2-)
#                    NOTE:
#                       If -DDOS16 (DPMI16), automatic CPUFLAG = -2
#                       If -DDOS32 (DPMI32), automatic CPUFLAG = -3
#
#     -DOPT32        Compiler bugs prevent use of the optimization options
#                    for 32-bit protected mode apps prior to BC++ 4.5.
#                    BC++ 4.5 fixes the bugs, so define OPT32 to utilize
#                    the optimization features of the 32-bit compiler.
#
#     -DOVERLAY      Build using overlayable version - CSHO.LIB
#
#     -DDOS16        Build using 16-bit DPMI version - CSH16.LIB
#                    BC++ 4.xx and Power Pack required
#
#     -DDOS32        Build using 32-bit DPMI version - CSH32.LIB
#                    BC++ 4.xx and Power Pack required
#
#     -DDEBUG        Include full debug info in the demos, turn off all
#                    optimizations, and enable the editor diagnostic checks.
#                    Library name used depends on the above settings:
#                       CSHD.LIB                 - Real mode, non overlay
#                       CSHOD.LIB                - Real mode, overlay
#                       CSH16D.LIB               - 16-bit protected mode
#                       CSH32D.LIB               - 32-bit protected mode
#
#     -DBCROOT=...   Specifies the path where you installed the compiler
#                    (i.e. C:\BC, C:\BC4, C:\BORLANDC, etc.)
#
#     -DTVINCDIR=... Specifies the path where you installed Turbo Vision's
#                    header files
#                    (i.e. C:\BC\TVISION\INCLUDE, C:\AF\INCLUDE, etc.)
#
#     -DTVLIBDIR=... Specifies the path where you installed Turbo Vision's
#                    library files (i.e. \BC\TVISION\LIB or \BC4\LIB)
#
#     -DALIGNMENT=2  Optional word (=2) or dword (=4) aligned library.  Only
#     -DALIGNMENT=4  use it if you have word or dword aligned libraries!
#
# Examples:
#     make -fdemo                    - Real mode using BC++ 4/TV 2.0
#     make -fdemo -DTV103            - Real mode using BC++ 4/TV 1.03
#     make -fdemo -DBC31             - Real mode using BC++ 3.1/TV 1.03
#     make -DBC31 -DTV2              - Real mode using BC++ 3.1/TV 2.0
#
#     make -fdemo -DCPU286           - Real mode, BC++ 4/TV 2.0, for 286
#     make -fdemo -DOVERLAY -DCPU286 - Overlayed, BC++ 4/TV 2.0, for 286
#     make -fdemo -DDOS16            - 16 bit DPMI
#     make -fdemo -DDOS32            - 32 bit DPMI
#     make -fdemo -DDOS32 -DDEBUG    - 32 bit DPMI with full debug info
#

.autodepend
.swap
.silent

# ****************** Uncomment the appropriate lines to default to a
# ****************** specific build mode.

# The value assigned is not important.  It's just to get the defintion
# into existence.  If all are commented out, it defaults to BC++ 4.xx
# with Turbo Vision 2.0.

# BC31 =
# TV103 =
# TV2 =

# If BC31 is defined and TV2 is not defined, enforce TV 1.03 usage.
!if $d(BC31) && !$d(TV103) && !$d(TV2)
TV103 =
!endif

# ****************** Here's where to adjust the base directory location

!if !$d(BCROOT)
!if $d(BC31)
BCROOT = C:\BC
!else
BCROOT = C:\BC4
!endif
!endif

# ****************** Here's where to adjust the TV include file location

!if !$d(TVINCDIR)
!if $d(TV103)
TVINCDIR = $(BCROOT)\TVISION\INCLUDE
!else
TVINCDIR = $(BCROOT)\INCLUDE\TVISION
!endif
!endif

# ****************** Here's where to adjust the TV library file location
!if !$d(TVLIBDIR)
!if $d(TV103)
TVLIBDIR = $(BCROOT)\TVISION\LIB
!else
TVLIBDIR =
!endif
!endif

# Set include file and library locations.
INCLUDE  = $(BCROOT)\INCLUDE;$(TVINCDIR);.;.\SOURCE;..
LIBDIR   = $(BCROOT)\LIB;$(TVLIBDIR);.

# ******************* Set up for 32 bit protected mode compile
!if $d(DOS32)

!if $d(DEBUG)
CFGNAME = DEMO32D.CFG
LIBNAME = CSH32D.LIB
OBJDIR  = OBJS32D
!else
CFGNAME = DEMO32.CFG
LIBNAME = CSH32.LIB
OBJDIR  = OBJS32
!endif

CPUFLAG    = -3
TARGETFLAG = -WX
LINKFLAGS  = /Tpe /ax
STARTUP    = c0x32.obj
USERLIBS   = $(LIBNAME) tv32.lib
STDLIBS    = dpmi32.lib cw32.lib
DPMIDEF    = TV20DPMI.DEF

CC      = BCC32
LIB     = TLIB
LINK    = TLINK32

!else   # DOS32

# ******************* Set up for 16 bit protected mode compile
!if $d(DOS16)

!if $d(DEBUG)
CFGNAME = DEMO16D.CFG
LIBNAME = CSH16D.LIB
OBJDIR  = OBJS16D
!else
CFGNAME = DEMO16.CFG
LIBNAME = CSH16.LIB
OBJDIR  = OBJS16
!endif

CPUFLAG    = -2
TARGETFLAG = -WX -ml
LINKFLAGS  = /Txe /Oc /Oi
STARTUP    = c0x.obj
USERLIBS   = $(LIBNAME) tv.lib
STDLIBS    = dpmi16.lib emux.lib mathwl.lib cwl.lib
DPMIDEF    = TV20DPMI.DEF

CC      = BCC
LIB     = TLIB
LINK    = TLINK

!else   # DOS16
# ******************* Set up for real mode compile

!if $d(DEBUG)

!if $d(OVERLAY)
CFGNAME = DEMOVYD.CFG
LIBNAME = CSHOD.LIB
NOVLLIB = CSHNOD.LIB
OBJDIR  = OBJSOD
!else
CFGNAME = DEMOD.CFG
LIBNAME = CSHD.LIB
OBJDIR  = OBJSD
!endif

!else

!if $d(OVERLAY)
CFGNAME = DEMOVY.CFG
LIBNAME = CSHO.LIB
NOVLLIB = CSHNO.LIB
OBJDIR  = OBJSO
!else
CFGNAME = DEMO.CFG
LIBNAME = CSH.LIB
OBJDIR  = OBJS
!endif

!endif

# Set CPU type being compiled for in real mode.
!if $d(CPU286)
CPUFLAG = -2
!else
CPUFLAG = -1- -2-
!endif

TARGETFLAG = -ml
LINKFLAGS  =
STARTUP    = c0l.obj
USERLIBS   = $(LIBNAME) tv.lib
STDLIBS    = emu.lib mathl.lib cl.lib
DPMIDEF    =

# Add TVADD.LIB for non-overlay BC++ 3.1/TV 2.0
!if $d(BC31) && $d(TV2)
USERLIBS   = $(USERLIBS) TVADD.LIB
!endif

!if $d(OVERLAY)
USERLIBS   = $(LIBNAME) tvo.lib
STDLIBS    = $(NOVLLIB) tvno.lib overlay.lib emu.lib mathl.lib cl.lib
!endif

CC      = BCC
LIB     = TLIB
LINK    = TLINK

!endif # DOS16
!endif # DOS32

# ******************* Set other compiler options

LINKOVY_ON  =
LINKOVY_OFF =

!if $d(OVERLAY)
!if !$d(DOS16) && !$d(DOS32)
!if $d(BC31)
CCOVYFLAGS = -Y -Vs -Vb -B
!else
CCOVYFLAGS = -Y -Vs
!endif
LINKOVY_ON  = /o+
LINKOVY_OFF = /o-
!else
!error There's no need to use overlays with the 16-bit or 32-bit DPMI versions.
!endif
!endif

!if $d(ALIGNMENT)
ALIGNFLAG = -a$(ALIGNMENT)
!else
ALIGNFLAG =
!endif

# ******************* Set debug and optimization options

CFLAGS1    =
CFLAGSN32  =

!if $d(DEBUG)

CDEBUGFLAG = /v /DTVME_DIAG -k -N
LINKFLAGS  = $(LINKFLAGS) /v

!else

CDEBUGFLAG = /v- /DNDEBUG -k- -N- -G-

# These optimization options **cannot** be used for the BC++ 4.0/4.02
# 32-bit protected mode compiler due to bugs.   However, BC++ 4.5 fixes
# these bugs, so define OPT32 to include these optimizations if you have it.
!if !$d(DOS32) || $d(OPT32)
CFLAGSN32 = -Oe -Os -O -Ob -Ol -Z
!endif

!if !$d(DOS32)
CFLAGSN32 = $(CFLAGSN32) -h -OW
!endif

!endif

# Turn off exceptions and RTTI if using BC++ 4.xx
!if !$d(BC31)
CFLAGS1 = $(CFLAGS1) -RT- -x-
!endif

# Put them all together.  Compiler options are spread across three definitions
# because they can exceed 128 characters per line which causes it to fail.
CFLAGS1 = $(CFLAGS1) -ff -w -w-sig -w-amp -P -n$(OBJDIR) /DINCLUDE_HEAPVIEW
CFLAGS2 = $(CDEBUGFLAG) $(ALIGNFLAG) $(CCOVYFLAGS) $(CPUFLAG) $(CFLAGSN32)
CFLAGS3 = -I$(INCLUDE)

# ******************* Build dependencies

!if $d(DOS32)
DEMONAME = CSHDEM32
!else
!if $d(DOS16)
DEMONAME = CSHDEM16
!else
DEMONAME = CSHDEMO
!endif
!endif

# Don't know why this is different, but it is.
#!ifdef $(BC31)
#.path.cpp. = .;..
#!else
#.path.cpp = .;..
#!endif

.path.obj = $(OBJDIR)

RSCLST = BLDRSC.OBJ \
         TCSHTEXT.OBJ

DEMOLST = CSHDEMO1.OBJ \
          CSHDEMO2.OBJ \
          HEAPVIEW.OBJ \
          TTXTVIEW.OBJ \
          TCSHTEXT.OBJ

# Go ahead and build them.

.cpp.obj:
     $(CC) -c +$(CFGNAME) {$< }

all: $(CFGNAME) dirs bldrsc.exe
    DEL $(CFGNAME)

dirs:
    echo !!
    echo !! IF YOU ARE USING TV 1.03, RENAME TVCOLR.TV1 TO TVCOLR.H FIRST!
    echo !!
    echo !! IF YOU ARE USING TV 2.0, RENAME TVCOLR.TV2 TO TVCOLR.H FIRST!
    echo !!
    echo !! IF YOU ARE USING BC++ 3.1, RENAME CSH.BC3 TO CSH.LIB FIRST!
    echo !!
    echo !! IF YOU ARE USING BC++ 4.xx, RENAME CSH.BC4 TO CSH.LIB FIRST!
    echo !!
    echo !! IF YOU ARE USING TV 2.0, RENAME CSH.TV2 TO CSH.LIB FIRST!
    echo !!
    IF NOT EXIST $(OBJDIR) MD $(OBJDIR)

$(CFGNAME): demo.mak
    ECHO $(TARGETFLAG) $(CFLAGS1) > $(CFGNAME)
    ECHO $(CFLAGS2) >> $(CFGNAME)
    ECHO $(CFLAGS3) >> $(CFGNAME)

bldrsc.exe: $(RSCLST) $(DEMOLST)
  $(LINK) @&&|
$(LINKFLAGS)/L$(LIBDIR) +       # linker options
$(STARTUP) +                    # startup code
$(OBJDIR)\bldrsc.obj+           # object files
$(OBJDIR)\tcshtext.obj          # object files
bldrsc                          # exe name
bldrsc                          # mapfile
$(LINKOVY_ON) $(USERLIBS) +     # overlayable libraries
$(LINKOVY_OFF) $(STDLIBS)       # non-overlayable libraries
$(DPMIDEF)                      # DPMI .DEF file (if any)
|
    bldrsc

  $(LINK) @&&|
$(LINKFLAGS)/L$(LIBDIR) +       # linker options
$(STARTUP) +                    # startup code
$(OBJDIR)\cshdemo1.obj +        # object files
$(OBJDIR)\cshdemo2.obj +
$(OBJDIR)\heapview.obj +
$(OBJDIR)\ttxtview.obj +
$(OBJDIR)\tcshtext.obj
$(DEMONAME)                     # exe name
$(DEMONAME)                     # mapfile
$(LINKOVY_ON) $(USERLIBS) +     # overlayable libraries
$(LINKOVY_OFF) $(STDLIBS)       # non-overlayable libraries
$(DPMIDEF)                      # DPMI .DEF file (if any)
|

# End of CSH 1.0 demo program make file
