// System  : CSH 1.00 - Color Syntax Highlighter
// File    : CSH.H
// Author  : Eric Woodruff,  CIS ID: 72134,1150
// Updated : Wed 08/02/95 21:57:57
// Note    : Copyright 1995, Eric Woodruff, All rights reserved
// Compiler: Borland C++ 3.1 to 4.xx
//
// This is the header file for the Color Syntax Highlighter class.
//

#if !defined(__CSH_H)
#define __CSH_H

#define CSH_VERSION     0x0100      // 1.00
#define CSH_STRING      "1.00"
#define CSH_REVSTAMP    "CSH.EFW.1.00\x1A"

#if !defined(__FLAT__)

#if !defined(_NEAR)
#define _NEAR   near
#endif

#if !defined(_FAR)
#define _FAR    far
#endif

#endif

#if !defined(uchar)
#define uchar   unsigned char
#endif

#if !defined(ushort)
#define ushort  unsigned short
#endif

// ****************************************************************************
// Turbo Vision Get/Set color events and detect a shareable set.
const
    cmCSHGetColors  = 32000,    // Any value is okay as long as it
    cmCSHSetColors  = 32001,    // doesn't conflict with anything else.
    cmCSHSetLoaded  = 32002,
    cmCSHSaveColors = 32003,
    cmCSHOnOff      = 32004;

// ****************************************************************************

const csMaxPalettes = 4,        // Maximum number of color palettes
      csMaxGroups   = 16;       // Maximum number of color groups

// ****************************************************************************
//
// Color Syntax Highlighter class
//
class ColorSyntaxHighlighter
{
private:
    char *KeywordBuffer;            // Pointer to keyword buffer.

    short CaseSensitive,            // Case sensitive string compares flag
          TabSize,                  // Hard tab expansion size.
          Palette;                  // Group palette to use for colors

    short FirstChar[256];           // Offsets into KeywordBuffer for
                                    // the first occurance of each unique
                                    // ASCII character.
    // Group color palettes
    uchar GroupColors[csMaxPalettes][csMaxGroups];

public:
    char *SetName;                  // Dataset name.
    short RefCount;                 // Reference count for shared
                                    // syntax sets.

    ColorSyntaxHighlighter(const char *DataSetName, const char *fName,
        char *SyntaxBuffer = NULL);
    ~ColorSyntaxHighlighter();

    inline void setTabSize(short size)
        { TabSize = size; }

    inline short getPalette(void)
        { return Palette; }

    inline void setPalette(short pal)
        { Palette = pal;  }

    static char *LoadSyntaxSet(const char *DataSetName, const char *fName,
        char **setName);

    void getColorPalette(short pal, char *buffer);
    void setColorPalette(short pal, char *buffer);
    short SaveColors(const char *DataSetName);

    void HighlightLine(const char *aLine, uchar *buffer, uchar DefColor,
        short maxSize);

#if defined(CSH_DIAG)
    void DumpList(void (*DispLine)(const char *));
#endif
};

#endif
