// System  : CSH 1.00 - Color Syntax Highlighter
// File    : CSHEDIT.H
// Author  : Eric Woodruff,  CIS ID: 72134,1150
// Updated : Wed 08/02/95 21:57:57
// Note    : Copyright 1995, Eric Woodruff, All rights reserved
// Compiler: Borland C++ 3.1 to 4.xx
//
// This file contains the class declarations for the color syntax
// highlighting editor and its edit window.
//

#if !defined(__CSH_H)
#include <csh.h>
#endif

//
// Class TCSHEditWindow
//
//  Palette layout:
//      Same as TWindow
//
#if defined(Uses_TCSHEditWindow) && !defined(__TCSHEditWindow)
#define __TCSHEditWindow

class _FAR TEvent;
class _FAR TCSHEditor;

class TCSHEditWindow : public TWindow
{
public:
    TCSHEditor *editor;

    TCSHEditWindow(const TRect &bounds, const char *aFileName,
        int aNumber = 0, Boolean IndAtTop = True, short bufSizeInK = 20,
        Boolean SuppressLoad = False);

    virtual const char *getTitle(short maxSize);    // Return filename.
    virtual void close(void);
    virtual void handleEvent(TEvent &event);
    virtual void sizeLimits(TPoint &min, TPoint &max);

private:
    static const char * _NEAR clipboardTitle;
    static const char * _NEAR untitled;

    virtual const char *streamableName() const
        { return name; }

protected:
    TCSHEditWindow( StreamableInit );
    virtual void write( opstream& );
    virtual void *read( ipstream& );

public:
    static const char * const _NEAR name;
    static TStreamable *build();
};

inline ipstream& operator >> ( ipstream& is, TCSHEditWindow& cl )
    { return is >> (TStreamable&)cl; }
inline ipstream& operator >> ( ipstream& is, TCSHEditWindow*& cl )
    { return is >> (void *&)cl; }

inline opstream& operator << ( opstream& os, TCSHEditWindow& cl )
    { return os << (TStreamable&)cl; }
inline opstream& operator << ( opstream& os, TCSHEditWindow* cl )
    { return os << (TStreamable *)cl; }

#endif  // Uses_TCSHEditWindow

//
// Class TCSHEditor
//
//  Palette layout:
//      Same as TVMFileEditor
//
#if defined(Uses_TCSHEditor) && !defined(__TCSHEditor)
#define __TCSHEditor

#if !defined(__TVMEDIT_H)
#define Uses_TVMFileEditor
#include <tvmedit.h>
#endif

class _FAR TEvent;
class _FAR TScrollBar;
class _FAR TVMScrollBar;
class _FAR TVMIndicator;
class _FAR ColorSyntaxHighlighter;

class TCSHEditor : public TVMFileEditor
{
public:
    ColorSyntaxHighlighter *csh;

    // Static pointer to the Color Syntax Highligher's data file.
    static const char * _NEAR CSHDataSetName;

    TCSHEditor(const TRect &bounds, TScrollBar *aHScrollBar,
        TVMScrollBar *aVScrollBar, TVMIndicator *aIndicator,
        const char *aFileName, short bufSizeInK = 20,
        Boolean SuppressLoad = False);

    virtual void shutDown(void);
    virtual void drawLines(short y, short count, long lineNbr);

    virtual void handleEvent(TEvent &event);

private:
    void LoadSyntaxSet(void);

    virtual const char *streamableName() const
        { return name; }

protected:
    TCSHEditor( StreamableInit );
    virtual void *read( ipstream& );

public:
    static const char * const _NEAR name;
    static TStreamable *build();
};

inline ipstream& operator >> ( ipstream& is, TCSHEditor& cl )
    { return is >> (TStreamable&)cl; }
inline ipstream& operator >> ( ipstream& is, TCSHEditor*& cl )
    { return is >> (void *&)cl; }

inline opstream& operator << ( opstream& os, TCSHEditor& cl )
    { return os << (TStreamable&)cl; }
inline opstream& operator << ( opstream& os, TCSHEditor* cl )
    { return os << (TStreamable *)cl; }

#endif  // Uses_TCSHEditor
