// File    : CSHDEMO.H
// Author  : Eric Woodruff,  CIS ID: 72134,1150
// Updated : Wed 08/02/95 21:57:57
// Note    : Copyright 1995, Eric Woodruff, All rights reserved
// Compiler: Borland C++ 3.1 to 4.xx
//
// Header file for the Color Syntax Highlighter demo.
//

#if !defined(__FLAT__)

#if !defined(_NEAR)
#define _NEAR   near
#endif

#if !defined(_FAR)
#define _FAR    far
#endif

#endif

const
    cmAbout         = 100,          // Standard event values.
    cmRepaint       = 101,
    cmColors        = 102,
    cmChangePalettes = 103,
    cmLoadCfg       = 104,
    cmSaveCfg       = 105,
    cmScreenSize    = 106,
    cmUserScreen    = 107,

#if _TV_VERSION == 0x0103           // Other command values.
    cmOpen       = 109,             // in TV 2.0.
    cmChDir      = 110,
    cmDosShell   = 111,
    cmCloseAll   = 112,
#endif
    cmCSHColors  = 122,
    cmTextDemo   = 123;

#if defined(Uses_TCSHApp)

// Exit code values.
#define EXIT_NOERR      0
#define EXIT_RSCERR     1001
#define EXIT_SYNTAX     1002
#define EXIT_SWERR      1003
#define EXIT_GENERR     1004

class _FAR TDeskTop;
class _FAR TDialog;
class _FAR TEvent;
class _FAR TMenuBar;
class _FAR TStatusLine;
class _FAR TPalette;

class _FAR TTextViewWindow;

#ifdef INCLUDE_HEAPVIEW
class _FAR THeapView;
#endif

class TCSHApp : public TApplication
{
public:
    TCSHApp(void);
    static TMenuBar *initMenuBar(TRect r);
    static TStatusLine *initStatusLine(TRect r);
    static TDeskTop *initDeskTop(TRect r);

    virtual void initScreen();                  // Sets correct palette.
    virtual void idle(void);
    virtual void handleEvent(TEvent &event);
    virtual void outOfMemory(void);
    virtual TPalette& getPalette() const;

    void loadConfig(Boolean UseFileSetting);
    void saveConfig(void);

private:
#ifdef INCLUDE_HEAPVIEW
    THeapView *heap;
#endif

    TTextViewWindow *openViewer(const char *fName, Boolean visible);

    void setCSHColors(void);

    void textDemo(void);
};

// A couple of useful functions.
#if _TV_VERSION == 0x0103
ushort executeDialog(TDialog *d, void *data);
#endif
Boolean isTileable(TView *p, void *);

// Other stuff.

#endif
