//* System  : CSH 1.00 - Color Syntax Highlighter
//* File    : CSHDEFLT.SET
//* Author  : Eric Woodruff,  CIS ID: 72134,1150
//* Updated : Wed 08/02/95 21:57:57
//* Note    : Copyright 1995, Eric Woodruff, All rights reserved
//* Compiler: CSHCC 1.00
//*
//* Syntax Set File Layout
//*
//* '//*' in the first three positions of the line indicates a comment or
//* one of the special directives given below.

//* Default Group Colors
//* To save you from defining each individual color for each syntax entry,
//* you can refer to a color group.  This also helps applications that
//* alter their colors based on the monitor in use (color, monochrome,
//* black and white, etc).  Syntax entries that refer to a group color will
//* always pick up the proper color for the monitor type as long as you
//* tell it the appropriate palette to use.  Individual colors can still
//* be hard coded if so desired (see the syntax entry descriptions further
//* down).  Each palette has sixteen individual colors identified as
//* A through P.  Colors can be redefined as often as you like by putting
//* another [Group Colors] section between syntax entry sets.  The colors
//* defined stay in effect until the next [Group Colors] section is seen.
//*
//* NOTE: Always use the format shown.
//*
//* [Group Colors]
//*        |Palette
//*  Group |Color  Black & White  Monochrome  Alternate
//* -------+-------------------------------------------
       A     02         78            01         12
       B     0F         0F            07         1F
       C     0E         07            0F         1B
       D     03         70            70         13
       E     0A         0F            07         1A
       F     06         08            0F         17
       G     70         70            70         70
       H     0C         07            07         1C
       I     0B         07            07         1B
       J     05         07            07         1E
       K     4E         7F            01         4E
       L     1F         70            0F         6F
       M     0D         07            07         1D
       N     07         07            07         1E
       O     07         07            07         1E
       P     07         07            07         1E

//* Syntax Set.
//* A syntax set is delimited by a directive containing a list of file
//* extensions that it applies to or an actual name if you prefer.  Note
//* that the set name must start and end with a '.' and each extension
//* must be separated by a '.' so as to prevent accidental matching of
//* shorter filenames to longer ones (i.e. ".c." will not match ".cpp.").
//* For fixed sets (generated to a header file), the name becomes the array
//* name.
//*
//* Use the '//* [Case Sensitive]' directive to indicate that the entries
//* in the syntax set are case sensitive.  Omitting this directive will
//* generate a case-insensitive syntax set and the highlighter will match
//* keywords regardless of case.
//*
//* These are the allowable options for the syntax entries:
//*
//* Colors(k, p, n)     Define the colors for the keyword itself (k) and
//*                     for any word colored by the PrevWord (p) and/or
//*                     NextWord (n) options.  For keywords with the Numeric
//*                     option, 'k' will be used to color decimal numbers,
//*                     'p' for hex numbers, and 'n' for octal numbers.
//*
//* Numeric             Highlight all digits plus an optional decimal place
//*                     and sign.  This includes hex digits A-F when they
//*                     follow a digit.
//*
//* SingleChar          Indicate that a single character will be colored
//*                     individually even if followed by a non-terminator.
//*
//* Terminator          Marks the end of a word and the start of the
//*                     next one.
//*
//* Inclusive           Inclusive terminator.  Marks the end of the word
//*                     but, unlike Terminator, an Inclusive becomes part
//*                     of the word.
//*
//* DoubleChar          Mark a double character sequence so that it will
//*                     color individually even if followed by a
//*                     non-terminator.
//*
//* PrevWord            Color the previous word too.
//*
//* NextWord            Color the next word too.
//*
//* WholeWord           Color all non-terminator characters that touch
//*                     this keyword.
//*
//* ToStart             Color to the start of the line.
//*
//* ToEnd               Color to the end of the line.
//*
//* Quote               Color all characters between the quote set.
//*
//* The options can start anywhere after the keyword and must be separated
//* by at least one comma.
//*

//* NOTE: "[.<>.]" has special meaning.  It denotes filenames with
//*       no extension.  It will also be used for any filename whose
//*       extension cannot be found in the data file.  If this set
//*       does not appear in the syntax file and an extension cannot
//*       be found, no highlighting will occur for the object.
//* [.<>.]
0                       Colors(E,H,M), Numeric
1                       Colors(E,H,M), Numeric
2                       Colors(E,H,M), Numeric
3                       Colors(E,H,M), Numeric
4                       Colors(E,H,M), Numeric
5                       Colors(E,H,M), Numeric
6                       Colors(E,H,M), Numeric
7                       Colors(E,H,M), Numeric
8                       Colors(E,H,M), Numeric
9                       Colors(E,H,M), Numeric
*                       Colors(C), Terminator
warning                 Colors(K)
NOTE:                   Colors(L)
"                       Colors(D), Quote
                       Colors(G), Quote
                       Colors(G), Quote
                       Colors(G), Quote
                       Colors(G), Quote
                       Colors(G), Quote
                       Colors(G), Quote
                       Colors(G), Quote
                       Colors(G), Quote
                       Colors(G), Quote
                       Colors(G), Quote
                       Colors(G), Quote
                       Colors(G), Quote
                       Colors(G), Quote
                       Colors(G), Quote
                       Colors(G), Quote

//********************** Default syntax sets

//* [.ada.]
"                       Colors(D), Quote
#                       Colors(E), Terminator
%                       Colors(E), Terminator
&                       Colors(C), Terminator
'                       Colors(C), Terminator
(                       Colors(C, F), Terminator, PrevWord
)                       Colors(C), Terminator
*                       Colors(C), Terminator
**                      Colors(C), DoubleChar
+                       Colors(C), Terminator
,                       Colors(C), Terminator
-                       Colors(C), Terminator
--                      Colors(A), DoubleChar, ToEnd
.                       Colors(F), Terminator, WholeWord
..                      Colors(C), DoubleChar
/                       Colors(C), Terminator
/=                      Colors(E), DoubleChar
0                       Colors(E,H,M), Numeric
1                       Colors(E,H,M), Numeric
2                       Colors(E,H,M), Numeric
3                       Colors(E,H,M), Numeric
4                       Colors(E,H,M), Numeric
5                       Colors(E,H,M), Numeric
6                       Colors(E,H,M), Numeric
7                       Colors(E,H,M), Numeric
8                       Colors(E,H,M), Numeric
9                       Colors(E,H,M), Numeric
:                       Colors(C), Terminator
:=                      Colors(C), DoubleChar
;                       Colors(C), Terminator
<                       Colors(E), Terminator
<<                      Colors(D, D, E), DoubleChar, NextWord
<=                      Colors(E), DoubleChar
<>                      Colors(C), DoubleChar
=                       Colors(E), Terminator
=>                      Colors(C, C, F), DoubleChar, NextWord
>                       Colors(E), Terminator
>=                      Colors(E), DoubleChar
>>                      Colors(D), DoubleChar
_                       Colors(00)
abort                   Colors(F)
abs                     Colors(C)
accept                  Colors(F)
access                  Colors(F), NextWord
ack                     Colors(F)
address                 Colors(D)
aft                     Colors(D)
all                     Colors(F)
ampersand               Colors(F)
and                     Colors(E)
array                   Colors(F)
ascii                   Colors(F)
asset                   Colors(F)
at                      Colors(F)
at_sign                 Colors(F)
back_slash              Colors(F)
bar                     Colors(F)
begin                   Colors(C)
bel                     Colors(F)
body                    Colors(F, F, D), NextWord
boolean                 Colors(B)
bs                      Colors(F)
calendar                Colors(F)
callable                Colors(D)
can                     Colors(F)
case                    Colors(C)
character               Colors(B)
circumflex              Colors(F)
clock                   Colors(F)
close                   Colors(F)
col                     Colors(F)
colon                   Colors(F)
constant                Colors(F)
constrained             Colors(D)
constraint_error        Colors(D)
controlled              Colors(D)
count                   Colors(D)
cr                      Colors(F)
create                  Colors(F)
current_input           Colors(F)
current_output          Colors(F)
data_error              Colors(D)
day                     Colors(F)
day_duration            Colors(B)
day_number              Colors(B)
dc1                     Colors(F)
dc2                     Colors(F)
dc3                     Colors(F)
dc4                     Colors(F)
declare                 Colors(C)
del                     Colors(F)
delay                   Colors(F)
delete                  Colors(F)
delta                   Colors(F)
device_error            Colors(D)
digits                  Colors(F)
direct_io               Colors(F)
dle                     Colors(F)
do                      Colors(C)
dollar                  Colors(F)
duration                Colors(B)
elaborate               Colors(D)
element_type            Colors(B)
else                    Colors(E, E, F), NextWord
elsif                   Colors(E, E, F), NextWord
em                      Colors(F)
emax                    Colors(D)
end                     Colors(C, C, F), NextWord
end_error               Colors(D)
end_of_file             Colors(F)
end_of_line             Colors(F)
end_of_page             Colors(F)
enq                     Colors(F)
entry                   Colors(F)
enum                    Colors(B)
enumeration_io          Colors(F)
eot                     Colors(F)
epsilon                 Colors(D)
esc                     Colors(F)
etb                     Colors(F)
etx                     Colors(F)
exception               Colors(F)
exclaim                 Colors(F)
exit                    Colors(C)
false                   Colors(C)
ff                      Colors(F)
field                   Colors(B)
file                    Colors(F)
file_mode               Colors(B)
file_type               Colors(B)
fine_delta              Colors(B)
first                   Colors(D)
first_bit               Colors(D)
fixed_io                Colors(F)
float                   Colors(B)
float_io                Colors(F)
for                     Colors(C)
fore                    Colors(D)
form                    Colors(F)
fs                      Colors(F)
function                Colors(B, B, F), NextWord
generic                 Colors(F)
get                     Colors(F)
get_line                Colors(F)
goto                    Colors(C, C, F), NextWord
grave                   Colors(F)
gs                      Colors(F)
ht                      Colors(F)
if                      Colors(E, E, F), NextWord
image                   Colors(D)
in                      Colors(F), NextWord
index                   Colors(F)
inline                  Colors(D)
integer                 Colors(B)
integer_io              Colors(F)
interface               Colors(D)
io_exceptions           Colors(D)
is                      Colors(F)
is_open                 Colors(F)
large                   Colors(D)
last                    Colors(D)
last_bit                Colors(D)
layout_error            Colors(D)
lc_a                    Colors(F)
lc_b                    Colors(F)
lc_c                    Colors(F)
lc_d                    Colors(F)
lc_e                    Colors(F)
lc_f                    Colors(F)
lc_g                    Colors(F)
lc_h                    Colors(F)
lc_i                    Colors(F)
lc_j                    Colors(F)
lc_k                    Colors(F)
lc_l                    Colors(F)
lc_m                    Colors(F)
lc_n                    Colors(F)
lc_o                    Colors(F)
lc_p                    Colors(F)
lc_q                    Colors(F)
lc_r                    Colors(F)
lc_s                    Colors(F)
lc_t                    Colors(F)
lc_u                    Colors(F)
lc_v                    Colors(F)
lc_w                    Colors(F)
lc_x                    Colors(F)
lc_y                    Colors(F)
lc_z                    Colors(F)
length                  Colors(D)
lf                      Colors(F)
limited                 Colors(F)
line                    Colors(F)
line_length             Colors(F)
list                    Colors(D)
long_float              Colors(B)
long_integer            Colors(B)
loop                    Colors(C, F), PrevWord
l_brace                 Colors(F)
l_bracket               Colors(F)
machine_emax            Colors(D)
machine_emin            Colors(D)
machine_mantissa        Colors(D)
machine_overflows       Colors(D)
machine_radix           Colors(D)
machine_rounds          Colors(D)
mantissa                Colors(D)
max_digits              Colors(B)
max_int                 Colors(B)
max_mantissa            Colors(B)
memory_size             Colors(D)
min_int                 Colors(B)
mod                     Colors(C)
mode                    Colors(F)
mode_error              Colors(D)
month                   Colors(F)
month_number            Colors(B)
nak                     Colors(F)
name                    Colors(F)
name_error              Colors(D)
natural                 Colors(B)
new                     Colors(F)
new_line                Colors(F)
new_page                Colors(F)
not                     Colors(C, C, F), NextWord
nul                     Colors(F)
null                    Colors(F)
num                     Colors(B)
number                  Colors(B)
number_base             Colors(B)
numeric_error           Colors(D)
of                      Colors(F)
open                    Colors(F)
optimize                Colors(D)
or                      Colors(E)
others                  Colors(F)
out                     Colors(F)
pack                    Colors(D)
package                 Colors(B, B, F), NextWord
page                    Colors(D)
page_length             Colors(F)
percent                 Colors(F)
pos                     Colors(D)
position                Colors(D)
positive                Colors(B)
positive_count          Colors(B)
pragma                  Colors(B, B, F), NextWord
pred                    Colors(D)
priority                Colors(D)
private                 Colors(F)
procedure               Colors(B, B, F), NextWord
program_error           Colors(D)
put                     Colors(F)
put_line                Colors(F)
query                   Colors(F)
quotation               Colors(F)
raise                   Colors(F)
range                   Colors(D)
read                    Colors(F)
record                  Colors(F)
rem                     Colors(C)
renames                 Colors(F)
reset                   Colors(F)
restricted              Colors(F)
return                  Colors(C, C, F), NextWord
reverse                 Colors(F)
rs                      Colors(F)
r_brace                 Colors(F)
r_bracket               Colors(F)
safe_emax               Colors(D)
safe_large              Colors(D)
safe_small              Colors(D)
seconds                 Colors(F)
select                  Colors(F)
semicolon               Colors(F)
separate                Colors(F)
sequential_io           Colors(F)
set_col                 Colors(F)
set_index               Colors(F)
set_input               Colors(F)
set_line                Colors(F)
set_line_length         Colors(F)
set_output              Colors(F)
set_page_length         Colors(F)
shared                  Colors(D)
sharp                   Colors(F)
short_float             Colors(B)
short_integer           Colors(B)
si                      Colors(F)
size                    Colors(D)
skip_line               Colors(F)
skip_page               Colors(F)
small                   Colors(D)
so                      Colors(F)
soh                     Colors(F)
split                   Colors(F)
standard                Colors(F)
standard_input          Colors(F)
standard_output         Colors(F)
status_error            Colors(D)
storage_error           Colors(D)
storage_size            Colors(D)
storage_unit            Colors(D)
string                  Colors(E)
stx                     Colors(F)
sub                     Colors(F)
subtype                 Colors(F, F, B), NextWord
succ                    Colors(D)
suppress                Colors(D)
syn                     Colors(F)
system                  Colors(F)
system_error            Colors(D)
system_name             Colors(D)
task                    Colors(F)
tasking_error           Colors(D)
terminate               Colors(C)
terminated              Colors(D)
text_io                 Colors(F)
then                    Colors(E)
tick                    Colors(B)
tilde                   Colors(F)
time                    Colors(B)
time_error              Colors(D)
time_of                 Colors(F)
true                    Colors(B)
type                    Colors(F), NextWord
unchecked_conversion    Colors(F)
unchecked_deallocation  Colors(F)
underline               Colors(F)
us                      Colors(F)
use                     Colors(F), NextWord
use_error               Colors(D)
val                     Colors(D)
value                   Colors(D)
vt                      Colors(F)
when                    Colors(C)
while                   Colors(C)
width                   Colors(D)
with                    Colors(C)
write                   Colors(F)
xor                     Colors(E)
year                    Colors(F)
year_number             Colors(B)
|                       Colors(E), Terminator

//* [.asm.asi.inc.mac.]
!                       Colors(C), Terminator
"                       Colors(C), Quote
$                       Colors(B)
$ctls                   Colors(C)
%                       Colors(B)
%bin                    Colors(F)
%cond                   Colors(F)
%cref                   Colors(F)
%crefall                Colors(F)
%crefref                Colors(F)
%crefuref               Colors(F)
%ctls                   Colors(F)
%depth                  Colors(F)
%incl                   Colors(F)
%linum                  Colors(F)
%list                   Colors(F)
%macs                   Colors(F)
%newpage                Colors(F)
%noconds                Colors(F)
%nocref                 Colors(F)
%noctls                 Colors(F)
%noincl                 Colors(F)
%nolist                 Colors(F)
%nomacs                 Colors(F)
%nosyms                 Colors(F)
%notrunc                Colors(F)
%out                    Colors(F)
%pagesize               Colors(F)
%pcnt                   Colors(F)
%poplctl                Colors(F)
%pushlctl               Colors(F)
%subttl                 Colors(F)
%syms                   Colors(F)
%tabsize                Colors(F)
%text                   Colors(F)
%title                  Colors(F)
%trunc                  Colors(F)
&                       Colors(C), Terminator
'                       Colors(C), Quote
(                       Colors(C), Terminator
)                       Colors(C), Terminator
*                       Colors(E), Terminator
+                       Colors(E), Terminator
,                       Colors(D), Terminator
-                       Colors(E), Terminator
.                       Colors(B)
.186                    Colors(F)
.286                    Colors(F)
.286c                   Colors(F)
.286p                   Colors(F)
.287                    Colors(F)
.386                    Colors(F)
.386c                   Colors(F)
.386p                   Colors(F)
.387                    Colors(F)
.486                    Colors(F)
.486c                   Colors(F)
.486p                   Colors(F)
.487                    Colors(F)
.586                    Colors(F)
.586c                   Colors(F)
.586p                   Colors(F)
.587                    Colors(F)
.8086                   Colors(F)
.8087                   Colors(F)
.alpha                  Colors(F)
.code                   Colors(F)
.const                  Colors(F)
.cref                   Colors(F)
.data                   Colors(F)
.data?                  Colors(F)
.err                    Colors(F)
.err1                   Colors(F)
.err2                   Colors(F)
.errb                   Colors(F)
.errdef                 Colors(F)
.errdif                 Colors(F)
.errdifi                Colors(F)
.erre                   Colors(F)
.erridn                 Colors(F)
.erridni                Colors(F)
.errnb                  Colors(F)
.errndef                Colors(F)
.errnz                  Colors(F)
.exit                   Colors(F)
.fardata                Colors(F)
.fardata?               Colors(F)
.lall                   Colors(F)
.lfcond                 Colors(F)
.list                   Colors(F)
.model                  Colors(F)
.radix                  Colors(F)
.sall                   Colors(F)
.segment                Colors(F)
.seq                    Colors(F)
.sfcond                 Colors(F)
.stack                  Colors(F)
.startup                Colors(F)
.tfcond                 Colors(F)
.type                   Colors(F)
.xall                   Colors(F)
.xcref                  Colors(F)
.xlist                  Colors(F)
/                       Colors(E), Terminator
0                       Colors(E,H,M), Numeric
1                       Colors(E,H,M), Numeric
2                       Colors(E,H,M), Numeric
3                       Colors(E,H,M), Numeric
4                       Colors(E,H,M), Numeric
5                       Colors(E,H,M), Numeric
6                       Colors(E,H,M), Numeric
7                       Colors(E,H,M), Numeric
8                       Colors(E,H,M), Numeric
9                       Colors(E,H,M), Numeric
:                       Colors(B), Terminator, PrevWord
;                       Colors(A), Terminator, ToEnd
<                       Colors(E), Terminator
=                       Colors(E), Terminator
>                       Colors(E), Terminator
?                       Colors(C)
??date                  Colors(C)
??filename              Colors(C)
??time                  Colors(C)
??version               Colors(C)
@32Bit                  Colors(C)
@CPU                    Colors(C)
@CodeSize               Colors(C)
@DataSize               Colors(C)
@FileName               Colors(C)
@Interface              Colors(C)
@Model                  Colors(C)
@Object                 Colors(C)
@Stack
@Startup                Colors(C)
@TableAddr_             Colors(C), WholeWord
@Table_                 Colors(C), WholeWord
@WordSize               Colors(C)
@code                   Colors(C)
@curseg                 Colors(C)
@data                   Colors(C)
@fardata                Colors(C)
@fardata?               Colors(C)
[                       Colors(D), Terminator
\                       Colors(D), Terminator
]                       Colors(D), Terminator
^                       Colors(E), Terminator
_                       Colors(00), Inclusive
__compact__             Colors(C), WholeWord
__dos16__               Colors(C), WholeWord
__dos32__               Colors(C), WholeWord
__dpmi16__              Colors(C), WholeWord
__dpmi32__              Colors(C), WholeWord
__flat__                Colors(C), WholeWord
__huge__                Colors(C), WholeWord
__large__               Colors(C), WholeWord
__medium__              Colors(C), WholeWord
__small__               Colors(C), WholeWord
__tiny__                Colors(C), WholeWord
aaa                     Colors(D)
aad                     Colors(D)
aam                     Colors(D)
aas                     Colors(D)
adc                     Colors(D)
add                     Colors(D)
ah                      Colors(H)
al                      Colors(H)
align                   Colors(D)
and                     Colors(D)
arg                     Colors(D)
arpl                    Colors(D)
assume                  Colors(E)
ax                      Colors(H)
bh                      Colors(H)
bl                      Colors(H)
bound                   Colors(D)
bp                      Colors(H)
bsf                     Colors(D)
bsr                     Colors(D)
bswap                   Colors(D)
bt                      Colors(D)
btc                     Colors(D)
btr                     Colors(D)
bts                     Colors(D)
bx                      Colors(H)
byte                    Colors(B)
call                    Colors(E), NextWord
catstr                  Colors(D)
cbw                     Colors(D)
cdq                     Colors(D)
ch                      Colors(H)
cl                      Colors(H)
clc                     Colors(D)
cld                     Colors(D)
cli                     Colors(D)
clrflag                 Colors(D)
clts                    Colors(D)
cmc                     Colors(D)
cmp                     Colors(D)
cmps                    Colors(D)
cmpsb                   Colors(D)
cmpsd                   Colors(D)
cmpsw                   Colors(D)
cmpxchg                 Colors(D)
cmpxchg8b               Colors(D)
codeptr                 Colors(B)
codeseg                 Colors(D)
comm                    Colors(D)
comment                 Colors(D)
compact                 Colors(E)
const                   Colors(D)
cpuid                   Colors(D)
cr0                     Colors(H)
cr1                     Colors(H)
cr2                     Colors(H)
cr3                     Colors(H)
cr4                     Colors(H)
cs                      Colors(H)
cwd                     Colors(D)
cwde                    Colors(D)
cx                      Colors(H)
daa                     Colors(D)
das                     Colors(D)
dataptr                 Colors(B)
dataseg                 Colors(D)
db                      Colors(B, F), PrevWord, NextWord
dd                      Colors(B, F), PrevWord, NextWord
dec                     Colors(D)
dest                    Colors(C)
df                      Colors(D)
dh                      Colors(H)
di                      Colors(H)
display                 Colors(D)
div                     Colors(D)
dl                      Colors(H)
dosseg                  Colors(D)
dp                      Colors(D)
dq                      Colors(D)
dr0                     Colors(H)
dr1                     Colors(H)
dr2                     Colors(H)
dr3                     Colors(H)
dr4                     Colors(H)
dr5                     Colors(H)
dr6                     Colors(H)
dr7                     Colors(H)
ds                      Colors(H)
dt                      Colors(D)
dup                     Colors(E, E, F), NextWord
dw                      Colors(B, F), PrevWord, NextWord
dword                   Colors(B)
dx                      Colors(H)
eax                     Colors(H)
ebp                     Colors(H)
ebx                     Colors(H)
ecx                     Colors(H)
edi                     Colors(H)
edx                     Colors(H)
else                    Colors(D)
elseif                  Colors(D)
elseif1                 Colors(D)
elseif2                 Colors(D)
elseifb                 Colors(D)
elseifdef               Colors(D)
elseifdif               Colors(D)
elseifdifi              Colors(D)
elseife                 Colors(D)
elseifidn               Colors(D)
elseifidni              Colors(D)
elseifnb                Colors(D)
elseifndef              Colors(D)
emul                    Colors(D)
end                     Colors(D)
endif                   Colors(D)
endm                    Colors(C)
endp                    Colors(B, F), PrevWord
ends                    Colors(C)
endtrd                  Colors(D)
enter                   Colors(D)
enterw                  Colors(D)
enum                    Colors(D)
eq                      Colors(E, F), PrevWord
equ                     Colors(E, F), PrevWord
err                     Colors(D)
errif                   Colors(D)
errif1                  Colors(D)
errif2                  Colors(D)
errifb                  Colors(D)
errifdef                Colors(D)
errifdif                Colors(D)
errifdifi               Colors(D)
errife                  Colors(D)
errifidn                Colors(D)
errifidni               Colors(D)
errifnb                 Colors(D)
errifndef               Colors(D)
es                      Colors(H)
esc                     Colors(D)
esi                     Colors(H)
esp                     Colors(H)
even                    Colors(D)
evendata                Colors(D)
exitcode                Colors(D)
exitm                   Colors(D)
extrn                   Colors(D), NextWord
f2xm1                   Colors(D)
fabs                    Colors(D)
fadd                    Colors(D)
faddp                   Colors(D)
far                     Colors(C)
fardata                 Colors(D)
fastimul                Colors(D)
fbld                    Colors(D)
fbstp                   Colors(D)
fchs                    Colors(D)
fclex                   Colors(D)
fcom                    Colors(D)
fcomp                   Colors(D)
fcompp                  Colors(D)
fcos                    Colors(D)
fdecstp                 Colors(D)
fdisi                   Colors(D)
fdiv                    Colors(D)
fdivp                   Colors(D)
fdivr                   Colors(D)
fdivrp                  Colors(D)
feni                    Colors(D)
ffree                   Colors(D)
fiadd                   Colors(D)
ficom                   Colors(D)
ficomp                  Colors(D)
fidiv                   Colors(D)
fidivr                  Colors(D)
fild                    Colors(D)
fimul                   Colors(D)
fincstp                 Colors(D)
finit                   Colors(D)
fist                    Colors(D)
fistp                   Colors(D)
fisub                   Colors(D)
fisubr                  Colors(D)
flat                    Colors(E)
fld                     Colors(D)
fld1                    Colors(D)
fldcw                   Colors(D)
fldenv                  Colors(D)
fldl2e                  Colors(D)
fldl2t                  Colors(D)
fldlg2                  Colors(D)
fldln2                  Colors(D)
fldpi                   Colors(D)
fldz                    Colors(D)
flipflag                Colors(D)
fmul                    Colors(D)
fmulp                   Colors(D)
fnclex                  Colors(D)
fndisi                  Colors(D)
fneni                   Colors(D)
fninit                  Colors(D)
fnop                    Colors(D)
fnsave                  Colors(D)
fnstcw                  Colors(D)
fnstenv                 Colors(D)
fnstsw                  Colors(D)
fpatan                  Colors(D)
fprem                   Colors(D)
fprem1                  Colors(D)
fptan                   Colors(D)
frndint                 Colors(D)
frstor                  Colors(D)
fs                      Colors(H)
fsave                   Colors(D)
fscale                  Colors(D)
fsetpm                  Colors(D)
fsin                    Colors(D)
fsincos                 Colors(D)
fsqrt                   Colors(D)
fst                     Colors(D)
fstcw                   Colors(D)
fstenv                  Colors(D)
fstp                    Colors(D)
fstsw                   Colors(D)
fsub                    Colors(D)
fsubp                   Colors(D)
fsubr                   Colors(D)
fsubrp                  Colors(D)
ftst                    Colors(D)
fucom                   Colors(D)
fucomp                  Colors(D)
fucompp                 Colors(D)
fwait                   Colors(D)
fword                   Colors(B)
fxam                    Colors(D)
fxch                    Colors(D)
fxtract                 Colors(D)
fyl2x                   Colors(D)
fyl2xp1                 Colors(D)
ge                      Colors(D)
getfield                Colors(D)
global                  Colors(D)
goto                    Colors(D)
group                   Colors(D)
gs                      Colors(H)
gt                      Colors(D)
high                    Colors(D)
hlt                     Colors(D)
huge                    Colors(E)
ideal                   Colors(D)
idiv                    Colors(D)
if                      Colors(D)
if1                     Colors(D)
if2                     Colors(D)
ifb                     Colors(D)
ifdef                   Colors(D)
ifdif                   Colors(D)
ifdifi                  Colors(D)
ife                     Colors(D)
ifidn                   Colors(D)
ifidni                  Colors(D)
ifnb                    Colors(D)
ifndef                  Colors(D)
ijecxz                  Colors(D)
imul                    Colors(D)
in                      Colors(D)
inc                     Colors(D)
include                 Colors(D)
includelib              Colors(D)
ins                     Colors(D)
insb                    Colors(D)
insd                    Colors(D)
instr                   Colors(D)
insw                    Colors(D)
int                     Colors(B), NextWord
into                    Colors(D)
invd                    Colors(D)
invlpg                  Colors(D)
iret                    Colors(C)
iretd                   Colors(D)
iretw                   Colors(D)
irp                     Colors(D)
irpc                    Colors(D)
ja                      Colors(B), NextWord
jae                     Colors(B), NextWord
jb                      Colors(B), NextWord
jbe                     Colors(B), NextWord
jc                      Colors(B), NextWord
jcxz                    Colors(B), NextWord
je                      Colors(B), NextWord
jecxz                   Colors(B), NextWord
jg                      Colors(B), NextWord
jge                     Colors(B), NextWord
jl                      Colors(B), NextWord
jle                     Colors(B), NextWord
jmp                     Colors(B), NextWord
jna                     Colors(B), NextWord
jnae                    Colors(B), NextWord
jnb                     Colors(B), NextWord
jnbe                    Colors(B), NextWord
jnc                     Colors(B), NextWord
jne                     Colors(B), NextWord
jng                     Colors(B), NextWord
jnge                    Colors(B), NextWord
jnl                     Colors(B), NextWord
jnle                    Colors(B), NextWord
jno                     Colors(B), NextWord
jnp                     Colors(B), NextWord
jns                     Colors(B), NextWord
jnz                     Colors(B), NextWord
jo                      Colors(B), NextWord
jp                      Colors(B), NextWord
jpe                     Colors(B), NextWord
jpo                     Colors(B), NextWord
js                      Colors(B), NextWord
jump                    Colors(C, C, B), NextWord
jumps                   Colors(D)
jz                      Colors(B), NextWord
label                   Colors(D), PrevWord, NextWord
lahf                    Colors(D)
lar                     Colors(D)
large                   Colors(E)
largestack              Colors(D)
lds                     Colors(D)
le                      Colors(D)
lea                     Colors(D)
leave                   Colors(D)
leaved                  Colors(D)
leavew                  Colors(D)
length                  Colors(D)
les                     Colors(D)
lfs                     Colors(D)
lgdt                    Colors(D)
lgs                     Colors(D)
lidt                    Colors(D)
lldt                    Colors(D)
lmsw                    Colors(D)
local                   Colors(D)
locals                  Colors(D)
lock                    Colors(D)
lods                    Colors(D)
lodsb                   Colors(D)
lodsd                   Colors(D)
lodsw                   Colors(D)
loop                    Colors(B), NextWord
loopd                   Colors(D)
loopde                  Colors(D)
loopdne                 Colors(D)
loopdnz                 Colors(D)
loopdz                  Colors(D)
loope                   Colors(B), NextWord
loopne                  Colors(B), NextWord
loopnz                  Colors(B), NextWord
loopw                   Colors(D)
loopwe                  Colors(D)
loopwne                 Colors(D)
loopwnz                 Colors(D)
loopwz                  Colors(D)
loopz                   Colors(B), NextWord
low                     Colors(D)
lsl                     Colors(D)
lss                     Colors(D)
lt                      Colors(D)
ltr                     Colors(D)
macro                   Colors(E)
mask                    Colors(D)
maskflag                Colors(D)
masm                    Colors(D)
masm51                  Colors(D)
medium                  Colors(E)
mod                     Colors(D)
model                   Colors(D)
mov                     Colors(D)
movs                    Colors(D)
movsb                   Colors(D)
movsd                   Colors(D)
movsw                   Colors(D)
movsx                   Colors(D)
movzx                   Colors(D)
mul                     Colors(D)
multerrs                Colors(D)
name                    Colors(D)
ne                      Colors(E)
near                    Colors(E)
neg                     Colors(D)
noemul                  Colors(D)
nojumps                 Colors(D)
nolocals                Colors(D)
nomasm51                Colors(D)
nomulterrs              Colors(D)
nop                     Colors(D)
nosmart                 Colors(D)
not                     Colors(C)
nothing                 Colors(B)
nowarn                  Colors(D)
offset                  Colors(B, B, E), NextWord
or                      Colors(D)
org                     Colors(D)
out                     Colors(D)
outs                    Colors(D)
outsb                   Colors(D)
outsd                   Colors(D)
outsw                   Colors(D)
p186                    Colors(D)
p286                    Colors(D)
p286n                   Colors(D)
p286p                   Colors(D)
p287                    Colors(D)
p386                    Colors(D)
p386n                   Colors(D)
p386p                   Colors(D)
p387                    Colors(D)
p486                    Colors(D)
p486n                   Colors(D)
p487                    Colors(D)
p586                    Colors(D)
p586n                   Colors(D)
p587                    Colors(D)
p8086                   Colors(D)
p8087                   Colors(D)
page                    Colors(D)
para                    Colors(B)
pascal                  Colors(E)
pno87                   Colors(D)
pop                     Colors(D)
popa                    Colors(D)
popad                   Colors(D)
popaw                   Colors(D)
popf                    Colors(D)
popfd                   Colors(D)
popfw                   Colors(D)
popstate                Colors(D)
proc                    Colors(E, F), PrevWord, NextWord
procdesc                Colors(E, F), PrevWord, NextWord
proctype                Colors(E, F), PrevWord, NextWord
psave                   Colors(D)
pscale                  Colors(D)
ptr                     Colors(B)
public                  Colors(D, B), NextWord
publicdll               Colors(D, B), NextWord
purge                   Colors(D)
push                    Colors(D)
pusha                   Colors(D)
pushad                  Colors(D)
pushaw                  Colors(D)
pushf                   Colors(D)
pushfd                  Colors(D)
pushfw                  Colors(D)
pushstate               Colors(D)
pword                   Colors(B)
quirks                  Colors(D)
qword                   Colors(B)
radix                   Colors(D)
rcl                     Colors(D)
rcr                     Colors(D)
rdmsr                   Colors(D)
rdtsc                   Colors(D)
record                  Colors(D)
rep                     Colors(B), NextWord
repe                    Colors(B), NextWord
repne                   Colors(B), NextWord
repnz                   Colors(B), NextWord
rept                    Colors(D)
repz                    Colors(B), NextWord
ret                     Colors(C)
retcode                 Colors(D)
retf                    Colors(C)
retn                    Colors(C)
rol                     Colors(D)
ror                     Colors(D)
rsm                     Colors(D)
sahf                    Colors(D)
sal                     Colors(D)
sar                     Colors(D)
sbb                     Colors(D)
scas                    Colors(D)
scasb                   Colors(D)
scasd                   Colors(D)
scasw                   Colors(D)
seg                     Colors(E)
segment                 Colors(E)
seta                    Colors(D)
setae                   Colors(D)
setb                    Colors(D)
setbe                   Colors(D)
setc                    Colors(D)
sete                    Colors(D)
setfield                Colors(D)
setflag                 Colors(D)
setg                    Colors(D)
setge                   Colors(D)
setl                    Colors(D)
setle                   Colors(D)
setna                   Colors(D)
setnae                  Colors(D)
setnb                   Colors(D)
setnbe                  Colors(D)
setnc                   Colors(D)
setne                   Colors(D)
setng                   Colors(D)
setnge                  Colors(D)
setnl                   Colors(D)
setnle                  Colors(D)
setno                   Colors(D)
setnp                   Colors(D)
setns                   Colors(D)
setnz                   Colors(D)
seto                    Colors(D)
setp                    Colors(D)
setpe                   Colors(D)
setpo                   Colors(D)
sets                    Colors(D)
setz                    Colors(D)
sgdt                    Colors(D)
shl                     Colors(D)
shld                    Colors(D)
short                   Colors(B), NextWord
shr                     Colors(D)
shrd                    Colors(D)
si                      Colors(H)
sidt                    Colors(D)
size                    Colors(D)
sizestr                 Colors(D)
sldt                    Colors(D)
small                   Colors(E)
smallstack              Colors(D)
smart                   Colors(D)
smsw                    Colors(D)
sp                      Colors(H)
ss                      Colors(H)
stack                   Colors(D)
startupcode             Colors(D)
stc                     Colors(D)
std                     Colors(D)
sti                     Colors(D)
stos                    Colors(D)
stosb                   Colors(D)
stosd                   Colors(D)
stosw                   Colors(D)
str                     Colors(D)
struc                   Colors(D)
sub                     Colors(D)
substr                  Colors(D)
subttl                  Colors(D)
symtype                 Colors(D)
table                   Colors(D)
tblinit                 Colors(D)
tblinst                 Colors(D)
tblptr                  Colors(D)
tbyte                   Colors(B)
test                    Colors(D)
testflag                Colors(D)
this                    Colors(D)
title                   Colors(D)
tr1                     Colors(H)
tr2                     Colors(H)
tr3                     Colors(H)
tr4                     Colors(H)
tr5                     Colors(H)
tr6                     Colors(H)
tr7                     Colors(H)
type                    Colors(D)
typedef                 Colors(D)
udataseg                Colors(D)
ufardata                Colors(D)
union                   Colors(D)
unknown                 Colors(B)
updataseg               Colors(D)
use16                   Colors(C)
use32                   Colors(C)
usecs                   Colors(C)
useds                   Colors(C)
usees                   Colors(C)
usefs                   Colors(C)
usegs                   Colors(C)
uses                    Colors(C)
usess                   Colors(C)
verr                    Colors(D)
version                 Colors(C)
verw                    Colors(D)
wait                    Colors(D)
warn                    Colors(D)
wbinvd                  Colors(D)
while                   Colors(D)
width                   Colors(D)
word                    Colors(B)
wrmsr                   Colors(D)
xadd                    Colors(D)
xchg                    Colors(D)
xlat                    Colors(D)
xlatb                   Colors(D)
xor                     Colors(D)
{                       Colors(A), Terminator
|                       Colors(C), Terminator
}                       Colors(A), Terminator
~                       Colors(E), Terminator

//* [.bas.]

!                       Colors(C), Terminator
"                       Colors(D), Quote
#                       Colors(C), Terminator
$                       Colors(00)
%                       Colors(C), Terminator
&                       Colors(C), Terminator
'                       Colors(A), Terminator, ToEnd
(                       Colors(C), Terminator
)                       Colors(C), Terminator
*                       Colors(C), Terminator
+                       Colors(C), Terminator
,                       Colors(C), Terminator
-                       Colors(C), Terminator
.                       Colors(C), Terminator
/                       Colors(C), Terminator
0                       Colors(E,H,M), Numeric
1                       Colors(E,H,M), Numeric
2                       Colors(E,H,M), Numeric
3                       Colors(E,H,M), Numeric
4                       Colors(E,H,M), Numeric
5                       Colors(E,H,M), Numeric
6                       Colors(E,H,M), Numeric
7                       Colors(E,H,M), Numeric
8                       Colors(E,H,M), Numeric
9                       Colors(E,H,M), Numeric
:                       Colors(C), Terminator
;                       Colors(C), Terminator
<                       Colors(E), Terminator
=                       Colors(E), Terminator
>                       Colors(E), Terminator
\                       Colors(C), Terminator
^                       Colors(C), Terminator
abs                     Colors(D)
absolute                Colors(F)
access                  Colors(F)
and                     Colors(E)
any                     Colors(F)
append                  Colors(F)
as                      Colors(F)
asc                     Colors(D)
atn                     Colors(D)
base                    Colors(F)
beep                    Colors(F)
begintrans              Colors(F)
binary                  Colors(F)
bload                   Colors(F)
bof                     Colors(D)
bsave                   Colors(F)
call                    Colors(C, C, F), NextWord
case                    Colors(C)
ccur                    Colors(D)
chdrive                 Colors(F)
checkpoint              Colors(F)
cdbl                    Colors(D)
chain                   Colors(F)
chdir                   Colors(F)
chr$                    Colors(D)
cint                    Colors(D)
circle                  Colors(F)
clear                   Colors(F)
clng                    Colors(D)
close                   Colors(F)
cls                     Colors(F)
color                   Colors(F)
com                     Colors(F)
command$                Colors(D)
committrans             Colors(F)
common                  Colors(F)
const                   Colors(F)
cos                     Colors(D)
createindex             Colors(F)
csng                    Colors(D)
csrlin                  Colors(D)
curdir$                 Colors(D)
cvc                     Colors(D)
cvd                     Colors(D)
cvdmbf                  Colors(D)
cvi                     Colors(D)
cvl                     Colors(D)
cvs                     Colors(D)
cvsmbf                  Colors(D)
data                    Colors(F)
date$                   Colors(D)
declare                 Colors(F)
def                     Colors(F)
defcur                  Colors(F)
defdbl                  Colors(F)
defint                  Colors(F)
deflng                  Colors(F)
defsng                  Colors(F)
defstr                  Colors(F)
delete                  Colors(F)
deleteindex             Colors(F)
deletetable             Colors(F)
dim                     Colors(F)
dir$                    Colors(D)
do                      Colors(C)
double                  Colors(B)
draw                    Colors(F)
else                    Colors(E)
elseif                  Colors(E)
end                     Colors(C)
environ                 Colors(F)
environ$                Colors(D)
eof                     Colors(D)
eqv                     Colors(E)
erase                   Colors(F)
erdev                   Colors(D)
erdev$                  Colors(D)
erl                     Colors(D)
err                     Colors(D)
error                   Colors(F)
event                   Colors(F)
exit                    Colors(C)
exp                     Colors(D)
field                   Colors(F)
fileattr                Colors(D)
files                   Colors(F)
fix                     Colors(D)
fn                      Colors(F)
for                     Colors(C)
fre                     Colors(D)
freefile                Colors(D)
function                Colors(B, B, F), NextWord
get                     Colors(F)
getindex$               Colors(D)
gosub                   Colors(C, C, F), NextWord
goto                    Colors(C, C, F), NextWord
hex$                    Colors(D)
if                      Colors(E)
imp                     Colors(E)
inkey$                  Colors(D)
inp                     Colors(D)
input                   Colors(F)
input$                  Colors(D)
insert                  Colors(F)
instr                   Colors(D)
int                     Colors(D)
int86old                Colors(F)
int86xold               Colors(F)
integer                 Colors(B)
interrupt               Colors(F)
interruptx              Colors(F)
ioctl                   Colors(F)
ioctl$                  Colors(D)
is                      Colors(F)
key                     Colors(F)
kill                    Colors(F)
lbound                  Colors(D)
lcase$                  Colors(D)
left$                   Colors(D)
len                     Colors(D)
let                     Colors(F)
line                    Colors(F)
list                    Colors(F)
loc                     Colors(D)
locate                  Colors(F)
lock                    Colors(F)
lof                     Colors(D)
log                     Colors(D)
long                    Colors(B)
loop                    Colors(C)
lpos                    Colors(D)
lprint                  Colors(F)
lset                    Colors(F)
ltrim$                  Colors(D)
mid$                    Colors(D)
mkd$                    Colors(D)
mkdir                   Colors(F)
mkdmbf$                 Colors(D)
mki$                    Colors(D)
mkl$                    Colors(D)
mks$                    Colors(D)
mksmbf$                 Colors(D)
movefirst               Colors(F)
movelast                Colors(F)
movenext                Colors(F)
moveprevious            Colors(F)
name                    Colors(F)
next                    Colors(C)
not                     Colors(C)
oct$                    Colors(D)
off                     Colors(F)
on                      Colors(F)
open                    Colors(F)
option                  Colors(F)
or                      Colors(E)
out                     Colors(F)
output                  Colors(F)
paint                   Colors(F)
palette                 Colors(F)
pcopy                   Colors(F)
peek                    Colors(D)
pen                     Colors(F)
play                    Colors(F)
pmap                    Colors(D)
point                   Colors(D)
poke                    Colors(F)
pos                     Colors(D)
preset                  Colors(F)
print                   Colors(F)
pset                    Colors(F)
put                     Colors(F)
random                  Colors(F)
randomize               Colors(F)
read                    Colors(F)
redim                   Colors(F)
rem                     Colors(A), ToEnd
reset                   Colors(F)
restore                 Colors(F)
resume                  Colors(F)
retrieve                Colors(F)
return                  Colors(C)
right$                  Colors(D)
rmdir                   Colors(F)
rnd                     Colors(D)
rollback                Colors(F)
rset                    Colors(F)
rtrim$                  Colors(D)
run                     Colors(F)
sadd                    Colors(D)
savepoint               Colors(D)
screen                  Colors(F)
seek                    Colors(F)
seekeq                  Colors(F)
seekge                  Colors(F)
seekgt                  Colors(F)
seg                     Colors(F)
select                  Colors(C)
setindex                Colors(F)
setmem                  Colors(D)
sgn                     Colors(D)
shared                  Colors(D)
shell                   Colors(F)
signal                  Colors(F)
sin                     Colors(D)
single                  Colors(B)
sleep                   Colors(F)
sound                   Colors(F)
space$                  Colors(D)
spc                     Colors(D)
sqr                     Colors(D)
sseg                    Colors(D)
ssegadd                 Colors(D)
stack                   Colors(F)
static                  Colors(F)
step                    Colors(F)
stick                   Colors(D)
stop                    Colors(C)
str$                    Colors(D)
strig                   Colors(F)
string                  Colors(B)
string$                 Colors(D)
sub                     Colors(B, B, F), NextWord
swap                    Colors(F)
system                  Colors(C)
tab                     Colors(D)
tan                     Colors(D)
textcomp                Colors(D)
then                    Colors(E)
time$                   Colors(D)
timer                   Colors(F)
to                      Colors(F)
troff                   Colors(F)
tron                    Colors(F)
type                    Colors(B, B, F), NextWord
ubound                  Colors(D)
ucase$                  Colors(D)
uevent                  Colors(F)
unlock                  Colors(F)
until                   Colors(C)
update                  Colors(F)
using                   Colors(F)
val                     Colors(D)
varptr                  Colors(D)
varptr$                 Colors(D)
varseg                  Colors(D)
view                    Colors(F)
wait                    Colors(F)
wend                    Colors(C)
while                   Colors(C)
width                   Colors(F)
window                  Colors(F)
write                   Colors(F)
xor                     Colors(E)

//* [.bat.sys.]
!                       Colors(C), Terminator
"                       Colors(D), Quote
$                       Colors(C), Terminator
%                       Colors(C), Terminator
&                       Colors(C), Terminator
'                       Colors(D), Quote
(                       Colors(C), Terminator
)                       Colors(C), Terminator
*                       Colors(C), Terminator
+                       Colors(C), Terminator
,                       Colors(C), Terminator
-                       Colors(C), SingleChar, NextWord
.                       Colors(C)
/                       Colors(C, C, F), Terminator, NextWord
0                       Colors(E,H,M), Numeric
1                       Colors(E,H,M), Numeric
2                       Colors(E,H,M), Numeric
3                       Colors(E,H,M), Numeric
4                       Colors(E,H,M), Numeric
5                       Colors(E,H,M), Numeric
6                       Colors(E,H,M), Numeric
7                       Colors(E,H,M), Numeric
8                       Colors(E,H,M), Numeric
9                       Colors(E,H,M), Numeric
:                       Colors(C, E), SingleChar, NextWord
;                       Colors(C), Terminator
<                       Colors(C), Terminator
=                       Colors(C), Terminator
==                      Colors(E), DoubleChar
>                       Colors(C), Terminator
?                       Colors(C), Terminator
@                       Colors(C), Terminator
[                       Colors(C), Quote
\                       Colors(C), SingleChar
]                       Colors(C), Terminator
^                       Colors(C), Terminator
_                       Colors(00)
`                       Colors(C), Terminator
append                  Colors(B)
assign                  Colors(B)
attrib                  Colors(B)
b000                    Colors(C)
b0ff                    Colors(C)
b100                    Colors(C)
b1ff                    Colors(C)
b200                    Colors(C)
b2ff                    Colors(C)
b300                    Colors(C)
b3ff                    Colors(C)
b400                    Colors(C)
b4ff                    Colors(C)
b500                    Colors(C)
b5ff                    Colors(C)
b600                    Colors(C)
b6ff                    Colors(C)
b700                    Colors(C)
b7ff                    Colors(C)
b800                    Colors(C)
b8ff                    Colors(C)
b900                    Colors(C)
b9ff                    Colors(C)
ba00                    Colors(C)
backup                  Colors(B)
baff                    Colors(C)
bb00                    Colors(C)
bbff                    Colors(C)
bc00                    Colors(C)
bcff                    Colors(C)
bd00                    Colors(C)
bdff                    Colors(C)
be00                    Colors(C)
beep                    Colors(F)
beff                    Colors(C)
bf00                    Colors(C)
bfff                    Colors(C)
break                   Colors(F)
buffers                 Colors(F)
c000                    Colors(C)
c0ff                    Colors(C)
c100                    Colors(C)
c1ff                    Colors(C)
c200                    Colors(C)
c2ff                    Colors(C)
c300                    Colors(C)
c3ff                    Colors(C)
c400                    Colors(C)
c4ff                    Colors(C)
c500                    Colors(C)
c5ff                    Colors(C)
c600                    Colors(C)
c6ff                    Colors(C)
c700                    Colors(C)
c7ff                    Colors(C)
c800                    Colors(C)
c8ff                    Colors(C)
c900                    Colors(C)
c9ff                    Colors(C)
ca00                    Colors(C)
caff                    Colors(C)
call                    Colors(C)
cb00                    Colors(C)
cbff                    Colors(C)
cc00                    Colors(C)
ccff                    Colors(C)
cd                      Colors(F)
cd00                    Colors(C)
cdff                    Colors(C)
ce00                    Colors(C)
ceff                    Colors(C)
cf00                    Colors(C)
cfff                    Colors(C)
chcp                    Colors(F)
chdir                   Colors(F)
chkdsk                  Colors(B)
choice                  Colors(B)
cls                     Colors(F)
command                 Colors(B), WholeWord
comp                    Colors(B)
copy                    Colors(F)
country                 Colors(F)
ctty                    Colors(F)
cv                      Colors(B)
d000                    Colors(C)
d0ff                    Colors(C)
d100                    Colors(C)
d1ff                    Colors(C)
d200                    Colors(C)
d2ff                    Colors(C)
d300                    Colors(C)
d3ff                    Colors(C)
d400                    Colors(C)
d4ff                    Colors(C)
d500                    Colors(C)
d5ff                    Colors(C)
d600                    Colors(C)
d6ff                    Colors(C)
d700                    Colors(C)
d7ff                    Colors(C)
d800                    Colors(C)
d8ff                    Colors(C)
d900                    Colors(C)
d9ff                    Colors(C)
da00                    Colors(C)
daff                    Colors(C)
date                    Colors(F)
db00                    Colors(C)
dbff                    Colors(C)
dc00                    Colors(C)
dcff                    Colors(C)
dd00                    Colors(C)
ddff                    Colors(C)
de00                    Colors(C)
debug                   Colors(B)
deff                    Colors(C)
defrag                  Colors(B)
del                     Colors(F)
deltree                 Colors(F)
detach                  Colors(F)
device                  Colors(F)
devicehigh              Colors(F)
df00                    Colors(C)
dfff                    Colors(C)
dir                     Colors(F)
diskcomp                Colors(B)
diskcopy                Colors(B)
dos                     Colors(F), WholeWord
doskey                  Colors(B, B, F), NextWord
dosshell                Colors(B)
dpath                   Colors(F)
drivparm                Colors(F)
e000                    Colors(C)
e0ff                    Colors(C)
e100                    Colors(C)
e1ff                    Colors(C)
e200                    Colors(C)
e2ff                    Colors(C)
e300                    Colors(C)
e3ff                    Colors(C)
e400                    Colors(C)
e4ff                    Colors(C)
e500                    Colors(C)
e5ff                    Colors(C)
e600                    Colors(C)
e6ff                    Colors(C)
e700                    Colors(C)
e7ff                    Colors(C)
e800                    Colors(C)
e8ff                    Colors(C)
e900                    Colors(C)
e9ff                    Colors(C)
ea00                    Colors(C)
eaff                    Colors(C)
eb00                    Colors(C)
ebff                    Colors(C)
ec00                    Colors(C)
ecff                    Colors(C)
echo                    Colors(F)
ed00                    Colors(C)
edff                    Colors(C)
edit                    Colors(B)
edlin                   Colors(B)
ee00                    Colors(C)
eeff                    Colors(C)
ef00                    Colors(C)
efff                    Colors(C)
emm386                  Colors(B)
erase                   Colors(F)
errorlevel              Colors(F)
exe2bin                 Colors(B)
exist                   Colors(F)
exit                    Colors(F)
expand                  Colors(B)
f000                    Colors(C)
f0ff                    Colors(C)
f100                    Colors(C)
f1ff                    Colors(C)
f200                    Colors(C)
f2ff                    Colors(C)
f300                    Colors(C)
f3ff                    Colors(C)
f400                    Colors(C)
f4ff                    Colors(C)
f500                    Colors(C)
f5ff                    Colors(C)
f600                    Colors(C)
f6ff                    Colors(C)
f700                    Colors(C)
f7ff                    Colors(C)
f800                    Colors(C)
f8ff                    Colors(C)
f900                    Colors(C)
f9ff                    Colors(C)
fa00                    Colors(C)
faff                    Colors(C)
fasthelp                Colors(B)
fastopen                Colors(B)
fb00                    Colors(C)
fbff                    Colors(C)
fc                      Colors(F)
fc00                    Colors(C)
fcbs                    Colors(F)
fcff                    Colors(C)
fd00                    Colors(C)
fdff                    Colors(C)
fdisk                   Colors(B)
fe00                    Colors(C)
feff                    Colors(C)
ff00                    Colors(C)
ffff                    Colors(C)
files                   Colors(F)
find                    Colors(B)
for                     Colors(C)
format                  Colors(B)
goto                    Colors(C, C, F), NextWord
graftabl                Colors(B)
graphics                Colors(B)
help                    Colors(F)
high                    Colors(F)
if                      Colors(E)
in                      Colors(C)
include                 Colors(F)
input                   Colors(F)
install                 Colors(F)
interlnk                Colors(B)
intersvr                Colors(B)
join                    Colors(B)
keyb                    Colors(B)
keys                    Colors(F)
label                   Colors(B)
lastdrive               Colors(F)
lh                      Colors(F)
loadfix                 Colors(B)
loadhi                  Colors(F), WholeWord
loadhigh                Colors(F), WholeWord
log                     Colors(F)
md                      Colors(F)
mem                     Colors(B)
memmaker                Colors(B)
menu                    Colors(F)
menucolor               Colors(F)
menudefault             Colors(F)
menuitem                Colors(F)
mirror                  Colors(B)
mkdir                   Colors(F)
mode                    Colors(B)
more                    Colors(B)
mouse                   Colors(B)
move                    Colors(B)
msav                    Colors(B)
msbackup                Colors(B)
mscdex                  Colors(B)
msd                     Colors(B)
nlsfunc                 Colors(B)
not                     Colors(C)
numlock                 Colors(F)
off                     Colors(F)
path                    Colors(F)
pause                   Colors(F)
power                   Colors(B)
print                   Colors(B)
prompt                  Colors(F)
qbasic                  Colors(B)
qemm                    Colors(E), WholeWord
ram                     Colors(C)
rd                      Colors(F)
recover                 Colors(B)
rem                     Colors(A), ToEnd
ren                     Colors(F)
rename                  Colors(F)
replace                 Colors(B)
restore                 Colors(B)
rmdir                   Colors(F)
scandisk                Colors(B)
select                  Colors(B)
set                     Colors(F, F, E), NextWord
setver                  Colors(B)
share                   Colors(B)
shell                   Colors(F)
shift                   Colors(F)
smartdrv.exe            Colors(B), WholeWord
smartmon                Colors(B)
sort                    Colors(B)
stacker                 Colors(D), WholeWord
stacks                  Colors(F)
submenu                 Colors(F)
subst                   Colors(B)
switches                Colors(F)
sys                     Colors(B)
time                    Colors(F)
tree                    Colors(B)
truename                Colors(F)
type                    Colors(F)
undelete                Colors(B)
unformat                Colors(B)
ver                     Colors(F)
verify                  Colors(F)
vol                     Colors(F)
vsafe                   Colors(B)
xcopy                   Colors(B)
{                       Colors(C), Terminator
|                       Colors(C), Terminator
}                       Colors(C), Terminator
~                       Colors(C), Terminator

//* [.cbl.cob.]
"                       Colors(D), Quote
$                       Colors(C), Terminator
'                       Colors(D), Quote
(                       Colors(C), Terminator
)                       Colors(C), Terminator
*                       Colors(C, C, A), Terminator
+                       Colors(C), Terminator
,                       Colors(C), Terminator
-                       Colors(C), SingleChar
.                       Colors(C, D), Terminator, PrevWord
/                       Colors(C, C, A), Terminator
0                       Colors(E,H,M), Numeric
1                       Colors(E,H,M), Numeric
2                       Colors(E,H,M), Numeric
3                       Colors(E,H,M), Numeric
4                       Colors(E,H,M), Numeric
5                       Colors(E,H,M), Numeric
6                       Colors(E,H,M), Numeric
7                       Colors(E,H,M), Numeric
8                       Colors(E,H,M), Numeric
9                       Colors(E,H,M), Numeric
:                       Colors(C), Terminator
;                       Colors(C), Terminator
<                       Colors(E, B, B), Terminator, PrevWord, NextWord
=                       Colors(E, B, B), Terminator, PrevWord, NextWord
>                       Colors(E, B, B), Terminator, PrevWord, NextWord
accept                  Colors(F, F, B), NextWord
access                  Colors(F)
add                     Colors(F, F, B), NextWord
address                 Colors(D)
advancing               Colors(F)
after                   Colors(F)
all                     Colors(F)
alphabet                Colors(F)
alphabetic              Colors(F)
alphabetic-lower        Colors(F)
alphabetic-upper        Colors(F)
alphanumeric            Colors(F)
alphanumeric-edited     Colors(F)
also                    Colors(F)
alter                   Colors(F)
alternate               Colors(F)
and                     Colors(E)
any                     Colors(F)
apply                   Colors(F)
are                     Colors(F)
area                    Colors(F)
areas                   Colors(F)
ascending               Colors(F)
assign                  Colors(F, F, D), NextWord
at                      Colors(F)
author                  Colors(F)
basis                   Colors(D)
before                  Colors(F)
beginning               Colors(F)
binary                  Colors(F)
blank                   Colors(F)
block                   Colors(F)
bottom                  Colors(F)
by                      Colors(F, F, B), NextWord
call                    Colors(C, C, F), NextWord
cancel                  Colors(F)
cbl                     Colors(D), WholeWord
character               Colors(F)
characters              Colors(F)
class                   Colors(F)
close                   Colors(F, F, B), NextWord
cobol                   Colors(F)
code                    Colors(F)
code-set                Colors(F)
collating               Colors(F)
com-reg                 Colors(F)
comma                   Colors(F)
common                  Colors(F)
comp                    Colors(F)
comp-1                  Colors(F)
comp-2                  Colors(F)
comp-3                  Colors(F)
comp-4                  Colors(F)
computational           Colors(F)
computational-1         Colors(F)
computational-2         Colors(F)
computational-3         Colors(F)
computational-4         Colors(F)
compute                 Colors(F, F, B), NextWord
configuration           Colors(F)
contains                Colors(F)
content                 Colors(F)
continue                Colors(F)
control                 Colors(D)
converting              Colors(F)
copy                    Colors(D, D, F), NextWord
corr                    Colors(F)
corresponding           Colors(F)
count                   Colors(F)
crt                     Colors(F)
currency                Colors(F)
data                    Colors(F)
date                    Colors(F)
date-compiled           Colors(F)
date-written            Colors(F)
day                     Colors(F)
day-of-week             Colors(F)
dbcs                    Colors(F)
debug-contents          Colors(D)
debug-item              Colors(D)
debug-line              Colors(D)
debug-name              Colors(D)
debug-sub-1             Colors(D)
debug-sub-2             Colors(D)
debug-sub-3             Colors(D)
debugging               Colors(D)
decimal-point           Colors(F)
declaratives            Colors(F)
delete                  Colors(F)
delimited               Colors(F)
delimiter               Colors(F)
depending               Colors(F)
descending              Colors(F)
display                 Colors(F, F, B), NextWord
divide                  Colors(F, F, B), NextWord
division                Colors(F)
down                    Colors(F)
duplicates              Colors(F)
dynamic                 Colors(F)
egcs                    Colors(F)
eject                   Colors(D)
else                    Colors(E)
end                     Colors(F)
end-add                 Colors(F)
end-call                Colors(C)
end-compute             Colors(F)
end-delete              Colors(F)
end-divide              Colors(F)
end-evaluate            Colors(C)
end-if                  Colors(E)
end-multiply            Colors(F)
end-of-page             Colors(F)
end-perform             Colors(C)
end-read                Colors(F)
end-return              Colors(F)
end-rewrite             Colors(F)
end-search              Colors(C)
end-start               Colors(F)
end-string              Colors(F)
end-subtract            Colors(F)
end-unstring            Colors(F)
end-write               Colors(F)
ending                  Colors(F)
enter                   Colors(F)
entry                   Colors(F)
environment             Colors(F)
eop                     Colors(F)
equal                   Colors(E)
error                   Colors(C)
evaluate                Colors(C, C, F), NextWord
every                   Colors(F)
exception               Colors(F)
exit                    Colors(C)
extend                  Colors(F)
external                Colors(F)
false                   Colors(F)
fd                      Colors(F, F, D), NextWord
file                    Colors(F)
file-control            Colors(F)
filler                  Colors(F)
first                   Colors(F)
footing                 Colors(F)
for                     Colors(F)
from                    Colors(F, F, B), NextWord
giving                  Colors(F)
global                  Colors(F)
go                      Colors(C)
goback                  Colors(C)
greater                 Colors(E)
high-value              Colors(B)
high-values             Colors(B)
i-o                     Colors(F)
i-o-control             Colors(F)
id                      Colors(F)
identification          Colors(F)
if                      Colors(E, E, B), NextWord
in                      Colors(F)
index                   Colors(F)
indexed                 Colors(F)
initial                 Colors(F)
initialize              Colors(F)
input                   Colors(F, F, D), NextWord
input-output            Colors(F)
insert                  Colors(D)
inspect                 Colors(F)
installation            Colors(F)
into                    Colors(F, F, B), NextWord
invalid                 Colors(F)
is                      Colors(F), PrevWord, NextWord
just                    Colors(F)
justified               Colors(F)
kanji                   Colors(F)
key                     Colors(F, F, D), NextWord
label                   Colors(F)
leading                 Colors(F)
left                    Colors(F)
length                  Colors(D)
less                    Colors(E)
linage                  Colors(F)
linage-counter          Colors(D)
line                    Colors(F)
lines                   Colors(F)
linkage                 Colors(F)
lock                    Colors(F)
low-value               Colors(B)
low-values              Colors(B)
memory                  Colors(F)
merge                   Colors(F)
mode                    Colors(F, F, B), NextWord
modules                 Colors(F)
more-labels             Colors(F)
move                    Colors(F, F, B), NextWord
multiple                Colors(F)
multiply                Colors(F, F, B), NextWord
native                  Colors(F)
negative                Colors(F)
next                    Colors(F)
no                      Colors(F)
not                     Colors(C, C, B), NextWord
null                    Colors(F)
nulls                   Colors(F)
numeric                 Colors(F)
numeric-edited          Colors(F)
object-computer         Colors(F)
occurs                  Colors(F)
of                      Colors(F, F, B), NextWord
off                     Colors(F)
omitted                 Colors(F)
on                      Colors(F)
open                    Colors(F)
optional                Colors(F)
or                      Colors(E, E, B), NextWord
order                   Colors(F)
organization            Colors(F)
other                   Colors(F)
output                  Colors(F)
overflow                Colors(F)
packed-decimal          Colors(F)
padding                 Colors(F)
page                    Colors(F)
password                Colors(F)
perform                 Colors(C, C, F), NextWord
pic                     Colors(F, F, B), NextWord
picture                 Colors(F, F, B), NextWord
pointer                 Colors(F)
position                Colors(F)
positive                Colors(F)
procedure               Colors(F)
procedures              Colors(F)
proceed                 Colors(F)
process                 Colors(D)
processing              Colors(F)
program                 Colors(F)
program-id              Colors(F)
quote                   Colors(F)
quotes                  Colors(F)
random                  Colors(F)
read                    Colors(F)
ready                   Colors(D)
record                  Colors(F)
recording               Colors(F)
records                 Colors(F)
redefines               Colors(F)
reel                    Colors(F)
reference               Colors(F, F, B), NextWord
references              Colors(F)
relative                Colors(F)
release                 Colors(F)
reload                  Colors(D)
remainder               Colors(F)
removal                 Colors(F)
renames                 Colors(F)
replace                 Colors(D)
replacing               Colors(F)
rerun                   Colors(F)
reserve                 Colors(F)
reset                   Colors(D)
return                  Colors(F)
returning               Colors(F, F, B), NextWord
return-code             Colors(D)
reverse                 Colors(F)
rewind                  Colors(F)
rewrite                 Colors(F)
right                   Colors(F)
rounded                 Colors(F)
run                     Colors(F)
same                    Colors(F)
sd                      Colors(F)
search                  Colors(C)
section                 Colors(F, D), PrevWord
security                Colors(F)
segment-limit           Colors(F)
select                  Colors(F, F, D), NextWord
sentence                Colors(F)
separate                Colors(F)
sequence                Colors(F)
sequential              Colors(F)
service                 Colors(D)
set                     Colors(F, F, B), NextWord
shift-in                Colors(D)
shift-out               Colors(D)
sign                    Colors(D)
size                    Colors(F)
skip1                   Colors(D)
skip2                   Colors(D)
skip3                   Colors(D)
sort                    Colors(F)
sort-control            Colors(D)
sort-core-size          Colors(D)
sort-file-size          Colors(D)
sort-merge              Colors(F)
sort-message            Colors(D)
sort-mode-size          Colors(D)
sort-return             Colors(D)
source-computer         Colors(F)
space                   Colors(F)
spaces                  Colors(F)
special-names           Colors(F)
standard                Colors(F)
standard-1              Colors(F)
standard-2              Colors(F)
start                   Colors(F)
status                  Colors(F)
stop                    Colors(C)
string                  Colors(F, F, E), NextWord
subtract                Colors(F, F, B), NextWord
suppress                Colors(F)
symbolic                Colors(F)
sync                    Colors(F)
synchronized            Colors(F)
tally                   Colors(D)
tallying                Colors(F)
tape                    Colors(F)
test                    Colors(F)
than                    Colors(E)
then                    Colors(E)
through                 Colors(F)
thru                    Colors(F)
time                    Colors(F)
times                   Colors(F)
title                   Colors(D)
to                      Colors(F, F, B), NextWord
top                     Colors(F)
trace                   Colors(F)
trailing                Colors(F)
true                    Colors(F)
unit                    Colors(F)
unstring                Colors(F, F, B), NextWord
until                   Colors(C, C, B), NextWord
up                      Colors(F)
upon                    Colors(F, F, B), NextWord
usage                   Colors(F)
use                     Colors(D)
using                   Colors(F)
value                   Colors(F, F, B), NextWord
values                  Colors(F)
varying                 Colors(C, C, B), NextWord
when                    Colors(C, C, F), NextWord
when-compiled           Colors(D)
with                    Colors(F)
words                   Colors(F)
working-storage         Colors(F)
write                   Colors(F, F, E), NextWord
write-only              Colors(F)
zero                    Colors(B)
zeroes                  Colors(B)
zeros                   Colors(B)

//* [.c.cpp.h.hpp.]
//* [Case Sensitive]
!                       Colors(C), Terminator
!=                      Colors(D), DoubleChar
"                       Colors(D), Quote
#define                 Colors(C), NextWord
#elif                   Colors(C)
#else                   Colors(C)
#endif                  Colors(C)
#error                  Colors(C)
#if                     Colors(C), NextWord
#ifdef                  Colors(C), NextWord
#ifndef                 Colors(C), NextWord
#include                Colors(C), NextWord
#pragma                 Colors(C), NextWord
#undef                  Colors(C)
%                       Colors(F), Terminator
%=                      Colors(D), DoubleChar
&                       Colors(F), Terminator
&&                      Colors(D), DoubleChar
&=                      Colors(D), DoubleChar
'                       Colors(D), Quote
(                       Colors(C), Terminator
)                       Colors(C), Terminator
*                       Colors(F), Terminator
*/                      Colors(A), DoubleChar, ToStart
*=                      Colors(D), DoubleChar
+                       Colors(C), Terminator
++                      Colors(D), DoubleChar
+=                      Colors(D), DoubleChar
,                       Colors(F), Terminator
-                       Colors(C), Terminator
--                      Colors(D), DoubleChar
-=                      Colors(D), DoubleChar
->                      Colors(D, F, F), DoubleChar, PrevWord, NextWord
.                       Colors(C, F, F), Terminator, PrevWord, NextWord
/                       Colors(F), Terminator
/**/                    Colors(A), DoubleChar, Quote
//                      Colors(A), DoubleChar, ToEnd
/=                      Colors(D), DoubleChar
0                       Colors(E,H,M), Numeric
1                       Colors(E,H,M), Numeric
2                       Colors(E,H,M), Numeric
3                       Colors(E,H,M), Numeric
4                       Colors(E,H,M), Numeric
5                       Colors(E,H,M), Numeric
6                       Colors(E,H,M), Numeric
7                       Colors(E,H,M), Numeric
8                       Colors(E,H,M), Numeric
9                       Colors(E,H,M), Numeric
:                       Colors(B), Terminator, PrevWord
::                      Colors(E), DoubleChar
;                       Colors(E), Terminator
<                       Colors(F), Terminator
<<                      Colors(D), DoubleChar
<=                      Colors(D), DoubleChar
=                       Colors(E), Terminator
==                      Colors(D), DoubleChar
>                       Colors(F), Terminator
>=                      Colors(D), DoubleChar
>>                      Colors(D), DoubleChar
?                       Colors(C), Terminator
FIXED                   Colors(F), NextWord
FP_                     Colors(F), WholeWord
False                   Colors(F)
GHND                    Colors(B)
GMEM_                   Colors(B), WholeWord
HANDLE                  Colors(B), NextWord
HGLOBAL                 Colors(B), NextWord
MK_                     Colors(F), WholeWord
NULL                    Colors(C)
True                    Colors(E)
[                       Colors(D, F), Terminator, PrevWord
]                       Colors(D), Terminator
^                       Colors(F), Terminator
^=                      Colors(D), DoubleChar
_                       Colors(00), Inclusive
_AH                     Colors(E)
_AL                     Colors(E)
_AX                     Colors(E)
_BH                     Colors(E)
_BL                     Colors(E)
_BP                     Colors(E)
_BX                     Colors(E)
_CH                     Colors(E)
_CL                     Colors(E)
_CS                     Colors(E)
_CX                     Colors(E)
_DH                     Colors(E)
_DI                     Colors(E)
_DL                     Colors(E)
_DS                     Colors(E)
_DX                     Colors(E)
_EAX                    Colors(E)
_EBP                    Colors(E)
_EBX                    Colors(E)
_ECX                    Colors(E)
_EDI                    Colors(E)
_EDX                    Colors(E)
_ES                     Colors(E)
_ESI                    Colors(E)
_ESP                    Colors(E)
_FS                     Colors(E)
_GS                     Colors(E)
_SI                     Colors(E)
_SP                     Colors(E)
_SS                     Colors(E)
__DPMI16__              Colors(B)
__DPMI32__              Colors(B)
__FLAT__                Colors(B)
__asm                   Colors(C)
__cdecl                 Colors(C)
__cs                    Colors(C)
__declspec              Colors(C)
__ds                    Colors(C)
__es                    Colors(C)
__except                Colors(C)
__export                Colors(C)
__far                   Colors(C)
__fastcall              Colors(C)
__fastthis              Colors(C)
__finally               Colors(C)
__huge                  Colors(C)
__import                Colors(C)
__interrupt             Colors(C)
__loadds                Colors(C)
__near                  Colors(C)
__pascal                Colors(C)
__rtti                  Colors(C)
__saveregs              Colors(C)
__seg                   Colors(C)
__slowthis              Colors(C)
__ss                    Colors(C)
__stdcall               Colors(C)
__syscall               Colors(C)
__thread                Colors(C)
__try                   Colors(C)
_asm                    Colors(E)
_cdecl                  Colors(E)
_cs                     Colors(E)
_ds                     Colors(E)
_es                     Colors(E)
_export                 Colors(E)
_far                    Colors(E)
_fastcall               Colors(E)
_huge                   Colors(E)
_import                 Colors(E)
_interrupt              Colors(E)
_loadds                 Colors(E)
_near                   Colors(E)
_pascal                 Colors(E)
_saveregs               Colors(E)
_seg                    Colors(E)
_ss                     Colors(E)
asm                     Colors(B)
auto                    Colors(B)
bool                    Colors(B)
break                   Colors(B)
case                    Colors(B)
catch                   Colors(B)
cdecl                   Colors(E)
char                    Colors(E)
class                   Colors(B)
const                   Colors(B)
const_cast              Colors(E)
continue                Colors(B)
default                 Colors(B)
delete                  Colors(B)
defined                 Colors(C)
do                      Colors(B)
double                  Colors(E)
dynamic_cast            Colors(E)
else                    Colors(B)
enum                    Colors(B)
extern                  Colors(B)
false                   Colors(C)
far                     Colors(B)
float                   Colors(E)
for                     Colors(B)
friend                  Colors(B)
goto                    Colors(B)
huge                    Colors(E)
if                      Colors(B)
inline                  Colors(B)
int                     Colors(B)
interrupt               Colors(B)
long                    Colors(E)
main                    Colors(B)
mutable                 Colors(B)
namespace               Colors(B)
near                    Colors(B)
new                     Colors(B)
offsetof                Colors(C)
operator                Colors(B)
pascal                  Colors(C)
private                 Colors(B)
protected               Colors(B)
public                  Colors(B)
register                Colors(B)
reinterpret_cast        Colors(E)
return                  Colors(B)
short                   Colors(E)
signed                  Colors(E)
sizeof                  Colors(B)
static                  Colors(B)
static_cast             Colors(E)
struct                  Colors(E)
switch                  Colors(B)
template                Colors(E)
this                    Colors(B)
throw                   Colors(B)
true                    Colors(C)
try                     Colors(B)
typedef                 Colors(B)
typeid                  Colors(B)
union                   Colors(E)
unsigned                Colors(E)
using                   Colors(B)
virtual                 Colors(B)
void                    Colors(E)
volatile                Colors(B)
wchar_t                 Colors(E)
while                   Colors(B)
{                       Colors(C), Terminator
|                       Colors(F), Terminator
|=                      Colors(D), DoubleChar
||                      Colors(D), DoubleChar
}                       Colors(C), Terminator
~                       Colors(F), Terminator

//* [.def.]
"                       Colors(H), Quote
'                       Colors(H), Quote
.                       Colors(B), SingleChar
0                       Colors(E,H,M), Numeric
1                       Colors(E,H,M), Numeric
2                       Colors(E,H,M), Numeric
3                       Colors(E,H,M), Numeric
4                       Colors(E,H,M), Numeric
5                       Colors(E,H,M), Numeric
6                       Colors(E,H,M), Numeric
7                       Colors(E,H,M), Numeric
8                       Colors(E,H,M), Numeric
9                       Colors(E,H,M), Numeric
;                       Colors(A), ToEnd
=                       Colors(E), Terminator
@                       Colors(E), Terminator
CLASS                   Colors(C)
CODE                    Colors(C)
DATA                    Colors(C)
DESCRIPTION             Colors(C)
DISCARDABLE             Colors(D)
EXECUTE                 Colors(D)
EXETYPE                 Colors(C)
EXPORTS                 Colors(C)
FIXED                   Colors(D)
HEAPSIZE                Colors(C)
IMPORTS                 Colors(C)
LIBRARY                 Colors(C)
LOADONCALL              Colors(D)
MOVEABLE                Colors(D)
MULTIPLE                Colors(D)
NAME                    Colors(C)
NODATA                  Colors(D)
NONDISCARDABLE          Colors(D)
NONE                    Colors(D)
NONSHARED               Colors(D)
NOTWINDOWCOMPAT         Colors(D)
PRELOAD                 Colors(D)
READ                    Colors(D)
RESIDENTNAME            Colors(C)
SECTIONS                Colors(C)
SEGMENTS                Colors(C)
SHARED                  Colors(D)
SINGLE                  Colors(D)
STACKSIZE               Colors(C)
STUB                    Colors(C)
SUBSYSTEM               Colors(C)
WINDOWS                 Colors(D)
WINDOWAPI               Colors(D)
WINDOWCOMPAT            Colors(D)
WRITE                   Colors(D)

//* [.for.]
$debug                  Colors(B)
$decmath                Colors(B)
$do66                   Colors(B)
$floatcalls             Colors(B)
$include                Colors(B)
$large                  Colors(B)
$linesize               Colors(B)
$list                   Colors(B)
$message                Colors(B)
$nodebug                Colors(B)
$nofloatcalls           Colors(B)
$nolist                 Colors(B)
$notlarge               Colors(B)
$notstrict              Colors(B)
$page                   Colors(B)
$pagesize               Colors(B)
$storage                Colors(B)
$strict                 Colors(B)
$subtitle               Colors(B)
$title                  Colors(B)
'                       Colors(D), Quote
(                       Colors(C, F), Terminator, PrevWord
)                       Colors(C), Terminator
*                       Colors(C, C, A), Terminator
+                       Colors(C), Terminator
,                       Colors(C), Terminator
-                       Colors(C), Terminator
.                       Colors(C), Terminator
/                       Colors(C), Terminator
0                       Colors(E,H,M), Numeric
1                       Colors(E,H,M), Numeric
2                       Colors(E,H,M), Numeric
3                       Colors(E,H,M), Numeric
4                       Colors(E,H,M), Numeric
5                       Colors(E,H,M), Numeric
6                       Colors(E,H,M), Numeric
7                       Colors(E,H,M), Numeric
8                       Colors(E,H,M), Numeric
9                       Colors(E,H,M), Numeric
=                       Colors(C), Terminator
abs                     Colors(D)
access                  Colors(F)
acos                    Colors(D)
aimag                   Colors(D)
aint                    Colors(D)
alog                    Colors(D)
alog10                  Colors(D)
amax0                   Colors(D)
amax1                   Colors(D)
amin0                   Colors(D)
amin1                   Colors(D)
amod                    Colors(D)
and                     Colors(E)
anint                   Colors(D)
asin                    Colors(D)
asinh                   Colors(D)
assign                  Colors(F)
atan                    Colors(D)
atan2                   Colors(D)
backspace               Colors(F)
block                   Colors(F)
cabs                    Colors(D)
call                    Colors(C, C, F), NextWord
case                    Colors(C)
ccos                    Colors(D)
cdabs                   Colors(D)
cdcos                   Colors(D)
cdexp                   Colors(D)
cdlog                   Colors(D)
cdsin                   Colors(D)
cdsqrt                  Colors(D)
cexp                    Colors(D)
char                    Colors(D)
character               Colors(B)
clog                    Colors(D)
close                   Colors(F)
cmplx                   Colors(D)
common                  Colors(F)
complex                 Colors(B)
conjg                   Colors(D)
continue                Colors(C)
cos                     Colors(D)
cosh                    Colors(D)
csin                    Colors(D)
csqrt                   Colors(D)
dabs                    Colors(D)
dacos                   Colors(D)
dasin                   Colors(D)
data                    Colors(F)
datan                   Colors(D)
datan2                  Colors(D)
dble                    Colors(D)
dcmplx                  Colors(D)
dconjg                  Colors(D)
dcos                    Colors(D)
dcosh                   Colors(D)
ddim                    Colors(D)
dexp                    Colors(D)
dim                     Colors(D)
dimag                   Colors(D)
dimension               Colors(F)
dint                    Colors(D)
dlog                    Colors(D)
dlog10                  Colors(D)
dmax1                   Colors(D)
dmin1                   Colors(D)
dmod                    Colors(D)
dnint                   Colors(D)
do                      Colors(C)
double                  Colors(B)
dprod                   Colors(D)
dreal                   Colors(D)
dsign                   Colors(D)
dsin                    Colors(D)
dsinh                   Colors(D)
dsqrt                   Colors(D)
dtan                    Colors(D)
dtanh                   Colors(D)
else                    Colors(E)
elseif                  Colors(E)
end                     Colors(C)
enddo                   Colors(C)
endfile                 Colors(F)
endif                   Colors(E)
eof                     Colors(D)
eq                      Colors(E)
equivalence             Colors(F)
eqv                     Colors(E)
err                     Colors(F)
exp                     Colors(D)
external                Colors(F)
false                   Colors(C)
file                    Colors(F)
float                   Colors(D)
form                    Colors(F)
format                  Colors(F)
function                Colors(B, B, F), NextWord
ge                      Colors(E)
goto                    Colors(C)
gt                      Colors(E)
iabs                    Colors(D)
ichar                   Colors(D)
idim                    Colors(D)
idint                   Colors(D)
idnint                  Colors(D)
if                      Colors(E)
ifix                    Colors(D)
implicit                Colors(F)
inquire                 Colors(F)
int                     Colors(D)
integer                 Colors(B)
intrinsic               Colors(F)
iostat                  Colors(F)
isign                   Colors(D)
le                      Colors(E)
lge                     Colors(D)
lgt                     Colors(D)
lle                     Colors(D)
llt                     Colors(D)
log                     Colors(D)
log10                   Colors(D)
logical                 Colors(B)
lt                      Colors(E)
max                     Colors(D)
max0                    Colors(D)
max1                    Colors(D)
min                     Colors(D)
min0                    Colors(D)
min1                    Colors(D)
mod                     Colors(D)
ne                      Colors(E)
neqv                    Colors(E)
nint                    Colors(D)
not                     Colors(C)
open                    Colors(F)
or                      Colors(E)
parameter               Colors(F)
pause                   Colors(F)
precision               Colors(B)
print                   Colors(F)
program                 Colors(B, B, F), NextWord
read                    Colors(F)
real                    Colors(B)
rec                     Colors(F)
recl                    Colors(F)
return                  Colors(C)
rewind                  Colors(F)
save                    Colors(F)
sign                    Colors(D)
sin                     Colors(D)
sngl                    Colors(D)
sqrt                    Colors(D)
start                   Colors(C)
status                  Colors(F)
stop                    Colors(C)
subroutine              Colors(B, B, F), NextWord
tan                     Colors(D)
tanh                    Colors(D)
then                    Colors(E)
to                      Colors(F)
true                    Colors(B)
unit                    Colors(F)
while                   Colors(C)
write                   Colors(F)

//* [.mak.]
!$d                     Colors(C)
!cmdswitches            Colors(C)
!elif                   Colors(C)
!else                   Colors(C)
!endif                  Colors(C)
!error                  Colors(C)
!if                     Colors(C)
!ifdef                  Colors(C)
!ifndef                 Colors(C)
!include                Colors(C)
!message                Colors(C)
!undef                  Colors(C)
"                       Colors(D), Quote
#                       Colors(A), Terminator, ToEnd
$                       Colors(C), SingleChar, NextWord
$&                      Colors(C), DoubleChar
$*                      Colors(C), DoubleChar, NextWord
$.                      Colors(C), DoubleChar
$:                      Colors(C), DoubleChar
$<                      Colors(C), DoubleChar
$?                      Colors(C), DoubleChar
$@                      Colors(C), DoubleChar
$d                      Colors(C)
&                       Colors(F), SingleChar
&&                      Colors(F), DoubleChar
(                       Colors(C), Terminator
)                       Colors(C), Terminator
*                       Colors(F)
.asm                    Colors(B)
.autodepend             Colors(C)
.cacheautodepend        Colors(C)
.cpp                    Colors(B)
.c                      Colors(B)
.exe                    Colors(B)
.ignore                 Colors(C)
.noIgnore               Colors(C)
.noautodepend           Colors(C)
.nocacheautodepend      Colors(C)
.nosilent               Colors(C)
.noswap                 Colors(C)
.obj                    Colors(B)
.path.                  Colors(C), WholeWord
.precious               Colors(C)
.rc                     Colors(B)
.res                    Colors(B)
.silent                 Colors(C)
.suffixes               Colors(C)
.swap                   Colors(C)
.                       Colors(00), Terminator
0                       Colors(E,H,M), Numeric
1                       Colors(E,H,M), Numeric
2                       Colors(E,H,M), Numeric
3                       Colors(E,H,M), Numeric
4                       Colors(E,H,M), Numeric
5                       Colors(E,H,M), Numeric
6                       Colors(E,H,M), Numeric
7                       Colors(E,H,M), Numeric
8                       Colors(E,H,M), Numeric
9                       Colors(E,H,M), Numeric
:                       Colors(B), Terminator
<                       Colors(F), SingleChar
<<                      Colors(F), DoubleChar
=                       Colors(F), Terminator
>                       Colors(F), Terminator
>>                      Colors(F), DoubleChar
AS                      Colors(H)
BCROOT                  Colors(H)
CC                      Colors(H)
DEBUG                   Colors(H)
DOS16                   Colors(H)
DOS32                   Colors(H)
LIB                     Colors(H)
LINK                    Colors(H)
MAKE                    Colors(H)
MAKEDIR                 Colors(H)
MAKEFLAGS               Colors(H)
OVERLAY                 Colors(H)
RC                      Colors(H)
TASM                    Colors(H), WholeWord
__MAKE__                Colors(H)
__MSDOS__               Colors(H)

//* [.mod.]
//* [Case Sensitive]
"                       Colors(D), Quote
#                       Colors(E), Terminator
&                       Colors(E), Terminator
'                       Colors(D), Quote
(                       Colors(C, F), Terminator, PrevWord
(**)                    Colors(A), DoubleChar, Quote
)                       Colors(C), Terminator
*                       Colors(C), Terminator
*)                      Colors(A), DoubleChar, ToStart
+                       Colors(C), Terminator
,                       Colors(C), Terminator
-                       Colors(C), Terminator
.                       Colors(C), Terminator
/                       Colors(C), Terminator
0                       Colors(E,H,M), Numeric
1                       Colors(E,H,M), Numeric
2                       Colors(E,H,M), Numeric
3                       Colors(E,H,M), Numeric
4                       Colors(E,H,M), Numeric
5                       Colors(E,H,M), Numeric
6                       Colors(E,H,M), Numeric
7                       Colors(E,H,M), Numeric
8                       Colors(E,H,M), Numeric
9                       Colors(E,H,M), Numeric
:                       Colors(C), Terminator
:=                      Colors(E), DoubleChar
;                       Colors(C), Terminator
<                       Colors(E), Terminator
=                       Colors(E), Terminator
>                       Colors(E), Terminator
ABS                     Colors(D)
ADDRESS                 Colors(B)
ADR                     Colors(F)
ALLOCATE                Colors(F)
AND                     Colors(E)
ARRAY                   Colors(B)
Again                   Colors(F)
Area                    Colors(F)
Assign                  Colors(F)
AssignEOWAction         Colors(F)
AssignFont              Colors(F)
AssignRestoreProC       Colors(F)
Available               Colors(F)
BEGIN                   Colors(C)
BITSET                  Colors(B)
BOOLEAN                 Colors(B)
BY                      Colors(F)
Background              Colors(F)
BusyRead                Colors(F)
CAP                     Colors(D)
CARDINAL                Colors(B)
CASE                    Colors(C)
CHAR                    Colors(B)
CHR                     Colors(D)
CONST                   Colors(F)
Circle                  Colors(F)
Clear                   Colors(F)
Close                   Colors(F)
CloseGraphicWindOW      Colors(F)
CloseInput              Colors(F)
CloseOutput             Colors(F)
CloseTextWindow         Colors(F)
CloseWindow             Colors(F)
Command                 Colors(F)
CopyArea                Colors(F)
Create                  Colors(F)
CursorMouse             Colors(F)
DEALLOCATE              Colors(F)
DEC                     Colors(D)
DEFINITION              Colors(F)
DIV                     Colors(F)
DO                      Colors(C)
Doio                    Colors(F)
Done                    Colors(F)
Dot                     Colors(F)
DrawLine                Colors(F)
DrawTitle               Colors(F)
ELSE                    Colors(E)
ELSIF                   Colors(E)
END                     Colors(C, C, F), NextWord
EOL                     Colors(F)
EXCL                    Colors(D)
EXIT                    Colors(C)
EXPORT                  Colors(F)
EraseCursor             Colors(F)
FALSE                   Colors(C)
FLOAT                   Colors(D)
FOR                     Colors(C)
FROM                    Colors(F), NextWord
File                    Colors(F)
FileSystem              Colors(F)
FirstWindow             Colors(F)
Flag                    Colors(F)
FlagSet                 Colors(F)
GetPos                  Colors(F)
Getmouse                Colors(F)
GraphicWindows          Colors(F)
HALT                    Colors(D)
HIGH                    Colors(D)
IF                      Colors(E)
IMPLEMENTATION          Colors(F)
IMPORT                  Colors(F)
IN                      Colors(F)
INC                     Colors(D)
INCL                    Colors(D)
INTEGER                 Colors(B)
IOTRANSFER              Colors(F)
IdentifyPos             Colors(F)
InOut                   Colors(F)
Invert                  Colors(F)
LONGINT                 Colors(B)
LONGREAL                Colors(B)
LOOP                    Colors(C)
LastWindow              Colors(F)
Length                  Colors(F)
Lookup                  Colors(F)
MAX                     Colors(D)
MIN                     Colors(D)
ML                      Colors(F)
MM                      Colors(F)
MOD                     Colors(F)
MODULE                  Colors(B, B, F), NextWord
MR                      Colors(F)
MathLib0                Colors(F)
Menu                    Colors(F)
Mode                    Colors(F)
Move                    Colors(F)
MoveCursor              Colors(F)
MoveTo                  Colors(F)
NEWPROCESS              Colors(F)
NIL                     Colors(D)
NOT                     Colors(C)
ODD                     Colors(D)
OF                      Colors(F)
OR                      Colors(E)
ORD                     Colors(D)
OnTop                   Colors(F)
OpenGraphicWindoW       Colors(F)
OpenInput               Colors(F)
OpenOutput              Colors(F)
OpenTextWindow          Colors(F)
OpenWindow              Colors(F)
POINTER                 Colors(F)
PROC                    Colors(B)
PROCEDURE               Colors(B, B, F), NextWord
PROCESS                 Colors(B)
Pattern                 Colors(F)
PlaceOnBottom           Colors(F)
PlaceOnTop              Colors(F)
QUALIFIED               Colors(F)
REAL                    Colors(B)
RECORD                  Colors(B)
REPEAT                  Colors(C)
RETURN                  Colors(C)
Read                    Colors(F)
ReadAgain               Colors(F)
ReadCard                Colors(F)
ReadChar                Colors(F)
ReadInt                 Colors(F)
ReadMouse               Colors(F)
ReadProc                Colors(F)
ReadReal                Colors(F)
ReadStrng               Colors(F)
ReadWord                Colors(F)
RealInOut               Colors(F)
RedefGraphicWindOW      Colors(F)
RedefTextWindow         Colors(F)
RedefineWindow          Colors(F)
Rename                  Colors(F)
Reset                   Colors(F)
ResetPattern            Colors(F)
Response                Colors(F)
RestoreProc             Colors(F)
SET                     Colors(B)
SIZE                    Colors(D)
SYSTEM                  Colors(F)
ScrollUp                Colors(F)
SetCaret                Colors(F)
SetMode                 Colors(F)
SetModify               Colors(F)
SetMouse                Colors(F)
SetOpen                 Colors(F)
SetPattern              Colors(F)
SetPen                  Colors(F)
SetPos                  Colors(F)
SetRead                 Colors(F)
SetWrite                Colors(F)
ShowMenu                Colors(F)
Storage                 Colors(F)
THEN                    Colors(E)
TO                      Colors(F)
TRANSFER                Colors(F)
TRUE                    Colors(B)
TSIZE                   Colors(F)
TYPE                    Colors(F)
Terminal                Colors(F)
TextWindows             Colors(F)
Turn                    Colors(F)
TurnTo                  Colors(F)
UNTIL                   Colors(C)
UpWindow                Colors(F)
VAL                     Colors(D)
VAR                     Colors(F)
WHILE                   Colors(C)
WITH                    Colors(C)
WORD                    Colors(B)
Window                  Colors(F)
Windows                 Colors(F)
Write                   Colors(F)
WriteCard               Colors(F)
WriteChar               Colors(F)
WriteHex                Colors(F)
WriteInt                Colors(F)
WriteLn                 Colors(F)
WriteOct                Colors(F)
WriteReal               Colors(F)
WriteRealOct            Colors(F)
WriteString             Colors(F)
WriteWord               Colors(F)
[                       Colors(C), Terminator
]                       Colors(C), Terminator
^                       Colors(C), Terminator
arctan                  Colors(F)
cos                     Colors(F)
entier                  Colors(F)
exp                     Colors(F)
ln                      Colors(F)
sin                     Colors(F)
sqrt                    Colors(F)
termCH                  Colors(F)
{                       Colors(C), Terminator
|                       Colors(C), Terminator
}                       Colors(C), Terminator
~                       Colors(C), Terminator

//* [.pas.]
"                       Colors(D), Quote
$                       Colors(B), Terminator, NextWord
&                       Colors(C), Terminator
'                       Colors(D), Quote
(                       Colors(C), Terminator
(**)                    Colors(A), DoubleChar, Quote
)                       Colors(C), Terminator
*                       Colors(E), Terminator
*)                      Colors(A), DoubleChar, ToStart
+                       Colors(E), Terminator
,                       Colors(C), Terminator
-                       Colors(F), Terminator
.                       Colors(F), Terminator, PrevWord, NextWord
/                       Colors(D), Terminator
0                       Colors(E,H,M), Numeric
1                       Colors(E,H,M), Numeric
2                       Colors(E,H,M), Numeric
3                       Colors(E,H,M), Numeric
4                       Colors(E,H,M), Numeric
5                       Colors(E,H,M), Numeric
6                       Colors(E,H,M), Numeric
7                       Colors(E,H,M), Numeric
8                       Colors(E,H,M), Numeric
9                       Colors(E,H,M), Numeric
:                       Colors(F), Terminator, PrevWord
:=                      Colors(C, B), DoubleChar, PrevWord
;                       Colors(D), Terminator
<                       Colors(F), Terminator
<=                      Colors(E), DoubleChar
=                       Colors(E), Terminator
==                      Colors(D), DoubleChar
>                       Colors(F), Terminator
>=                      Colors(E), DoubleChar
@                       Colors(F), SingleChar, WholeWord
@code                   Colors(B)
@data                   Colors(B)
@result                 Colors(B)
[                       Colors(D), Terminator
\                       Colors(C), Terminator
]                       Colors(D), Terminator
^                       Colors(E), Terminator
^.                      Colors(F), DoubleChar, WholeWord
_                       Colors(00)
aaa                     Colors(F)
aad                     Colors(F)
aam                     Colors(F)
aas                     Colors(F)
abs                     Colors(F)
absolute                Colors(F)
abstract                Colors(F)
adc                     Colors(F)
add                     Colors(F)
addr                    Colors(F)
ah                      Colors(E)
al                      Colors(E)
allocmultisel           Colors(F)
and                     Colors(F)
append                  Colors(F)
arc                     Colors(F)
arctan                  Colors(F)
arpl                    Colors(B)
array                   Colors(B)
asm                     Colors(D)
assembler               Colors(F)
assign                  Colors(F)
assigncrt               Colors(F)
assigned                Colors(F)
assume                  Colors(E)
ax                      Colors(E)
bar                     Colors(F)
bar3d                   Colors(F)
begin                   Colors(D)
bh                      Colors(E)
bl                      Colors(E)
blockread               Colors(F)
blockwrite              Colors(F)
boolean                 Colors(B)
bound                   Colors(F)
bp                      Colors(C)
break                   Colors(B)
bx                      Colors(E)
byte                    Colors(B)
bytebool                Colors(B)
call                    Colors(E), NextWord
case                    Colors(E)
cbw                     Colors(F)
ch                      Colors(E)
char                    Colors(E)
chdir                   Colors(F)
chr                     Colors(F)
circle                  Colors(F)
cl                      Colors(E)
clc                     Colors(F)
cld                     Colors(F)
cleardevice             Colors(F)
clearviewport           Colors(F)
cli                     Colors(F)
close                   Colors(F)
closegraph              Colors(F)
clreol                  Colors(F)
clrscr                  Colors(F)
cmc                     Colors(F)
cmp                     Colors(F)
cmpsb                   Colors(F)
cmpsw                   Colors(F)
code_seg                Colors(F)
comp                    Colors(F)
concat                  Colors(F)
const                   Colors(F)
constructor             Colors(B, B, F), NextWord
continue                Colors(F)
copy                    Colors(F)
cos                     Colors(F)
createdir               Colors(F)
crt                     Colors(F)
cs                      Colors(C)
cseg                    Colors(F)
cursorto                Colors(F)
cwd                     Colors(F)
cx                      Colors(E)
daa                     Colors(F)
das                     Colors(F)
db                      Colors(B, F), PrevWord, NextWord
dd                      Colors(B, F), PrevWord, NextWord
dec                     Colors(F)
delay                   Colors(F)
delete                  Colors(F)
delline                 Colors(F)
dest                    Colors(C)
destructor              Colors(B)
detectgraph             Colors(F)
dh                      Colors(E)
di                      Colors(E)
diskfree                Colors(F)
disksize                Colors(F)
dispose                 Colors(F)
div                     Colors(F)
dl                      Colors(E)
do                      Colors(C)
done                    Colors(F)
donememory              Colors(F)
donewincrt              Colors(F)
dos                     Colors(F)
dosexitcode             Colors(F)
dosversion              Colors(F)
double                  Colors(F)
downto                  Colors(F)
drawpoly                Colors(F)
ds                      Colors(C)
dseg                    Colors(F)
dup                     Colors(E, E, F), NextWord
dw                      Colors(B, F), PrevWord, NextWord
dword                   Colors(B)
dx                      Colors(E)
ellipse                 Colors(F)
else                    Colors(E)
end                     Colors(D)
endm                    Colors(C)
endp                    Colors(B, F), PrevWord
ends                    Colors(C)
enter                   Colors(F)
envcount                Colors(F)
envstr                  Colors(F)
eof                     Colors(F)
eoln                    Colors(F)
equ                     Colors(E, F), PrevWord
erase                   Colors(F)
es                      Colors(C)
esc                     Colors(F)
exec                    Colors(F)
exit                    Colors(C)
exp                     Colors(F)
export                  Colors(F)
exports                 Colors(F)
extended                Colors(F)
external                Colors(F)
extrn                   Colors(F), NextWord
false                   Colors(C)
far                     Colors(C)
fexpand                 Colors(F)
file                    Colors(F)
fileexpand              Colors(F)
filepos                 Colors(F)
filesearch              Colors(F)
filesize                Colors(F)
filesplit               Colors(F)
fillchar                Colors(F)
fillellipse             Colors(F)
fillpoly                Colors(F)
findfirst               Colors(F)
findnext                Colors(F)
floatnum                Colors(B)
floodfill               Colors(F)
flush                   Colors(F)
for                     Colors(E)
forward                 Colors(F)
frac                    Colors(F)
freemem                 Colors(F)
freemultisel            Colors(F)
fs                      Colors(C)
fsearch                 Colors(F)
fsplit                  Colors(F)
function                Colors(B, B, F), NextWord
getarccoords            Colors(F)
getargcount             Colors(F)
getargstr               Colors(F)
getaspectratio          Colors(F)
getbkcolor              Colors(F)
getcbreak               Colors(F)
getcolor                Colors(F)
getcurdir               Colors(F)
getdefaultpalette       Colors(F)
getdir                  Colors(F)
getdrivername           Colors(F)
getenv                  Colors(F)
getenvvar               Colors(F)
getfattr                Colors(F)
getfillpattern          Colors(F)
getfillsettings         Colors(F)
getftime                Colors(F)
getgraphmode            Colors(F)
getimage                Colors(F)
getintvec               Colors(F)
getlinesettings         Colors(F)
getmaxcolor             Colors(F)
getmaxmode              Colors(F)
getmaxx                 Colors(F)
getmaxy                 Colors(F)
getmem                  Colors(F)
getmodename             Colors(F)
getmoderange            Colors(F)
getpalette              Colors(F)
getpalettesize          Colors(F)
getpixel                Colors(F)
gettextsettings         Colors(F)
getverify               Colors(F)
getviewsettings         Colors(F)
getx                    Colors(F)
gety                    Colors(F)
goto                    Colors(F)
gotoxy                  Colors(F)
graph                   Colors(F)
graph3                  Colors(F)
grapherrormsg           Colors(F)
graphresult             Colors(F)
gs                      Colors(C)
halt                    Colors(F)
hi                      Colors(F)
high                    Colors(B)
highvideo               Colors(F)
hlt                     Colors(F)
idiv                    Colors(F)
if                      Colors(E)
imagesize               Colors(F)
implementation          Colors(F)
imul                    Colors(F)
in                      Colors(F)
inc                     Colors(F)
include                 Colors(F)
index                   Colors(F)
inherited               Colors(F)
initgraph               Colors(F)
initmemory              Colors(F)
initwincrt              Colors(F)
inline                  Colors(F)
ins                     Colors(F)
insert                  Colors(F)
insline                 Colors(F)
installuserdriver       Colors(F)
installuserfont         Colors(F)
int                     Colors(B), NextWord
integer                 Colors(B)
interface               Colors(F)
interrupt               Colors(F)
into                    Colors(F)
intr                    Colors(F)
ioresult                Colors(F)
iret                    Colors(C)
ja                      Colors(B), NextWord
jae                     Colors(B), NextWord
jb                      Colors(B), NextWord
jbe                     Colors(B), NextWord
jc                      Colors(B), NextWord
jcxz                    Colors(B), NextWord
je                      Colors(B), NextWord
jg                      Colors(B), NextWord
jge                     Colors(B), NextWord
jl                      Colors(B), NextWord
jle                     Colors(B), NextWord
jmp                     Colors(B), NextWord
jna                     Colors(B), NextWord
jnae                    Colors(B), NextWord
jnbe                    Colors(B), NextWord
jnc                     Colors(B), NextWord
jne                     Colors(B), NextWord
jng                     Colors(B), NextWord
jnge                    Colors(B), NextWord
jnl                     Colors(B), NextWord
jnle                    Colors(B), NextWord
jno                     Colors(B), NextWord
jnp                     Colors(B), NextWord
jns                     Colors(B), NextWord
jnz                     Colors(B), NextWord
jo                      Colors(B), NextWord
jp                      Colors(B), NextWord
jpe                     Colors(B), NextWord
jpo                     Colors(B), NextWord
js                      Colors(B), NextWord
jump                    Colors(C)
jz                      Colors(B), NextWord
keep                    Colors(F)
keypressed              Colors(F)
label                   Colors(F), PrevWord, NextWord
lahf                    Colors(F)
lds                     Colors(F)
lea                     Colors(F)
leave                   Colors(F)
length                  Colors(F)
les                     Colors(F)
library                 Colors(F)
line                    Colors(F)
linerel                 Colors(F)
lineto                  Colors(F)
ln                      Colors(F)
lo                      Colors(F)
lock                    Colors(F)
lods                    Colors(F)
lodsb                   Colors(F)
lodsw                   Colors(F)
longbool                Colors(B)
longdiv                 Colors(F)
longint                 Colors(B)
longmul                 Colors(F)
loop                    Colors(B), NextWord
loope                   Colors(B), NextWord
loopne                  Colors(B), NextWord
loopnz                  Colors(B), NextWord
loopz                   Colors(B), NextWord
low                     Colors(B)
lowmemory               Colors(F)
lowvideo                Colors(F)
macro                   Colors(E)
mark                    Colors(F)
maxavail                Colors(F)
mem                     Colors(F)
memalloc                Colors(F)
memallocseg             Colors(F)
memavail                Colors(F)
meml                    Colors(F)
memw                    Colors(F)
mkdir                   Colors(F)
mod                     Colors(F)
mov                     Colors(F)
move                    Colors(F)
moverel                 Colors(F)
moveto                  Colors(F)
movsb                   Colors(F)
movsw                   Colors(F)
msdos                   Colors(F)
mul                     Colors(F)
name                    Colors(F)
near                    Colors(E)
neg                     Colors(F)
new                     Colors(F)
nil                     Colors(F)
nop                     Colors(F)
normvideo               Colors(F)
nosound                 Colors(F)
not                     Colors(C)
object                  Colors(F)
odd                     Colors(F)
on                      Colors(B)
of                      Colors(E)
off                     Colors(C)
offset                  Colors(B, B, E), NextWord
ofs                     Colors(F)
or                      Colors(F)
ord                     Colors(F)
org                     Colors(F)
out                     Colors(F)
outs                    Colors(F)
outtext                 Colors(F)
outtextxy               Colors(F)
overlay                 Colors(F)
ovrclearbuf             Colors(F)
ovrgetbuf               Colors(F)
ovrgetretry             Colors(F)
ovrinit                 Colors(F)
ovrinitems              Colors(F)
ovrsetbuf               Colors(F)
packed                  Colors(F)
packtime                Colors(F)
paramcount              Colors(F)
paramstr                Colors(F)
pascal                  Colors(E)
pi                      Colors(F)
pieslice                Colors(F)
pointer                 Colors(F)
pop                     Colors(F)
popa                    Colors(F)
popf                    Colors(F)
pos                     Colors(F)
pred                    Colors(F)
printer                 Colors(F)
private                 Colors(F)
proc                    Colors(B, F, E), PrevWord, NextWord
procedure               Colors(B, B, F), NextWord
program                 Colors(E, E, F), NextWord
ptr                     Colors(B)
public                  Colors(F), NextWord
push                    Colors(F)
pusha                   Colors(F)
pushf                   Colors(F)
putimage                Colors(F)
putpixel                Colors(F)
qword                   Colors(B)
random                  Colors(F)
randomize               Colors(F)
rcl                     Colors(F)
rcr                     Colors(F)
read                    Colors(F)
readbuf                 Colors(F)
readkey                 Colors(F)
readln                  Colors(F)
real                    Colors(F)
record                  Colors(F)
rectangle               Colors(F)
registerbgidriver       Colors(F)
registerbgifont         Colors(F)
registerodialogs        Colors(F)
registerostdwnds        Colors(F)
registerowindows        Colors(F)
registertype            Colors(F)
registervalidate        Colors(F)
release                 Colors(F)
removedir               Colors(F)
rename                  Colors(F)
rep                     Colors(F), NextWord
repe                    Colors(F), NextWord
repeat                  Colors(C)
repne                   Colors(F), NextWord
repnz                   Colors(F), NextWord
repz                    Colors(F), NextWord
reset                   Colors(F)
resident                Colors(F)
restorecrtmode          Colors(F)
restorememory           Colors(F)
ret                     Colors(C)
retf                    Colors(C)
retn                    Colors(F)
rewrite                 Colors(F)
rmdir                   Colors(F)
rol                     Colors(F)
ror                     Colors(F)
round                   Colors(F)
runerror                Colors(F)
sahf                    Colors(F)
sal                     Colors(F)
sar                     Colors(F)
sbb                     Colors(F)
scasb                   Colors(F)
scasw                   Colors(F)
scrollto                Colors(F)
sector                  Colors(F)
seek                    Colors(F)
seekeof                 Colors(F)
seekeoln                Colors(F)
seg                     Colors(B)
segcs                   Colors(B)
segds                   Colors(B)
seges                   Colors(B)
segment                 Colors(E)
segss                   Colors(B)
set                     Colors(F)
setactivepage           Colors(F)
setallpalette           Colors(F)
setaspectratio          Colors(F)
setbkcolor              Colors(F)
setcbreak               Colors(F)
setcolor                Colors(F)
setcurdir               Colors(F)
setdate                 Colors(F)
setfattr                Colors(F)
setfillpattern          Colors(F)
setfillstyle            Colors(F)
setftime                Colors(F)
setgraphbufsize         Colors(F)
setgraphmode            Colors(F)
setintvec               Colors(F)
setlinestyle            Colors(F)
setpalette              Colors(F)
setrgbpalette           Colors(F)
settextbuf              Colors(F)
settextjustify          Colors(F)
settextstyle            Colors(F)
settime                 Colors(F)
setusercharsize         Colors(F)
setverify               Colors(F)
setviewport             Colors(F)
setvisualpage           Colors(F)
setwritemode            Colors(F)
shl                     Colors(F)
short                   Colors(B), NextWord
shortint                Colors(F)
shr                     Colors(F)
si                      Colors(E)
sin                     Colors(F)
single                  Colors(F)
sizeof                  Colors(F)
sound                   Colors(F)
sp                      Colors(C)
sptr                    Colors(F)
sqr                     Colors(F)
sqrt                    Colors(F)
ss                      Colors(F)
sseg                    Colors(F)
st                      Colors(F)
stc                     Colors(F)
std                     Colors(F)
sti                     Colors(F)
stosb                   Colors(F)
stosw                   Colors(F)
str                     Colors(F)
strcat                  Colors(F)
strcomp                 Colors(F)
strcopy                 Colors(F)
strdispose              Colors(F)
strecopy                Colors(F)
strend                  Colors(F)
string                  Colors(E)
strings                 Colors(E)
strlcat                 Colors(F)
strlcomp                Colors(F)
strlcopy                Colors(F)
strlen                  Colors(F)
strlicomp               Colors(F)
strlower                Colors(F)
strmove                 Colors(F)
strnew                  Colors(F)
strpas                  Colors(F)
strpcopy                Colors(F)
strpos                  Colors(F)
strrscan                Colors(F)
strscan                 Colors(F)
strupper                Colors(F)
sub                     Colors(F)
succ                    Colors(F)
swap                    Colors(F)
swapvectors             Colors(F)
system                  Colors(F)
tbyte                   Colors(F)
test                    Colors(F)
test8086                Colors(F)
test8087                Colors(F)
textbackground          Colors(F)
textcolor               Colors(F)
textheight              Colors(F)
textmode                Colors(F)
textwidth               Colors(F)
then                    Colors(E)
to                      Colors(E)
trackcursor             Colors(F)
true                    Colors(B)
trunc                   Colors(F)
truncate                Colors(F)
turbo3                  Colors(F)
type                    Colors(F)
typeof                  Colors(F)
unit                    Colors(F, F, D), NextWord
unpacktime              Colors(F)
until                   Colors(C)
upcase                  Colors(F)
uses                    Colors(F)
val                     Colors(F)
var                     Colors(F)
virtual                 Colors(F)
wait                    Colors(F)
wherex                  Colors(F)
wherey                  Colors(F)
while                   Colors(C)
winapi                  Colors(F)
wincrt                  Colors(F)
windos                  Colors(F)
window                  Colors(F)
winprn                  Colors(F)
winprocs                Colors(F)
wintypes                Colors(F)
with                    Colors(E)
word                    Colors(B)
wordbool                Colors(B)
write                   Colors(F)
writebuf                Colors(F)
writechar               Colors(F)
writeln                 Colors(F)
xchg                    Colors(F)
xlat                    Colors(F)
xor                     Colors(F)
{                       Colors(A), Quote
|                       Colors(C), Terminator
}                       Colors(A), Terminator, ToStart
~                       Colors(E), Terminator

//* [.prg.spr.mpr.]
!                       Colors(C), Terminator
"                       Colors(D), Quote
#                       Colors(E)
#define                 Colors(B)
#elif                   Colors(B)
#else                   Colors(B)
#endif                  Colors(B)
#ifndef                 Colors(B)
#region                 Colors(B)
#undef                  Colors(B)
$                       Colors(E), Terminator
%                       Colors(C), Terminator
&                       Colors(C), Terminator
&&                      Colors(A), DoubleChar, ToEnd
'                       Colors(D), Quote
(                       Colors(C), Terminator
)                       Colors(C), Terminator
*                       Colors(A), Terminator, ToEnd
+                       Colors(C), Terminator
,                       Colors(C), Terminator
-                       Colors(C), Terminator
->                      Colors(C), DoubleChar
.                       Colors(C), Terminator
.f                      Colors(C), DoubleChar
.t                      Colors(C), DoubleChar
/                       Colors(C), Terminator
0                       Colors(E,H,M), Numeric
1                       Colors(E,H,M), Numeric
2                       Colors(E,H,M), Numeric
3                       Colors(E,H,M), Numeric
4                       Colors(E,H,M), Numeric
5                       Colors(E,H,M), Numeric
6                       Colors(E,H,M), Numeric
7                       Colors(E,H,M), Numeric
8                       Colors(E,H,M), Numeric
9                       Colors(E,H,M), Numeric
:                       Colors(C), Terminator
;                       Colors(C), Terminator
<                       Colors(E), Terminator
=                       Colors(E), Terminator
>                       Colors(E), Terminator
?                       Colors(C), Terminator
@                       Colors(C), Terminator
[                       Colors(C), Terminator
\                       Colors(C), Terminator
]                       Colors(C), Terminator
^                       Colors(C), Terminator
_alignment              Colors(D)
_beautify               Colors(D)
_box                    Colors(D)
_calcmem                Colors(D)
_calcvalue              Colors(D)
_cliptext               Colors(D)
_curobj                 Colors(D)
_dblclick               Colors(D)
_diarydate              Colors(D)
_dos                    Colors(D)
_foxdoc                 Colors(D)
_foxgraph               Colors(D)
_gengraph               Colors(D)
_genmenu                Colors(D)
_genpd                  Colors(D)
_genscrn                Colors(D)
_genxtab                Colors(D)
_indent                 Colors(D)
_lmargin                Colors(D)
_mac                    Colors(D)
_mline                  Colors(D)
_padvance               Colors(D)
_pageno                 Colors(D)
_pbpage                 Colors(D)
_pcolno                 Colors(D)
_pcopies                Colors(D)
_pdriver                Colors(D)
_pecode                 Colors(D)
_peject                 Colors(D)
_pepage                 Colors(D)
_pform                  Colors(D)
_plength                Colors(D)
_plineno                Colors(D)
_ploffset               Colors(D)
_ppitch                 Colors(D)
_pquality               Colors(D)
_pretext                Colors(D)
_pscode                 Colors(D)
_pspacing               Colors(D)
_pwait                  Colors(D)
_rmargin                Colors(D)
_startup                Colors(D)
_tabs                   Colors(D)
_tally                  Colors(D)
_text                   Colors(D)
_throttle               Colors(D)
_transport              Colors(D)
_unix                   Colors(D)
_windows                Colors(D)
_wrap                   Colors(D)
abs                     Colors(F)
accept                  Colors(F)
access                  Colors(F)
acopy                   Colors(F)
acos                    Colors(F)
activate                Colors(F)
additive                Colors(F)
adel                    Colors(F)
adir                    Colors(F)
aelement                Colors(F)
afields                 Colors(F)
afont                   Colors(F)
again                   Colors(F)
ains                    Colors(F)
alen                    Colors(F)
alias                   Colors(F)
all                     Colors(F)
alltrim                 Colors(F)
alternate               Colors(F)
alternative             Colors(F)
american                Colors(F)
and                     Colors(E)
ansi                    Colors(F)
ansitooem               Colors(F)
append                  Colors(F)
application             Colors(F)
array                   Colors(F)
asc                     Colors(F)
ascan                   Colors(F)
ascending               Colors(F)
asin                    Colors(F)
assist                  Colors(F)
asubscript              Colors(F)
at                      Colors(F)
atan                    Colors(F)
atc                     Colors(F)
atcline                 Colors(F)
atline                  Colors(F)
atn2                    Colors(F)
automatic               Colors(F)
autosave                Colors(F)
average                 Colors(F)
bar                     Colors(F)
begin                   Colors(F)
bell                    Colors(F)
between                 Colors(F)
bitmap                  Colors(F)
blank                   Colors(F)
blink                   Colors(F)
blocksize               Colors(F)
bof                     Colors(F)
border                  Colors(F)
bottom                  Colors(F)
box                     Colors(F)
british                 Colors(F)
browse                  Colors(F)
brstatus                Colors(F)
build                   Colors(F)
by                      Colors(F)
calculate               Colors(F)
call                    Colors(F)
cancel                  Colors(F)
capslock                Colors(F)
carry                   Colors(F)
case                    Colors(C)
catalog                 Colors(F)
cdow                    Colors(F)
cdx                     Colors(F)
ceiling                 Colors(F)
center                  Colors(F)
century                 Colors(F)
cerror                  Colors(F)
cga                     Colors(F)
change                  Colors(F)
chr                     Colors(F)
chrsaw                  Colors(F)
chrtran                 Colors(F)
clear                   Colors(F)
clock                   Colors(F)
close                   Colors(F)
cmonth                  Colors(F)
cntbar                  Colors(F)
cntpad                  Colors(F)
col                     Colors(F)
color                   Colors(F)
command                 Colors(F)
compact                 Colors(F)
compatible              Colors(F)
compile                 Colors(F)
completed               Colors(F)
compress                Colors(F)
confirm                 Colors(F)
console                 Colors(F)
continue                Colors(F)
convert                 Colors(F)
copy                    Colors(F)
cos                     Colors(F)
count                   Colors(F)
create                  Colors(F)
ctod                    Colors(F)
curdir                  Colors(F)
currency                Colors(F)
cursor                  Colors(F)
databases               Colors(F)
date                    Colors(F)
day                     Colors(F)
dbf                     Colors(F)
dbtrap                  Colors(F)
deactivate              Colors(F)
debug                   Colors(F)
decimals                Colors(F)
declare                 Colors(F)
default                 Colors(F)
define                  Colors(F)
delete                  Colors(F)
deleted                 Colors(F)
delimiters              Colors(F)
descending              Colors(F)
design                  Colors(F)
development             Colors(F)
device                  Colors(F)
dexport                 Colors(F)
dgen                    Colors(F)
dif                     Colors(F)
difference              Colors(F)
dimension               Colors(F)
dir                     Colors(F)
directory               Colors(F)
disable                 Colors(F)
diskspace               Colors(F)
display                 Colors(F)
dmy                     Colors(F)
do                      Colors(C)
dohistory               Colors(F)
double                  Colors(F)
dow                     Colors(F)
dtoc                    Colors(F)
dtor                    Colors(F)
dtos                    Colors(F)
echo                    Colors(F)
edit                    Colors(F)
ega25                   Colors(F)
ega43                   Colors(F)
eject                   Colors(F)
else                    Colors(E)
empty                   Colors(F)
enable                  Colors(F)
encrypt                 Colors(F)
encryption              Colors(F)
end                     Colors(F)
endcase                 Colors(C)
enddo                   Colors(C)
endif                   Colors(E)
endprintjob             Colors(F)
endscan                 Colors(C)
endtext                 Colors(C)
environment             Colors(F)
eof                     Colors(F)
erase                   Colors(F)
error                   Colors(F)
escape                  Colors(F)
evaluate                Colors(F)
exact                   Colors(F)
exclusive               Colors(F)
exit                    Colors(C)
exp                     Colors(F)
export                  Colors(F)
extended                Colors(F)
external                Colors(F)
fchsize                 Colors(F)
fclose                  Colors(F)
fcount                  Colors(F)
fcreate                 Colors(F)
fdate                   Colors(F)
feof                    Colors(F)
ferror                  Colors(F)
fflush                  Colors(F)
fgets                   Colors(F)
field                   Colors(F)
fields                  Colors(F)
file                    Colors(F)
filer                   Colors(F)
files                   Colors(F)
fill                    Colors(F)
filter                  Colors(F)
find                    Colors(F)
firlds                  Colors(F)
fixed                   Colors(F)
fklabel                 Colors(F)
fkmax                   Colors(F)
fldcount                Colors(F)
float                   Colors(F)
flock                   Colors(F)
floor                   Colors(F)
flush                   Colors(F)
font                    Colors(F)
fontmetric              Colors(F)
fopen                   Colors(F)
for                     Colors(C)
form                    Colors(F)
format                  Colors(F)
found                   Colors(F)
foxplus                 Colors(F)
fputs                   Colors(F)
fread                   Colors(F)
freeze                  Colors(F)
french                  Colors(F)
from                    Colors(F)
fseekf                  Colors(F)
fseek                   Colors(F)
fsize                   Colors(F)
ftime                   Colors(F)
fullpath                Colors(F)
function                Colors(B, B, F), NextWord
fv                      Colors(F)
fw2                     Colors(F)
fwrite                  Colors(F)
gather                  Colors(F)
general                 Colors(F)
german                  Colors(F)
get                     Colors(F)
getbar                  Colors(F)
getdir                  Colors(F)
getenv                  Colors(F)
getexpr                 Colors(F)
getfile                 Colors(F)
getpad                  Colors(F)
gets                    Colors(F)
go                      Colors(C)
gomonth                 Colors(F)
goto                    Colors(C)
group                   Colors(F)
grow                    Colors(F)
halfheight              Colors(F)
having                  Colors(F)
header                  Colors(F)
heading                 Colors(F)
headings                Colors(F)
height                  Colors(F)
help                    Colors(F)
helpfilter              Colors(F)
hide                    Colors(F)
history                 Colors(F)
home                    Colors(F)
hours                   Colors(F)
id                      Colors(F)
if                      Colors(E)
iif                     Colors(F)
import                  Colors(F)
in                      Colors(F)
index                   Colors(F)
indexes                 Colors(F)
information             Colors(F)
inkey                   Colors(F)
inlist                  Colors(F)
input                   Colors(F)
insert                  Colors(F)
insmode                 Colors(F)
instruct                Colors(F)
int                     Colors(F)
intensity               Colors(F)
into                    Colors(F)
isalpha                 Colors(F)
isblank                 Colors(F)
iscolor                 Colors(F)
isdigit                 Colors(F)
islower                 Colors(F)
ismarked                Colors(F)
isometric               Colors(F)
isupper                 Colors(F)
italian                 Colors(F)
japan                   Colors(F)
join                    Colors(F)
key                     Colors(F)
keyboard                Colors(F)
keycomp                 Colors(F)
label                   Colors(F)
last                    Colors(F)
lastkey                 Colors(F)
ledit                   Colors(F)
left                    Colors(F)
len                     Colors(F)
library                 Colors(F)
like                    Colors(F)
lineno                  Colors(F)
link                    Colors(F)
list                    Colors(F)
lksys                   Colors(F)
load                    Colors(F)
locate                  Colors(F)
locfile                 Colors(F)
lock                    Colors(F)
log                     Colors(F)
log10                   Colors(F)
logerrors               Colors(F)
logout                  Colors(F)
lookup                  Colors(F)
loop                    Colors(C)
lower                   Colors(F)
lpartition              Colors(F)
ltrim                   Colors(F)
lupdate                 Colors(F)
mackey                  Colors(F)
macro                   Colors(F)
macros                  Colors(F)
margin                  Colors(F)
mark                    Colors(F)
max                     Colors(F)
mcol                    Colors(F)
mdi                     Colors(F)
mdown                   Colors(F)
mdx                     Colors(F)
mdy                     Colors(F)
memlines                Colors(F)
memo                    Colors(F)
memory                  Colors(F)
memowidth               Colors(F)
memvar                  Colors(F)
menu                    Colors(F)
menus                   Colors(F)
message                 Colors(F)
messages                Colors(F)
min                     Colors(F)
minimize                Colors(F)
mline                   Colors(F)
mod                     Colors(F)
modify                  Colors(F)
mono                    Colors(F)
month                   Colors(F)
mouse                   Colors(F)
move                    Colors(F)
mrkbar                  Colors(F)
mrkpad                  Colors(F)
mrow                    Colors(F)
multilocks              Colors(F)
multiselect             Colors(F)
mwindow                 Colors(F)
ndx                     Colors(F)
near                    Colors(F)
network                 Colors(F)
next                    Colors(F)
noappend                Colors(F)
noclear                 Colors(F)
noclose                 Colors(F)
noconsole               Colors(F)
nodebug                 Colors(F)
nodelete                Colors(F)
noedit                  Colors(F)
noeject                 Colors(F)
nofloat                 Colors(F)
nofollow                Colors(F)
nogrow                  Colors(F)
noinit                  Colors(F)
nolink                  Colors(F)
nolock                  Colors(F)
nolog                   Colors(F)
nomdi                   Colors(F)
nomenu                  Colors(F)
nominimize              Colors(F)
nomodify                Colors(F)
nomouse                 Colors(F)
none                    Colors(F)
nooptimize              Colors(F)
noorganize              Colors(F)
nooverwrite             Colors(F)
normal                  Colors(F)
nosave                  Colors(F)
noshow                  Colors(F)
not                     Colors(C)
note                    Colors(A), ToEnd
notify                  Colors(F)
noupdate                Colors(F)
nowait                  Colors(F)
nozoom                  Colors(F)
number                  Colors(F)
numlock                 Colors(F)
objnum                  Colors(F)
occurs                  Colors(F)
odometer                Colors(F)
oemtoansi               Colors(F)
of                      Colors(F)
off                     Colors(F)
on                      Colors(F)
optimize                Colors(F)
or                      Colors(E)
order                   Colors(F)
os                      Colors(F)
otherwise               Colors(C)
pack                    Colors(F)
pad                     Colors(F)
padc                    Colors(F)
padl                    Colors(F)
padr                    Colors(F)
page                    Colors(F)
palette                 Colors(F)
panel                   Colors(F)
parameters              Colors(F)
path                    Colors(F)
pattern                 Colors(F)
pause                   Colors(F)
payment                 Colors(F)
pcol                    Colors(F)
pcount                  Colors(F)
pdox                    Colors(F)
pdsetup                 Colors(F)
pen                     Colors(F)
pi                      Colors(F)
picture                 Colors(F)
plain                   Colors(F)
play                    Colors(F)
point                   Colors(F)
pop                     Colors(F)
popup                   Colors(F)
popups                  Colors(F)
precision               Colors(F)
preference              Colors(F)
preview                 Colors(F)
printer                 Colors(F)
printjob                Colors(F)
printstatus             Colors(F)
private                 Colors(F)
prmbar                  Colors(F)
prmpad                  Colors(F)
procedure               Colors(B, B, F), NextWord
production              Colors(F)
program                 Colors(F)
prompt                  Colors(F)
proper                  Colors(F)
protect                 Colors(F)
prow                    Colors(F)
public                  Colors(F)
push                    Colors(F)
pv                      Colors(F)
query                   Colors(F)
quit                    Colors(C)
rand                    Colors(F)
rat                     Colors(F)
ratline                 Colors(F)
rdlevel                 Colors(F)
read                    Colors(F)
readerror               Colors(F)
readkey                 Colors(F)
recall                  Colors(F)
reccount                Colors(F)
recno                   Colors(F)
record                  Colors(F)
recsize                 Colors(F)
redit                   Colors(F)
refresh                 Colors(F)
regional                Colors(F)
reindex                 Colors(F)
relation                Colors(F)
release                 Colors(F)
rename                  Colors(F)
replace                 Colors(F)
replicate               Colors(F)
report                  Colors(F)
reprocess               Colors(F)
reset                   Colors(F)
resource                Colors(F)
rest                    Colors(F)
restore                 Colors(F)
resume                  Colors(F)
retry                   Colors(F)
return                  Colors(C)
right                   Colors(F)
rlock                   Colors(F)
rollback                Colors(F)
round                   Colors(F)
row                     Colors(F)
rpd                     Colors(F)
rtod                    Colors(F)
rtrim                   Colors(F)
run                     Colors(F)
safety                  Colors(F)
same                    Colors(F)
sample                  Colors(F)
save                    Colors(F)
say                     Colors(F)
scan                    Colors(C)
scatter                 Colors(F)
scheme                  Colors(F)
scols                   Colors(F)
scoreboard              Colors(F)
screen                  Colors(F)
screens                 Colors(F)
scroll                  Colors(F)
sdf                     Colors(F)
seconds                 Colors(F)
seek                    Colors(F)
select                  Colors(F)
selection               Colors(F)
separator               Colors(F)
set                     Colors(F)
shadow                  Colors(F)
shadows                 Colors(F)
show                    Colors(F)
sign                    Colors(F)
sin                     Colors(F)
single                  Colors(F)
size                    Colors(F)
skip                    Colors(F)
skpbar                  Colors(F)
sort                    Colors(F)
soundex                 Colors(F)
space                   Colors(F)
spppad                  Colors(F)
sql                     Colors(F)
sqrt                    Colors(F)
srows                   Colors(F)
status                  Colors(F)
step                    Colors(F)
sticky                  Colors(F)
store                   Colors(F)
str                     Colors(F)
stretch                 Colors(F)
strtran                 Colors(F)
structure               Colors(F)
stuff                   Colors(F)
style                   Colors(F)
substr                  Colors(F)
sum                     Colors(F)
summary                 Colors(F)
suspend                 Colors(F)
sylk                    Colors(F)
sys                     Colors(F)
sysmenu                 Colors(F)
sysmetric               Colors(F)
tab                     Colors(F)
tag                     Colors(F)
tagcount                Colors(F)
tagno                   Colors(F)
talk                    Colors(F)
tan                     Colors(F)
target                  Colors(F)
text                    Colors(C)
textmerge               Colors(F)
time                    Colors(F)
timeout                 Colors(F)
title                   Colors(F)
titles                  Colors(F)
to                      Colors(F)
top                     Colors(F)
topic                   Colors(F)
total                   Colors(F)
transaction             Colors(F)
transform               Colors(F)
trap                    Colors(F)
trbetween               Colors(F)
trim                    Colors(F)
type                    Colors(F)
typeahead               Colors(F)
udfparms                Colors(F)
union                   Colors(F)
unique                  Colors(F)
unlock                  Colors(F)
update                  Colors(F)
updated                 Colors(F)
upper                   Colors(F)
usa                     Colors(F)
use                     Colors(F)
used                    Colors(F)
user                    Colors(F)
users                   Colors(F)
val                     Colors(F)
valid                   Colors(F)
varread                 Colors(F)
verb                    Colors(F)
version                 Colors(F)
vga25                   Colors(F)
vga50                   Colors(F)
view                    Colors(F)
wait                    Colors(F)
wborder                 Colors(F)
wchild                  Colors(F)
wcols                   Colors(F)
wexist                  Colors(F)
while                   Colors(C)
width                   Colors(F)
window                  Colors(F)
windows                 Colors(F)
with                    Colors(F)
wk1                     Colors(F)
wk3                     Colors(F)
wks                     Colors(F)
wlast                   Colors(F)
wlcol                   Colors(F)
wlrow                   Colors(F)
wmaximum                Colors(F)
wminimum                Colors(F)
wontop                  Colors(F)
woutput                 Colors(F)
wparent                 Colors(F)
wr1                     Colors(F)
wread                   Colors(F)
wrk                     Colors(F)
wrows                   Colors(F)
wtitle                  Colors(F)
wvisible                Colors(F)
xls                     Colors(F)
year                    Colors(F)
ymd                     Colors(F)
zap                     Colors(F)
zoom                    Colors(F)
{                       Colors(C), Terminator
|                       Colors(C), Terminator
}                       Colors(C), Terminator
~                       Colors(C), Terminator

//* [.csh.]
(                       Colors(F), Quote
,                       Colors(E), Terminator
//                      Colors(A), DoubleChar, ToEnd
0                       Colors(E), Numeric
1                       Colors(E), Numeric
2                       Colors(E), Numeric
3                       Colors(E), Numeric
4                       Colors(E), Numeric
5                       Colors(E), Numeric
6                       Colors(E), Numeric
7                       Colors(E), Numeric
8                       Colors(E), Numeric
9                       Colors(E), Numeric
Colors                  Colors(D)
DoubleChar              Colors(D)
Inclusive               Colors(C)
NextWord                Colors(D)
Numeric                 Colors(D)
PrevWord                Colors(D)
Quote                   Colors(D)
SingleChar              Colors(D)
Terminator              Colors(C)
ToEnd                   Colors(D)
ToStart                 Colors(D)
WholeWord               Colors(D)
