/*
   CPPTask - A Multitasking Kernel For C++

   Version 1.0 08-12-91

   Ported by Rich Smith from:

   Public Domain Software written by
      Thomas Wagner
      Patschkauer Weg 31
      D-1000 Berlin 33
      West Germany

   TSKFLG.CPP - Flag handling routines.

   Subroutines:
        flag::flag
        flag::~flag
        flag::set_flag
        flag::clear_flag
        flag::wait_flag_set
        flag::wait_flag_clear
        flag::clear_flag_wait_set
        flag::check_flag

*/

#include <stdio.h>

#include "task.hpp"
#include "tsklocal.hpp"


/*
   flag - initialises flag.
*/

flag::flag (void)
{
   flags = 0;

   wait_set = wait_clear = NULL;
   state = 0;
}

/*
   ~flag - kills all processes waiting for flag
*/

flag::~flag (void)
{
   CRITICAL;

   C_ENTER;

   tsk_kill_queue (&wait_set);
   tsk_kill_queue (&wait_clear);
   state = 0;
   C_LEAVE;
}


/*
   wait_flag_set  - Wait until flag is != 0. If flag is != 0 on
                    entry, the task continues to run.
*/

int far flag::wait_flag_set (dword timeout)
{
   CRITICAL;

   C_ENTER;
   if (state)
      {
      C_LEAVE;
      return 0;
      }
   tsk_current->set_retptr(NULL);
   tsk_wait (&wait_set, timeout);
   return (int)tsk_current->get_retptr();
}


/*
   wait_flag_clear - Wait until flag is == 0. If flag is == 0 on
                     entry, the task continues to run.
*/

int far flag::wait_flag_clear (dword timeout)
{
   CRITICAL;

   C_ENTER;
   if (!state)
      {
      C_LEAVE;
      return 0;
      }

   tsk_current->set_retptr(NULL);
   tsk_wait (&wait_clear, timeout);
   return (int)tsk_current->get_retptr();
}


/*
   set_flag - Set flag to 1. If there are tasks waiting for the
              set state, all tasks in the queue are made eligible.
*/

void far flag::set_flag (void)
{
   CRITICAL;

   C_ENTER;
   state = 1;

   while (wait_set != NULL)
      wait_set = wait_set->tsk_runable ();
   C_LEAVE;
}


/*
   clear_flag - Set flag to 0. If there are tasks waiting for the
                clear state, all tasks in the queue are made eligible.
*/

void far flag::clear_flag (void)
{
   CRITICAL;

   C_ENTER;
   state = 0;

   while (wait_clear != NULL)
      wait_clear = wait_clear->tsk_runable ();

   C_LEAVE;
}


/*
   clear_flag_wait_set - Set flag to 0, then wait for set state.
*/

int far flag::clear_flag_wait_set (dword timeout)
{
   clear_flag ();
   return wait_flag_set (timeout);
}


/*
   check_flag - return current flag state.
*/

int far flag::check_flag (void)
{
   return state;
}


void far asm_set_flag(flagptr flg)
{
    flg->set_flag();
}


void far asm_clear_flag(flagptr flg)
{
    flg->clear_flag();
}

int far asm_wait_flag_clear(flagptr flg, dword timeout)
{
    return flg->wait_flag_clear(timeout);
}
