//
// Test program for checking basic CPPTask functions.
//


#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <string.h>
#include <ctype.h>
#include <time.h>
#include <dos.h>

#include "task.hpp"
#include "tsklocal.hpp"


#define STACKSIZE 2048

unsigned int _stklen = 5 * STACKSIZE;  /* Four tasks + main Task Stack */

void far task1 (void);
local char stack1 [STACKSIZE];
local task tcb1((funcptr)task1, (byteptr)stack1, STACKSIZE, PRI_STD, NULL);

void far task2 (void);
local char stack2 [STACKSIZE];
local task tcb2((funcptr)task2, (byteptr)stack2, STACKSIZE, PRI_STD, NULL);

void far task3 (void);
local char stack3 [STACKSIZE];
local task tcb3((funcptr)task3, (byteptr)stack3, STACKSIZE, PRI_STD, NULL);

void far task4 (void);
local char stack4 [STACKSIZE];
local task tcb4((funcptr)task4, (byteptr)stack4, STACKSIZE, PRI_STD, NULL);

// declare all necessary data structures for inter-task communication

typedef struct {
               farptr xx;
               char str [20];
               } message;         // message structure for mailbox

byte pipbuf [10];                 // buffer area for pipe
word bufbuf [40];                 // buffer area for buffer

mailbox box;                      // create mailbox ...
message msg;                      //  and instance of message struct
flag halt, clockflag;             // create flag
pipe pip((farptr) pipbuf, sizeof(pipbuf));      // create pipe
buffer buf((farptr) bufbuf, sizeof(bufbuf));    // create buffer

int endrun;

//
// Task1 sends a mail to Task3, and waits for a response in the buffer.
// The response is then displayed.
// Task1 will stop while the halt flag is set.
//

void far task1 (void)
{
   char str [20];

   printf ("Task 1 started\n");
   while (!endrun)    // run till completion signalled
      {
      halt.wait_flag_clear (0L);

      t_delay (5L);   // delay for 5 clock ticks
      printf ("Task 1 Sending Message to Task 3\n");
      strcpy (msg.str, "From T1");
      box.send_mail (&msg);

      buf.read_buffer (str, 20, 0L);
      printf("Buffer data received %s \n", str);
      }
}

/*
   Task2 reads the keyboard. If a character has been read, it is passed
   to Task4 via a pipe. Entering 'h' will set the halt flag (stopping Task1),
   entering 'c' will clear the halt flag.
   'e' stops the program.
*/

void far task2 (void)
{
   int ch;

   printf ("Task 2 started\n");
   while (!endrun)
      {
      ch = t_read_key () & 0xff;
      switch (tolower (ch))
         {
         case 'h':   halt.set_flag ();
                     break;
         case 'c':   halt.clear_flag ();
                     break;
         case 'e':   main_tcb.wake_task ();
                     break;
         case 'b':   sound (2000);
                     t_delay (2L);
                     nosound ();
                     break;
         }

      if (!endrun)
         pip.write_pipe ((char)ch, 0L);
      putch ('2');
      }
}

/*
   Task3 waits for mail, then sends it back through a buffer.
*/

void far task3 (void)
{
   message far *m;

   printf ("Task 3 started\n");
   while (!endrun)
      {
      m = (message far *) box.wait_mail (0L);
      printf ("Task 3 Msg received %s \n", m->str);
      m->str [6] = '3';
      buf.write_buffer (m->str, 7, 0L);
      }
}


/*
   Task4 waits for a character in the pipe and displays it. To make
   things livelier, it uses a timeout while waiting, and will display
   faces when the timeout occurred before the character.
*/

void far task4 (void)
{
   int ch;

   printf ("Task 4 started\n");
   while (!endrun)
      {
      ch = pip.read_pipe (10L);
      if (ch < 0)
         putch (0x02);
      else
         printf ("Task 4 got - %c\n", ch);
      }
}

// NOTE, the scheduler and a few standard tasks are create automatically
//    before the start of main()

int main (void)
{
   endrun = 0;

   tcb1.start_task ();          // start all tasks
   tcb2.start_task();
   tcb3.start_task ();
   tcb4.start_task();

   tasker.preempt_on ();       // turn preemption on

   t_delay (0L);               // delay main task so that others can run

// if we get here something has cause the main task to run and we
// will terminate processing

   endrun = 1;
   puts ("******** Main Task *********");

   main_tcb.set_priority (10);  // lower priority to allow other tasks to
                                // termiate processing

   tasker.schedule ();          // explicit call to scheduler
   tasker.preempt_off ();       // turn preemption off

   puts ("******** End Run *********");

   return 0;
}


