#include <iostream.h>
#include "compress.h"
#include "decpress.h"

int main(int argc, char *argv[])
	{
	if (argc!=4)
		{
		cout<< "Usage: cp <c | d> <file in> <file out>\n";
		return 1;
		}
	switch (argv[1][0])
		{
		case 'c':
		case 'C':
			{
#ifdef VMS
            ifstream fi(argv[2],ios::in);
#else
            ifstream fi(argv[2],ios::in | ios::binary);
#endif
			if (fi.bad())
				{
				cout<<"Can't open input file\n";
				return 1;
				}
			fi.flags(0);			// clear \n translation
			cpofstream fo(argv[3]);
			if (fo.bad())
				{
				cout<<"Can't open output file\n";
				return 1;
				}

			char c;
			for (;;)
				{
				fi>>c;
				if (fi.eof())
					break;
				fo<<c;
				}
			fi.close();
			fo.close();
			break;
			}
		case 'd':
		case 'D':
			{
			cpifstream fi(argv[2]);
			if (fi.bad())
				{
				cout<<"Can't open input file\n";
				return 1;
				}
#ifdef VMS
            ofstream fo(argv[3],ios::out);
#else
            ofstream fo(argv[3],ios::out | ios::binary);
#endif
			if (fo.bad())
				{
				cout<<"Can't open output file\n";
				return 1;
				}

			char c;
			for (;;)
				{
				fi>>c;
                if (fi.done())      // can't use EOF on binary files ???
                    break;
				fo<<c;
				}
			fi.close();
			fo.close();
			break;
			}
		default:
			cout<< "Usage: cp <c | d> <file in> <file out>\n";
			return 1;
		}

#ifdef VMS
    return 1;
#else
    return 0;
#endif
	}

